/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncLogWithBaseDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncLogWithBaseLongToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncLnDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncLnLongToDouble;
import org.apache.hadoop.hive.ql.udf.UDFMath;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

@Description(name="log", value="_FUNC_([b], x) - Returns the logarithm of x with base b", extended="Example:\n  > SELECT _FUNC_(13, 13) FROM src LIMIT 1;\n  1")
@VectorizedExpressions(value={FuncLogWithBaseLongToDouble.class, FuncLogWithBaseDoubleToDouble.class, FuncLnLongToDouble.class, FuncLnDoubleToDouble.class})
public class UDFLog
extends UDFMath {
    private final DoubleWritable result = new DoubleWritable();

    public DoubleWritable evaluate(DoubleWritable base, DoubleWritable a) {
        if (a == null || base == null) {
            return null;
        }
        return this.log(base.get(), a.get());
    }

    public DoubleWritable evaluate(HiveDecimalWritable baseWritable, HiveDecimalWritable writable) {
        if (baseWritable == null || writable == null) {
            return null;
        }
        double base = baseWritable.doubleValue();
        double d = writable.doubleValue();
        return this.log(base, d);
    }

    @Override
    protected DoubleWritable doEvaluate(DoubleWritable a) {
        if (a.get() <= 0.0) {
            return null;
        }
        this.result.set(StrictMath.log(a.get()));
        return this.result;
    }

    private DoubleWritable log(double base, double input) {
        if (base <= 1.0 || input <= 0.0) {
            return null;
        }
        this.result.set(StrictMath.log(input) / StrictMath.log(base));
        return this.result;
    }
}

