/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.ogc.OGCGeometry;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.udf.esri.GeometryUtils;
import org.apache.hadoop.hive.ql.udf.esri.LogUtils;
import org.apache.hadoop.hive.ql.udf.esri.ST_GeometryAccessor;
import org.apache.hadoop.hive.ql.udf.esri.ST_IsClosed;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="ST_NumPoints", value="_FUNC_(geometry) - return the number of points in the geometry", extended="Example:\n  > SELECT _FUNC_(ST_Point(1.5, 2.5)) FROM src LIMIT 1;  -- 1\n  > SELECT _FUNC_(ST_LineString(1.5,2.5, 3.0,2.2)) FROM src LIMIT 1;  -- 2\n  > SELECT _FUNC_(ST_GeomFromText('polygon ((0 0, 10 0, 0 10, 0 0))')) FROM src LIMIT 1;  -- 4\n")
public class ST_NumPoints
extends ST_GeometryAccessor {
    final IntWritable resultInt = new IntWritable();
    static final Logger LOG = LoggerFactory.getLogger((String)ST_IsClosed.class.getName());

    public IntWritable evaluate(BytesWritable geomref) {
        if (geomref == null || geomref.getLength() == 0) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        OGCGeometry ogcGeometry = GeometryUtils.geometryFromEsriShape(geomref);
        if (ogcGeometry == null) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        Geometry esriGeom = ogcGeometry.getEsriGeometry();
        switch (esriGeom.getType()) {
            case Point: {
                this.resultInt.set(esriGeom.isEmpty() ? 0 : 1);
                break;
            }
            case MultiPoint: {
                this.resultInt.set(((MultiPoint)esriGeom).getPointCount());
                break;
            }
            case Polygon: {
                Polygon polygon = (Polygon)esriGeom;
                this.resultInt.set(polygon.getPointCount() + polygon.getPathCount());
                break;
            }
            default: {
                this.resultInt.set(((MultiPath)esriGeom).getPointCount());
            }
        }
        return this.resultInt;
    }
}

