/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFVariantGet;

@Description(name="try_variant_get", value="_FUNC_(variant, path[, type]) - Extracts a sub-variant from variant according to path, and casts it to type. Returns null on error.", extended="Example:\n> SELECT _FUNC_(parse_json('{\"a\": 1}'), '$.a', 'int');\n1\n> SELECT _FUNC_(parse_json('[1, \"hello\"]'), '$[1]', 'int');\nNULL")
public class GenericUDFTryVariantGet
extends GenericUDFVariantGet {
    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        try {
            return super.evaluate(arguments);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getDisplayString(String[] children) {
        return "try_variant_get(" + String.join((CharSequence)", ", children) + ")";
    }
}

