/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.auth;

import java.util.Map;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.rest.HTTPHeaders;
import org.apache.iceberg.rest.RESTClient;
import org.apache.iceberg.rest.auth.AuthManager;
import org.apache.iceberg.rest.auth.AuthSession;
import org.apache.iceberg.rest.auth.DefaultAuthSession;
import org.apache.iceberg.rest.auth.OAuth2Util;

public final class BasicAuthManager
implements AuthManager {
    public BasicAuthManager(String ignored) {
    }

    @Override
    public AuthSession catalogSession(RESTClient sharedClient, Map<String, String> properties) {
        Preconditions.checkArgument(properties.containsKey("rest.auth.basic.username"), "Invalid username: missing required property %s", (Object)"rest.auth.basic.username");
        Preconditions.checkArgument(properties.containsKey("rest.auth.basic.password"), "Invalid password: missing required property %s", (Object)"rest.auth.basic.password");
        String username = properties.get("rest.auth.basic.username");
        String password = properties.get("rest.auth.basic.password");
        String credentials = username + ":" + password;
        return DefaultAuthSession.of(HTTPHeaders.of(OAuth2Util.basicAuthHeaders(credentials)));
    }

    @Override
    public void close() {
    }
}

