/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import java.io.IOException;
import org.apache.hive.iceberg.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.hive.iceberg.com.fasterxml.jackson.databind.JsonNode;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.JsonUtil;
import org.apache.iceberg.view.ImmutableSQLViewRepresentation;
import org.apache.iceberg.view.SQLViewRepresentation;

class SQLViewRepresentationParser {
    private static final String SQL = "sql";
    private static final String DIALECT = "dialect";

    private SQLViewRepresentationParser() {
    }

    static String toJson(SQLViewRepresentation sqlViewRepresentation) {
        return JsonUtil.generate(gen -> SQLViewRepresentationParser.toJson(sqlViewRepresentation, gen), false);
    }

    static void toJson(SQLViewRepresentation view, JsonGenerator generator) throws IOException {
        Preconditions.checkArgument(view != null, "Invalid SQL view representation: null");
        generator.writeStartObject();
        generator.writeStringField("type", view.type());
        generator.writeStringField(SQL, view.sql());
        generator.writeStringField(DIALECT, view.dialect());
        generator.writeEndObject();
    }

    static SQLViewRepresentation fromJson(String json) {
        return JsonUtil.parse(json, SQLViewRepresentationParser::fromJson);
    }

    static SQLViewRepresentation fromJson(JsonNode node) {
        Preconditions.checkArgument(node != null, "Cannot parse SQL view representation from null object");
        Preconditions.checkArgument(node.isObject(), "Cannot parse SQL view representation from non-object: %s", (Object)node);
        ImmutableSQLViewRepresentation.Builder builder = ImmutableSQLViewRepresentation.builder().sql(JsonUtil.getString(SQL, node)).dialect(JsonUtil.getString(DIALECT, node));
        return builder.build();
    }
}

