/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.sarg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hive.common.util.SuppressFBWarnings;

public class ExpressionTree {
    private final Operator operator;
    private final List<ExpressionTree> children;
    private final PredicateLeaf leaf;
    private final SearchArgument.TruthValue constant;

    ExpressionTree() {
        this.operator = null;
        this.children = null;
        this.leaf = null;
        this.constant = null;
    }

    ExpressionTree(Operator op, ExpressionTree ... kids) {
        this.operator = op;
        this.children = new ArrayList<ExpressionTree>();
        this.leaf = null;
        this.constant = null;
        Collections.addAll(this.children, kids);
    }

    ExpressionTree(PredicateLeaf leaf) {
        this.operator = Operator.LEAF;
        this.children = null;
        this.leaf = leaf;
        this.constant = null;
    }

    ExpressionTree(SearchArgument.TruthValue constant) {
        this.operator = Operator.CONSTANT;
        this.children = null;
        this.leaf = null;
        this.constant = constant;
    }

    ExpressionTree(ExpressionTree other) {
        this.operator = other.operator;
        if (other.children == null) {
            this.children = null;
        } else {
            this.children = new ArrayList<ExpressionTree>();
            for (ExpressionTree child : other.children) {
                this.children.add(new ExpressionTree(child));
            }
        }
        this.leaf = other.leaf;
        this.constant = other.constant;
    }

    public SearchArgument.TruthValue evaluate(SearchArgument.TruthValue[] leaves) {
        SearchArgument.TruthValue result = null;
        switch (this.operator.ordinal()) {
            case 0: {
                for (ExpressionTree child : this.children) {
                    result = child.evaluate(leaves).or(result);
                }
                return result;
            }
            case 1: {
                for (ExpressionTree child : this.children) {
                    result = child.evaluate(leaves).and(result);
                }
                return result;
            }
            case 2: {
                return this.children.get(0).evaluate(leaves).not();
            }
            case 3: {
                return leaves[this.leaf.getId()];
            }
            case 4: {
                return this.constant;
            }
        }
        throw new IllegalStateException("Unknown operator: " + String.valueOf((Object)this.operator));
    }

    private void buildString(boolean useLeafIds, StringBuilder output) {
        switch (this.operator.ordinal()) {
            case 0: {
                output.append("(or");
                for (ExpressionTree child : this.children) {
                    output.append(' ');
                    child.buildString(useLeafIds, output);
                }
                output.append(')');
                break;
            }
            case 1: {
                output.append("(and");
                for (ExpressionTree child : this.children) {
                    output.append(' ');
                    child.buildString(useLeafIds, output);
                }
                output.append(')');
                break;
            }
            case 2: {
                output.append("(not ");
                this.children.get(0).buildString(useLeafIds, output);
                output.append(')');
                break;
            }
            case 3: {
                output.append("leaf-");
                if (useLeafIds) {
                    output.append(this.leaf.getId());
                    break;
                }
                output.append(this.leaf);
                break;
            }
            case 4: {
                output.append((Object)this.constant);
            }
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.buildString(false, buffer);
        return buffer.toString();
    }

    public String toOldString() {
        StringBuilder buffer = new StringBuilder();
        this.buildString(true, buffer);
        return buffer.toString();
    }

    public Operator getOperator() {
        return this.operator;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="intended")
    public List<ExpressionTree> getChildren() {
        return this.children;
    }

    public SearchArgument.TruthValue getConstant() {
        return this.constant;
    }

    public int getLeaf() {
        return this.leaf.getId();
    }

    public PredicateLeaf getPredicateLeaf() {
        return this.leaf;
    }

    public static enum Operator {
        OR,
        AND,
        NOT,
        LEAF,
        CONSTANT;

    }
}

