/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.wrappers.backed;

import java.io.ObjectStreamException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistableObjectType;
import org.datanucleus.flush.MapClearOperation;
import org.datanucleus.flush.MapPutOperation;
import org.datanucleus.flush.MapRemoveOperation;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.BackedSCOStoreManager;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.scostore.MapStore;
import org.datanucleus.store.types.scostore.Store;
import org.datanucleus.store.types.wrappers.backed.BackedSCO;
import org.datanucleus.store.types.wrappers.backed.Collection;
import org.datanucleus.store.types.wrappers.backed.Set;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class Properties
extends org.datanucleus.store.types.wrappers.Properties
implements BackedSCO {
    protected transient MapStore backingStore;
    protected transient boolean allowNulls = false;
    protected transient boolean useCache = true;
    protected transient boolean isCacheLoaded = false;

    public Properties(DNStateManager sm, AbstractMemberMetaData mmd) {
        super(sm, mmd);
        this.delegate = new java.util.Properties();
        this.useCache = SCOUtils.useContainerCache(this.ownerSM, mmd);
        if (!SCOUtils.mapHasSerialisedKeysAndValues(mmd) && mmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
            this.backingStore = (MapStore)((BackedSCOStoreManager)((Object)this.ownerSM.getStoreManager())).getBackingStoreForField(this.ownerSM.getExecutionContext().getClassLoaderResolver(), mmd, Map.class);
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(SCOUtils.getContainerInfoMessage(this.ownerSM, this.ownerMmd.getName(), this, this.useCache, this.allowNulls, SCOUtils.useCachedLazyLoading(this.ownerSM, this.ownerMmd)));
        }
    }

    @Override
    public void initialise(java.util.Properties newValue, Object oldValue) {
        if (newValue != null) {
            if (SCOUtils.mapHasSerialisedKeysAndValues(this.ownerMmd) && (this.ownerMmd.getMap().keyIsPersistent() || this.ownerMmd.getMap().valueIsPersistent())) {
                ExecutionContext ec = this.ownerSM.getExecutionContext();
                for (Map.Entry<Object, Object> entry : newValue.entrySet()) {
                    DNStateManager<Object> objSM;
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (this.ownerMmd.getMap().keyIsPersistent() && (objSM = ec.findStateManager(key)) == null) {
                        objSM = ec.getNucleusContext().getStateManagerFactory().newForEmbedded(ec, key, false, this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), PersistableObjectType.EMBEDDED_MAP_KEY_PC);
                    }
                    if (!this.ownerMmd.getMap().valueIsPersistent() || (objSM = ec.findStateManager(value)) != null) continue;
                    objSM = ec.getNucleusContext().getStateManagerFactory().newForEmbedded(ec, value, false, this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), PersistableObjectType.EMBEDDED_MAP_VALUE_PC);
                }
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("023008", this.ownerSM.getObjectAsPrintable(), this.ownerMmd.getName(), "" + newValue.size()));
            }
            if (this.useCache) {
                Map oldMap = (Map)oldValue;
                if (oldMap != null) {
                    this.delegate.putAll((Map<?, ?>)oldMap);
                }
                this.isCacheLoaded = true;
                SCOUtils.updateMapWithMapKeysValues(this.ownerSM.getExecutionContext().getApiAdapter(), this, newValue);
            } else {
                if (this.backingStore != null) {
                    if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                        if (this.ownerSM.isFlushedToDatastore() || !this.ownerSM.getLifecycleState().isNew()) {
                            this.ownerSM.getExecutionContext().addOperationToQueue(new MapClearOperation(this.ownerSM, this.backingStore));
                            for (Map.Entry<Object, Object> entry : newValue.entrySet()) {
                                this.ownerSM.getExecutionContext().addOperationToQueue(new MapPutOperation<Object, Object>(this.ownerSM, this.backingStore, entry.getKey(), entry.getValue()));
                            }
                        }
                    } else {
                        this.backingStore.clear(this.ownerSM);
                        this.backingStore.putAll(this.ownerSM, newValue, Collections.emptyMap());
                    }
                }
                this.delegate.putAll((Map<?, ?>)newValue);
                this.isCacheLoaded = true;
                this.makeDirty();
            }
        }
    }

    @Override
    public void initialise(java.util.Properties m) {
        if (m != null) {
            if (SCOUtils.mapHasSerialisedKeysAndValues(this.ownerMmd) && (this.ownerMmd.getMap().keyIsPersistent() || this.ownerMmd.getMap().valueIsPersistent())) {
                ExecutionContext ec = this.ownerSM.getExecutionContext();
                for (Map.Entry<Object, Object> entry : m.entrySet()) {
                    DNStateManager<Object> objSM;
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (this.ownerMmd.getMap().keyIsPersistent() && (objSM = ec.findStateManager(key)) == null) {
                        objSM = ec.getNucleusContext().getStateManagerFactory().newForEmbedded(ec, key, false, this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), PersistableObjectType.EMBEDDED_MAP_KEY_PC);
                    }
                    if (!this.ownerMmd.getMap().valueIsPersistent() || (objSM = ec.findStateManager(value)) != null) continue;
                    objSM = ec.getNucleusContext().getStateManagerFactory().newForEmbedded(ec, value, false, this.ownerSM, this.ownerMmd.getAbsoluteFieldNumber(), PersistableObjectType.EMBEDDED_MAP_VALUE_PC);
                }
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("023007", this.ownerSM.getObjectAsPrintable(), this.ownerMmd.getName(), "" + m.size()));
            }
            this.delegate.putAll((Map<?, ?>)m);
            this.isCacheLoaded = true;
        }
    }

    @Override
    public void initialise() {
        if (this.useCache && !SCOUtils.useCachedLazyLoading(this.ownerSM, this.ownerMmd)) {
            this.loadFromStore();
        }
    }

    @Override
    public java.util.Properties getValue() {
        this.loadFromStore();
        return super.getValue();
    }

    @Override
    public void load() {
        if (this.useCache) {
            this.loadFromStore();
        }
    }

    @Override
    public boolean isLoaded() {
        return this.useCache ? this.isCacheLoaded : false;
    }

    protected void loadFromStore() {
        if (this.backingStore != null && !this.isCacheLoaded) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("023006", this.ownerSM.getObjectAsPrintable(), this.ownerMmd.getName()));
            }
            this.delegate.clear();
            SCOUtils.populateMapDelegateWithStoreData(this.delegate, this.backingStore, this.ownerSM);
            this.isCacheLoaded = true;
        }
    }

    @Override
    public Store getBackingStore() {
        return this.backingStore;
    }

    @Override
    public void updateEmbeddedKey(Object key, int fieldNumber, Object newValue, boolean makeDirty) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedKey(this.ownerSM, key, fieldNumber, newValue);
        }
    }

    @Override
    public void updateEmbeddedValue(Object value, int fieldNumber, Object newValue, boolean makeDirty) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedValue(this.ownerSM, value, fieldNumber, newValue);
        }
    }

    @Override
    public void unsetOwner() {
        super.unsetOwner();
        if (this.backingStore != null) {
            this.backingStore = null;
        }
    }

    @Override
    public synchronized Object clone() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return this.delegate.clone();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.containsKey(key);
        }
        if (this.backingStore != null) {
            return this.backingStore.containsKey(this.ownerSM, key);
        }
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.containsValue(value);
        }
        if (this.backingStore != null) {
            return this.backingStore.containsValue(this.ownerSM, value);
        }
        return this.delegate.containsValue(value);
    }

    @Override
    public java.util.Set entrySet() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return new Set(this.ownerSM, this.ownerMmd, false, this.backingStore.entrySetStore());
        }
        return this.delegate.entrySet();
    }

    @Override
    public synchronized boolean equals(Object o) {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        return this.entrySet().equals(m.entrySet());
    }

    @Override
    public synchronized Object get(Object key) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.get(this.ownerSM, key);
        }
        return this.delegate.get(key);
    }

    @Override
    public synchronized String getProperty(String key) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            Object val = this.backingStore.get(this.ownerSM, key);
            String strVal = val instanceof String ? (String)val : null;
            return strVal == null && this.defaults != null ? this.defaults.getProperty(key) : strVal;
        }
        return this.delegate.getProperty(key);
    }

    @Override
    public synchronized int hashCode() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            int h = 0;
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                h += i.next().hashCode();
            }
            return h;
        }
        return this.delegate.hashCode();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public java.util.Set keySet() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return new Set(this.ownerSM, this.ownerMmd, false, this.backingStore.keySetStore());
        }
        return this.delegate.keySet();
    }

    @Override
    public synchronized int size() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.size();
        }
        if (this.backingStore != null) {
            return this.backingStore.entrySetStore().size(this.ownerSM);
        }
        return this.delegate.size();
    }

    @Override
    public java.util.Collection values() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return new Collection(this.ownerSM, this.ownerMmd, true, this.backingStore.valueCollectionStore());
        }
        return this.delegate.values();
    }

    @Override
    public synchronized void clear() {
        this.makeDirty();
        this.delegate.clear();
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                this.ownerSM.getExecutionContext().addOperationToQueue(new MapClearOperation(this.ownerSM, this.backingStore));
            } else {
                this.backingStore.clear(this.ownerSM);
            }
        }
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        if (!this.allowNulls) {
            if (key == null) {
                throw new NullPointerException("Nulls not allowed for map at field " + this.ownerMmd.getName() + " but key is null");
            }
            if (value == null) {
                throw new NullPointerException("Nulls not allowed for map at field " + this.ownerMmd.getName() + " but value is null");
            }
        }
        if (this.useCache) {
            this.loadFromStore();
        }
        this.makeDirty();
        Object oldValue = null;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                this.ownerSM.getExecutionContext().addOperationToQueue(new MapPutOperation<Object, Object>(this.ownerSM, this.backingStore, key, value));
            } else if (this.useCache) {
                oldValue = this.delegate.get(key);
                this.backingStore.put(this.ownerSM, key, value, oldValue, this.delegate.containsKey(key));
            } else {
                oldValue = this.backingStore.put(this.ownerSM, key, value);
            }
        }
        Object delegateOldValue = this.delegate.put(key, value);
        if (this.backingStore == null) {
            oldValue = delegateOldValue;
        } else if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
            oldValue = delegateOldValue;
        }
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return oldValue;
    }

    @Override
    public synchronized void putAll(Map m) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                for (Map.Entry entry : m.entrySet()) {
                    this.ownerSM.getExecutionContext().addOperationToQueue(new MapPutOperation(this.ownerSM, this.backingStore, entry.getKey(), entry.getValue()));
                }
            } else if (this.useCache) {
                this.backingStore.putAll(this.ownerSM, m, Collections.unmodifiableMap(this.delegate));
            } else {
                this.backingStore.putAll(this.ownerSM, m);
            }
        }
        this.delegate.putAll((Map<?, ?>)m);
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
    }

    @Override
    public synchronized Object remove(Object key) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        Object removed = null;
        Object delegateRemoved = this.delegate.remove(key);
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerSM)) {
                this.ownerSM.getExecutionContext().addOperationToQueue(new MapRemoveOperation<Object, Object>(this.ownerSM, this.backingStore, key, delegateRemoved));
                removed = delegateRemoved;
            } else if (this.useCache) {
                this.backingStore.remove(this.ownerSM, key, delegateRemoved);
                removed = delegateRemoved;
            } else {
                removed = this.backingStore.remove(this.ownerSM, key);
            }
        } else {
            removed = delegateRemoved;
        }
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return removed;
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        return this.put(key, value);
    }

    @Override
    protected Object writeReplace() throws ObjectStreamException {
        if (this.useCache) {
            this.loadFromStore();
            return new Hashtable<Object, Object>(this.delegate);
        }
        return new Hashtable<Object, Object>(this.delegate);
    }
}

