/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.ClientCapabilities;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class GetTableRequest
implements TBase<GetTableRequest, _Fields>,
Serializable,
Cloneable,
Comparable<GetTableRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("GetTableRequest");
    private static final TField DB_NAME_FIELD_DESC = new TField("dbName", 11, 1);
    private static final TField TBL_NAME_FIELD_DESC = new TField("tblName", 11, 2);
    private static final TField CAPABILITIES_FIELD_DESC = new TField("capabilities", 12, 3);
    private static final TField CAT_NAME_FIELD_DESC = new TField("catName", 11, 4);
    private static final TField VALID_WRITE_ID_LIST_FIELD_DESC = new TField("validWriteIdList", 11, 6);
    private static final TField GET_COLUMN_STATS_FIELD_DESC = new TField("getColumnStats", 2, 7);
    private static final TField PROCESSOR_CAPABILITIES_FIELD_DESC = new TField("processorCapabilities", 15, 8);
    private static final TField PROCESSOR_IDENTIFIER_FIELD_DESC = new TField("processorIdentifier", 11, 9);
    private static final TField ENGINE_FIELD_DESC = new TField("engine", 11, 10);
    private static final TField ID_FIELD_DESC = new TField("id", 10, 11);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new GetTableRequestStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new GetTableRequestTupleSchemeFactory();
    @Nullable
    private String dbName;
    @Nullable
    private String tblName;
    @Nullable
    private ClientCapabilities capabilities;
    @Nullable
    private String catName;
    @Nullable
    private String validWriteIdList;
    private boolean getColumnStats;
    @Nullable
    private List<String> processorCapabilities;
    @Nullable
    private String processorIdentifier;
    @Nullable
    private String engine;
    private long id;
    private static final int __GETCOLUMNSTATS_ISSET_ID = 0;
    private static final int __ID_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.CAPABILITIES, _Fields.CAT_NAME, _Fields.VALID_WRITE_ID_LIST, _Fields.GET_COLUMN_STATS, _Fields.PROCESSOR_CAPABILITIES, _Fields.PROCESSOR_IDENTIFIER, _Fields.ENGINE, _Fields.ID};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public GetTableRequest() {
        this.engine = "hive";
        this.id = -1L;
    }

    public GetTableRequest(String dbName, String tblName) {
        this();
        this.dbName = dbName;
        this.tblName = tblName;
    }

    public GetTableRequest(GetTableRequest other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetDbName()) {
            this.dbName = other.dbName;
        }
        if (other.isSetTblName()) {
            this.tblName = other.tblName;
        }
        if (other.isSetCapabilities()) {
            this.capabilities = new ClientCapabilities(other.capabilities);
        }
        if (other.isSetCatName()) {
            this.catName = other.catName;
        }
        if (other.isSetValidWriteIdList()) {
            this.validWriteIdList = other.validWriteIdList;
        }
        this.getColumnStats = other.getColumnStats;
        if (other.isSetProcessorCapabilities()) {
            ArrayList<String> __this__processorCapabilities = new ArrayList<String>(other.processorCapabilities);
            this.processorCapabilities = __this__processorCapabilities;
        }
        if (other.isSetProcessorIdentifier()) {
            this.processorIdentifier = other.processorIdentifier;
        }
        if (other.isSetEngine()) {
            this.engine = other.engine;
        }
        this.id = other.id;
    }

    public GetTableRequest deepCopy() {
        return new GetTableRequest(this);
    }

    public void clear() {
        this.dbName = null;
        this.tblName = null;
        this.capabilities = null;
        this.catName = null;
        this.validWriteIdList = null;
        this.setGetColumnStatsIsSet(false);
        this.getColumnStats = false;
        this.processorCapabilities = null;
        this.processorIdentifier = null;
        this.engine = "hive";
        this.id = -1L;
    }

    @Nullable
    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(@Nullable String dbName) {
        this.dbName = dbName;
    }

    public void unsetDbName() {
        this.dbName = null;
    }

    public boolean isSetDbName() {
        return this.dbName != null;
    }

    public void setDbNameIsSet(boolean value) {
        if (!value) {
            this.dbName = null;
        }
    }

    @Nullable
    public String getTblName() {
        return this.tblName;
    }

    public void setTblName(@Nullable String tblName) {
        this.tblName = tblName;
    }

    public void unsetTblName() {
        this.tblName = null;
    }

    public boolean isSetTblName() {
        return this.tblName != null;
    }

    public void setTblNameIsSet(boolean value) {
        if (!value) {
            this.tblName = null;
        }
    }

    @Nullable
    public ClientCapabilities getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(@Nullable ClientCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    public void unsetCapabilities() {
        this.capabilities = null;
    }

    public boolean isSetCapabilities() {
        return this.capabilities != null;
    }

    public void setCapabilitiesIsSet(boolean value) {
        if (!value) {
            this.capabilities = null;
        }
    }

    @Nullable
    public String getCatName() {
        return this.catName;
    }

    public void setCatName(@Nullable String catName) {
        this.catName = catName;
    }

    public void unsetCatName() {
        this.catName = null;
    }

    public boolean isSetCatName() {
        return this.catName != null;
    }

    public void setCatNameIsSet(boolean value) {
        if (!value) {
            this.catName = null;
        }
    }

    @Nullable
    public String getValidWriteIdList() {
        return this.validWriteIdList;
    }

    public void setValidWriteIdList(@Nullable String validWriteIdList) {
        this.validWriteIdList = validWriteIdList;
    }

    public void unsetValidWriteIdList() {
        this.validWriteIdList = null;
    }

    public boolean isSetValidWriteIdList() {
        return this.validWriteIdList != null;
    }

    public void setValidWriteIdListIsSet(boolean value) {
        if (!value) {
            this.validWriteIdList = null;
        }
    }

    public boolean isGetColumnStats() {
        return this.getColumnStats;
    }

    public void setGetColumnStats(boolean getColumnStats) {
        this.getColumnStats = getColumnStats;
        this.setGetColumnStatsIsSet(true);
    }

    public void unsetGetColumnStats() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetGetColumnStats() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setGetColumnStatsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public int getProcessorCapabilitiesSize() {
        return this.processorCapabilities == null ? 0 : this.processorCapabilities.size();
    }

    @Nullable
    public Iterator<String> getProcessorCapabilitiesIterator() {
        return this.processorCapabilities == null ? null : this.processorCapabilities.iterator();
    }

    public void addToProcessorCapabilities(String elem) {
        if (this.processorCapabilities == null) {
            this.processorCapabilities = new ArrayList<String>();
        }
        this.processorCapabilities.add(elem);
    }

    @Nullable
    public List<String> getProcessorCapabilities() {
        return this.processorCapabilities;
    }

    public void setProcessorCapabilities(@Nullable List<String> processorCapabilities) {
        this.processorCapabilities = processorCapabilities;
    }

    public void unsetProcessorCapabilities() {
        this.processorCapabilities = null;
    }

    public boolean isSetProcessorCapabilities() {
        return this.processorCapabilities != null;
    }

    public void setProcessorCapabilitiesIsSet(boolean value) {
        if (!value) {
            this.processorCapabilities = null;
        }
    }

    @Nullable
    public String getProcessorIdentifier() {
        return this.processorIdentifier;
    }

    public void setProcessorIdentifier(@Nullable String processorIdentifier) {
        this.processorIdentifier = processorIdentifier;
    }

    public void unsetProcessorIdentifier() {
        this.processorIdentifier = null;
    }

    public boolean isSetProcessorIdentifier() {
        return this.processorIdentifier != null;
    }

    public void setProcessorIdentifierIsSet(boolean value) {
        if (!value) {
            this.processorIdentifier = null;
        }
    }

    @Nullable
    public String getEngine() {
        return this.engine;
    }

    public void setEngine(@Nullable String engine) {
        this.engine = engine;
    }

    public void unsetEngine() {
        this.engine = null;
    }

    public boolean isSetEngine() {
        return this.engine != null;
    }

    public void setEngineIsSet(boolean value) {
        if (!value) {
            this.engine = null;
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
        this.setIdIsSet(true);
    }

    public void unsetId() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetId() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field.ordinal()) {
            case 0: {
                if (value == null) {
                    this.unsetDbName();
                    break;
                }
                this.setDbName((String)value);
                break;
            }
            case 1: {
                if (value == null) {
                    this.unsetTblName();
                    break;
                }
                this.setTblName((String)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetCapabilities();
                    break;
                }
                this.setCapabilities((ClientCapabilities)value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetCatName();
                    break;
                }
                this.setCatName((String)value);
                break;
            }
            case 4: {
                if (value == null) {
                    this.unsetValidWriteIdList();
                    break;
                }
                this.setValidWriteIdList((String)value);
                break;
            }
            case 5: {
                if (value == null) {
                    this.unsetGetColumnStats();
                    break;
                }
                this.setGetColumnStats((Boolean)value);
                break;
            }
            case 6: {
                if (value == null) {
                    this.unsetProcessorCapabilities();
                    break;
                }
                this.setProcessorCapabilities((List)value);
                break;
            }
            case 7: {
                if (value == null) {
                    this.unsetProcessorIdentifier();
                    break;
                }
                this.setProcessorIdentifier((String)value);
                break;
            }
            case 8: {
                if (value == null) {
                    this.unsetEngine();
                    break;
                }
                this.setEngine((String)value);
                break;
            }
            case 9: {
                if (value == null) {
                    this.unsetId();
                    break;
                }
                this.setId((Long)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field.ordinal()) {
            case 0: {
                return this.getDbName();
            }
            case 1: {
                return this.getTblName();
            }
            case 2: {
                return this.getCapabilities();
            }
            case 3: {
                return this.getCatName();
            }
            case 4: {
                return this.getValidWriteIdList();
            }
            case 5: {
                return this.isGetColumnStats();
            }
            case 6: {
                return this.getProcessorCapabilities();
            }
            case 7: {
                return this.getProcessorIdentifier();
            }
            case 8: {
                return this.getEngine();
            }
            case 9: {
                return this.getId();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field.ordinal()) {
            case 0: {
                return this.isSetDbName();
            }
            case 1: {
                return this.isSetTblName();
            }
            case 2: {
                return this.isSetCapabilities();
            }
            case 3: {
                return this.isSetCatName();
            }
            case 4: {
                return this.isSetValidWriteIdList();
            }
            case 5: {
                return this.isSetGetColumnStats();
            }
            case 6: {
                return this.isSetProcessorCapabilities();
            }
            case 7: {
                return this.isSetProcessorIdentifier();
            }
            case 8: {
                return this.isSetEngine();
            }
            case 9: {
                return this.isSetId();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof GetTableRequest) {
            return this.equals((GetTableRequest)that);
        }
        return false;
    }

    public boolean equals(GetTableRequest that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_dbName = this.isSetDbName();
        boolean that_present_dbName = that.isSetDbName();
        if (this_present_dbName || that_present_dbName) {
            if (!this_present_dbName || !that_present_dbName) {
                return false;
            }
            if (!this.dbName.equals(that.dbName)) {
                return false;
            }
        }
        boolean this_present_tblName = this.isSetTblName();
        boolean that_present_tblName = that.isSetTblName();
        if (this_present_tblName || that_present_tblName) {
            if (!this_present_tblName || !that_present_tblName) {
                return false;
            }
            if (!this.tblName.equals(that.tblName)) {
                return false;
            }
        }
        boolean this_present_capabilities = this.isSetCapabilities();
        boolean that_present_capabilities = that.isSetCapabilities();
        if (this_present_capabilities || that_present_capabilities) {
            if (!this_present_capabilities || !that_present_capabilities) {
                return false;
            }
            if (!this.capabilities.equals(that.capabilities)) {
                return false;
            }
        }
        boolean this_present_catName = this.isSetCatName();
        boolean that_present_catName = that.isSetCatName();
        if (this_present_catName || that_present_catName) {
            if (!this_present_catName || !that_present_catName) {
                return false;
            }
            if (!this.catName.equals(that.catName)) {
                return false;
            }
        }
        boolean this_present_validWriteIdList = this.isSetValidWriteIdList();
        boolean that_present_validWriteIdList = that.isSetValidWriteIdList();
        if (this_present_validWriteIdList || that_present_validWriteIdList) {
            if (!this_present_validWriteIdList || !that_present_validWriteIdList) {
                return false;
            }
            if (!this.validWriteIdList.equals(that.validWriteIdList)) {
                return false;
            }
        }
        boolean this_present_getColumnStats = this.isSetGetColumnStats();
        boolean that_present_getColumnStats = that.isSetGetColumnStats();
        if (this_present_getColumnStats || that_present_getColumnStats) {
            if (!this_present_getColumnStats || !that_present_getColumnStats) {
                return false;
            }
            if (this.getColumnStats != that.getColumnStats) {
                return false;
            }
        }
        boolean this_present_processorCapabilities = this.isSetProcessorCapabilities();
        boolean that_present_processorCapabilities = that.isSetProcessorCapabilities();
        if (this_present_processorCapabilities || that_present_processorCapabilities) {
            if (!this_present_processorCapabilities || !that_present_processorCapabilities) {
                return false;
            }
            if (!this.processorCapabilities.equals(that.processorCapabilities)) {
                return false;
            }
        }
        boolean this_present_processorIdentifier = this.isSetProcessorIdentifier();
        boolean that_present_processorIdentifier = that.isSetProcessorIdentifier();
        if (this_present_processorIdentifier || that_present_processorIdentifier) {
            if (!this_present_processorIdentifier || !that_present_processorIdentifier) {
                return false;
            }
            if (!this.processorIdentifier.equals(that.processorIdentifier)) {
                return false;
            }
        }
        boolean this_present_engine = this.isSetEngine();
        boolean that_present_engine = that.isSetEngine();
        if (this_present_engine || that_present_engine) {
            if (!this_present_engine || !that_present_engine) {
                return false;
            }
            if (!this.engine.equals(that.engine)) {
                return false;
            }
        }
        boolean this_present_id = this.isSetId();
        boolean that_present_id = that.isSetId();
        if (this_present_id || that_present_id) {
            if (!this_present_id || !that_present_id) {
                return false;
            }
            if (this.id != that.id) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetDbName() ? 131071 : 524287);
        if (this.isSetDbName()) {
            hashCode = hashCode * 8191 + this.dbName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTblName() ? 131071 : 524287);
        if (this.isSetTblName()) {
            hashCode = hashCode * 8191 + this.tblName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetCapabilities() ? 131071 : 524287);
        if (this.isSetCapabilities()) {
            hashCode = hashCode * 8191 + this.capabilities.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetCatName() ? 131071 : 524287);
        if (this.isSetCatName()) {
            hashCode = hashCode * 8191 + this.catName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetValidWriteIdList() ? 131071 : 524287);
        if (this.isSetValidWriteIdList()) {
            hashCode = hashCode * 8191 + this.validWriteIdList.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetGetColumnStats() ? 131071 : 524287);
        if (this.isSetGetColumnStats()) {
            hashCode = hashCode * 8191 + (this.getColumnStats ? 131071 : 524287);
        }
        hashCode = hashCode * 8191 + (this.isSetProcessorCapabilities() ? 131071 : 524287);
        if (this.isSetProcessorCapabilities()) {
            hashCode = hashCode * 8191 + this.processorCapabilities.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetProcessorIdentifier() ? 131071 : 524287);
        if (this.isSetProcessorIdentifier()) {
            hashCode = hashCode * 8191 + this.processorIdentifier.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetEngine() ? 131071 : 524287);
        if (this.isSetEngine()) {
            hashCode = hashCode * 8191 + this.engine.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetId() ? 131071 : 524287);
        if (this.isSetId()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.id);
        }
        return hashCode;
    }

    @Override
    public int compareTo(GetTableRequest other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetDbName(), other.isSetDbName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDbName() && (lastComparison = TBaseHelper.compareTo((String)this.dbName, (String)other.dbName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTblName(), other.isSetTblName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTblName() && (lastComparison = TBaseHelper.compareTo((String)this.tblName, (String)other.tblName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetCapabilities(), other.isSetCapabilities());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCapabilities() && (lastComparison = TBaseHelper.compareTo((Comparable)this.capabilities, (Comparable)other.capabilities)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetCatName(), other.isSetCatName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCatName() && (lastComparison = TBaseHelper.compareTo((String)this.catName, (String)other.catName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetValidWriteIdList(), other.isSetValidWriteIdList());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetValidWriteIdList() && (lastComparison = TBaseHelper.compareTo((String)this.validWriteIdList, (String)other.validWriteIdList)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetGetColumnStats(), other.isSetGetColumnStats());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetGetColumnStats() && (lastComparison = TBaseHelper.compareTo((boolean)this.getColumnStats, (boolean)other.getColumnStats)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetProcessorCapabilities(), other.isSetProcessorCapabilities());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProcessorCapabilities() && (lastComparison = TBaseHelper.compareTo(this.processorCapabilities, other.processorCapabilities)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetProcessorIdentifier(), other.isSetProcessorIdentifier());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProcessorIdentifier() && (lastComparison = TBaseHelper.compareTo((String)this.processorIdentifier, (String)other.processorIdentifier)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetEngine(), other.isSetEngine());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEngine() && (lastComparison = TBaseHelper.compareTo((String)this.engine, (String)other.engine)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetId(), other.isSetId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetId() && (lastComparison = TBaseHelper.compareTo((long)this.id, (long)other.id)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        GetTableRequest.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        GetTableRequest.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GetTableRequest(");
        boolean first = true;
        sb.append("dbName:");
        if (this.dbName == null) {
            sb.append("null");
        } else {
            sb.append(this.dbName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("tblName:");
        if (this.tblName == null) {
            sb.append("null");
        } else {
            sb.append(this.tblName);
        }
        first = false;
        if (this.isSetCapabilities()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("capabilities:");
            if (this.capabilities == null) {
                sb.append("null");
            } else {
                sb.append(this.capabilities);
            }
            first = false;
        }
        if (this.isSetCatName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("catName:");
            if (this.catName == null) {
                sb.append("null");
            } else {
                sb.append(this.catName);
            }
            first = false;
        }
        if (this.isSetValidWriteIdList()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("validWriteIdList:");
            if (this.validWriteIdList == null) {
                sb.append("null");
            } else {
                sb.append(this.validWriteIdList);
            }
            first = false;
        }
        if (this.isSetGetColumnStats()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("getColumnStats:");
            sb.append(this.getColumnStats);
            first = false;
        }
        if (this.isSetProcessorCapabilities()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("processorCapabilities:");
            if (this.processorCapabilities == null) {
                sb.append("null");
            } else {
                sb.append(this.processorCapabilities);
            }
            first = false;
        }
        if (this.isSetProcessorIdentifier()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("processorIdentifier:");
            if (this.processorIdentifier == null) {
                sb.append("null");
            } else {
                sb.append(this.processorIdentifier);
            }
            first = false;
        }
        if (this.isSetEngine()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("engine:");
            if (this.engine == null) {
                sb.append("null");
            } else {
                sb.append(this.engine);
            }
            first = false;
        }
        if (this.isSetId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("id:");
            sb.append(this.id);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetDbName()) {
            throw new TProtocolException("Required field 'dbName' is unset! Struct:" + this.toString());
        }
        if (!this.isSetTblName()) {
            throw new TProtocolException("Required field 'tblName' is unset! Struct:" + this.toString());
        }
        if (this.capabilities != null) {
            this.capabilities.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.DB_NAME, new FieldMetaData("dbName", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TBL_NAME, new FieldMetaData("tblName", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.CAPABILITIES, new FieldMetaData("capabilities", 2, (FieldValueMetaData)new StructMetaData(12, ClientCapabilities.class)));
        tmpMap.put(_Fields.CAT_NAME, new FieldMetaData("catName", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.VALID_WRITE_ID_LIST, new FieldMetaData("validWriteIdList", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.GET_COLUMN_STATS, new FieldMetaData("getColumnStats", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.PROCESSOR_CAPABILITIES, new FieldMetaData("processorCapabilities", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.PROCESSOR_IDENTIFIER, new FieldMetaData("processorIdentifier", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.ENGINE, new FieldMetaData("engine", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.ID, new FieldMetaData("id", 2, new FieldValueMetaData(10)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(GetTableRequest.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        DB_NAME(1, "dbName"),
        TBL_NAME(2, "tblName"),
        CAPABILITIES(3, "capabilities"),
        CAT_NAME(4, "catName"),
        VALID_WRITE_ID_LIST(6, "validWriteIdList"),
        GET_COLUMN_STATS(7, "getColumnStats"),
        PROCESSOR_CAPABILITIES(8, "processorCapabilities"),
        PROCESSOR_IDENTIFIER(9, "processorIdentifier"),
        ENGINE(10, "engine"),
        ID(11, "id");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return DB_NAME;
                }
                case 2: {
                    return TBL_NAME;
                }
                case 3: {
                    return CAPABILITIES;
                }
                case 4: {
                    return CAT_NAME;
                }
                case 6: {
                    return VALID_WRITE_ID_LIST;
                }
                case 7: {
                    return GET_COLUMN_STATS;
                }
                case 8: {
                    return PROCESSOR_CAPABILITIES;
                }
                case 9: {
                    return PROCESSOR_IDENTIFIER;
                }
                case 10: {
                    return ENGINE;
                }
                case 11: {
                    return ID;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }

    private static class GetTableRequestStandardSchemeFactory
    implements SchemeFactory {
        private GetTableRequestStandardSchemeFactory() {
        }

        public GetTableRequestStandardScheme getScheme() {
            return new GetTableRequestStandardScheme();
        }
    }

    private static class GetTableRequestTupleSchemeFactory
    implements SchemeFactory {
        private GetTableRequestTupleSchemeFactory() {
        }

        public GetTableRequestTupleScheme getScheme() {
            return new GetTableRequestTupleScheme();
        }
    }

    private static class GetTableRequestTupleScheme
    extends TupleScheme<GetTableRequest> {
        private GetTableRequestTupleScheme() {
        }

        public void write(TProtocol prot, GetTableRequest struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeString(struct.dbName);
            oprot.writeString(struct.tblName);
            BitSet optionals = new BitSet();
            if (struct.isSetCapabilities()) {
                optionals.set(0);
            }
            if (struct.isSetCatName()) {
                optionals.set(1);
            }
            if (struct.isSetValidWriteIdList()) {
                optionals.set(2);
            }
            if (struct.isSetGetColumnStats()) {
                optionals.set(3);
            }
            if (struct.isSetProcessorCapabilities()) {
                optionals.set(4);
            }
            if (struct.isSetProcessorIdentifier()) {
                optionals.set(5);
            }
            if (struct.isSetEngine()) {
                optionals.set(6);
            }
            if (struct.isSetId()) {
                optionals.set(7);
            }
            oprot.writeBitSet(optionals, 8);
            if (struct.isSetCapabilities()) {
                struct.capabilities.write((TProtocol)oprot);
            }
            if (struct.isSetCatName()) {
                oprot.writeString(struct.catName);
            }
            if (struct.isSetValidWriteIdList()) {
                oprot.writeString(struct.validWriteIdList);
            }
            if (struct.isSetGetColumnStats()) {
                oprot.writeBool(struct.getColumnStats);
            }
            if (struct.isSetProcessorCapabilities()) {
                oprot.writeI32(struct.processorCapabilities.size());
                for (String _iter1220 : struct.processorCapabilities) {
                    oprot.writeString(_iter1220);
                }
            }
            if (struct.isSetProcessorIdentifier()) {
                oprot.writeString(struct.processorIdentifier);
            }
            if (struct.isSetEngine()) {
                oprot.writeString(struct.engine);
            }
            if (struct.isSetId()) {
                oprot.writeI64(struct.id);
            }
        }

        public void read(TProtocol prot, GetTableRequest struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.dbName = iprot.readString();
            struct.setDbNameIsSet(true);
            struct.tblName = iprot.readString();
            struct.setTblNameIsSet(true);
            BitSet incoming = iprot.readBitSet(8);
            if (incoming.get(0)) {
                struct.capabilities = new ClientCapabilities();
                struct.capabilities.read((TProtocol)iprot);
                struct.setCapabilitiesIsSet(true);
            }
            if (incoming.get(1)) {
                struct.catName = iprot.readString();
                struct.setCatNameIsSet(true);
            }
            if (incoming.get(2)) {
                struct.validWriteIdList = iprot.readString();
                struct.setValidWriteIdListIsSet(true);
            }
            if (incoming.get(3)) {
                struct.getColumnStats = iprot.readBool();
                struct.setGetColumnStatsIsSet(true);
            }
            if (incoming.get(4)) {
                TList _list1221 = iprot.readListBegin((byte)11);
                struct.processorCapabilities = new ArrayList<String>(_list1221.size);
                for (int _i1223 = 0; _i1223 < _list1221.size; ++_i1223) {
                    String _elem1222 = iprot.readString();
                    struct.processorCapabilities.add(_elem1222);
                }
                struct.setProcessorCapabilitiesIsSet(true);
            }
            if (incoming.get(5)) {
                struct.processorIdentifier = iprot.readString();
                struct.setProcessorIdentifierIsSet(true);
            }
            if (incoming.get(6)) {
                struct.engine = iprot.readString();
                struct.setEngineIsSet(true);
            }
            if (incoming.get(7)) {
                struct.id = iprot.readI64();
                struct.setIdIsSet(true);
            }
        }
    }

    private static class GetTableRequestStandardScheme
    extends StandardScheme<GetTableRequest> {
        private GetTableRequestStandardScheme() {
        }

        public void read(TProtocol iprot, GetTableRequest struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.dbName = iprot.readString();
                            struct.setDbNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.tblName = iprot.readString();
                            struct.setTblNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 12) {
                            struct.capabilities = new ClientCapabilities();
                            struct.capabilities.read(iprot);
                            struct.setCapabilitiesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.catName = iprot.readString();
                            struct.setCatNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 11) {
                            struct.validWriteIdList = iprot.readString();
                            struct.setValidWriteIdListIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 2) {
                            struct.getColumnStats = iprot.readBool();
                            struct.setGetColumnStatsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 15) {
                            TList _list1216 = iprot.readListBegin();
                            struct.processorCapabilities = new ArrayList<String>(_list1216.size);
                            for (int _i1218 = 0; _i1218 < _list1216.size; ++_i1218) {
                                String _elem1217 = iprot.readString();
                                struct.processorCapabilities.add(_elem1217);
                            }
                            iprot.readListEnd();
                            struct.setProcessorCapabilitiesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 11) {
                            struct.processorIdentifier = iprot.readString();
                            struct.setProcessorIdentifierIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 11) {
                            struct.engine = iprot.readString();
                            struct.setEngineIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 10) {
                            struct.id = iprot.readI64();
                            struct.setIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, GetTableRequest struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.dbName != null) {
                oprot.writeFieldBegin(DB_NAME_FIELD_DESC);
                oprot.writeString(struct.dbName);
                oprot.writeFieldEnd();
            }
            if (struct.tblName != null) {
                oprot.writeFieldBegin(TBL_NAME_FIELD_DESC);
                oprot.writeString(struct.tblName);
                oprot.writeFieldEnd();
            }
            if (struct.capabilities != null && struct.isSetCapabilities()) {
                oprot.writeFieldBegin(CAPABILITIES_FIELD_DESC);
                struct.capabilities.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.catName != null && struct.isSetCatName()) {
                oprot.writeFieldBegin(CAT_NAME_FIELD_DESC);
                oprot.writeString(struct.catName);
                oprot.writeFieldEnd();
            }
            if (struct.validWriteIdList != null && struct.isSetValidWriteIdList()) {
                oprot.writeFieldBegin(VALID_WRITE_ID_LIST_FIELD_DESC);
                oprot.writeString(struct.validWriteIdList);
                oprot.writeFieldEnd();
            }
            if (struct.isSetGetColumnStats()) {
                oprot.writeFieldBegin(GET_COLUMN_STATS_FIELD_DESC);
                oprot.writeBool(struct.getColumnStats);
                oprot.writeFieldEnd();
            }
            if (struct.processorCapabilities != null && struct.isSetProcessorCapabilities()) {
                oprot.writeFieldBegin(PROCESSOR_CAPABILITIES_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.processorCapabilities.size()));
                for (String _iter1219 : struct.processorCapabilities) {
                    oprot.writeString(_iter1219);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.processorIdentifier != null && struct.isSetProcessorIdentifier()) {
                oprot.writeFieldBegin(PROCESSOR_IDENTIFIER_FIELD_DESC);
                oprot.writeString(struct.processorIdentifier);
                oprot.writeFieldEnd();
            }
            if (struct.engine != null && struct.isSetEngine()) {
                oprot.writeFieldBegin(ENGINE_FIELD_DESC);
                oprot.writeString(struct.engine);
                oprot.writeFieldEnd();
            }
            if (struct.isSetId()) {
                oprot.writeFieldBegin(ID_FIELD_DESC);
                oprot.writeI64(struct.id);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }
}

