/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;

public enum Quotation {
    NONE("none", ""),
    BACKTICKS("column", "`"),
    STANDARD("standard", "\"");

    private final String stringValue;
    private final String quotationChar;

    private Quotation(String stringValue, String quotationChar) {
        this.stringValue = stringValue;
        this.quotationChar = quotationChar;
    }

    public String stringValue() {
        return this.stringValue;
    }

    public String getQuotationChar() {
        return this.quotationChar;
    }

    public static Quotation from(Configuration configuration) {
        String supportedQIds = configuration == null ? HiveConf.ConfVars.HIVE_QUOTEDID_SUPPORT.defaultStrVal : HiveConf.getVar((Configuration)configuration, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUOTEDID_SUPPORT);
        for (Quotation quotation : Quotation.values()) {
            if (!quotation.stringValue.equalsIgnoreCase(supportedQIds)) continue;
            return quotation;
        }
        throw new EnumConstantNotPresentException(Quotation.class, "Option not recognized for " + HiveConf.ConfVars.HIVE_QUOTEDID_SUPPORT.varname + "value: " + supportedQIds);
    }
}

