/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.messaging.AddDefaultConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageBuilder;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.thrift.TException;

public class JSONAddDefaultConstraintMessage
extends AddDefaultConstraintMessage {
    @JsonProperty
    String server;
    @JsonProperty
    String servicePrincipal;
    @JsonProperty
    Long timestamp;
    @JsonProperty
    List<String> defaultConstraintListJson;

    public JSONAddDefaultConstraintMessage() {
    }

    public JSONAddDefaultConstraintMessage(String server, String servicePrincipal, List<SQLDefaultConstraint> dcs, Long timestamp) {
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        this.timestamp = timestamp;
        this.defaultConstraintListJson = new ArrayList<String>();
        try {
            for (SQLDefaultConstraint dc : dcs) {
                this.defaultConstraintListJson.add(MessageBuilder.createDefaultConstraintObjJson(dc));
            }
        }
        catch (TException e) {
            throw new IllegalArgumentException("Could not serialize: ", e);
        }
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public String getDB() {
        return null;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public List<SQLDefaultConstraint> getDefaultConstraints() throws Exception {
        ArrayList<SQLDefaultConstraint> dcs = new ArrayList<SQLDefaultConstraint>();
        for (String ddJson : this.defaultConstraintListJson) {
            dcs.add((SQLDefaultConstraint)MessageBuilder.getTObj(ddJson, SQLDefaultConstraint.class));
        }
        return dcs;
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString((Object)this);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not serialize: ", exception);
        }
    }
}

