/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.jdbc.InClauseBatchCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class PurgeCompactionHistoryFunction
implements TransactionalFunction<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(PurgeCompactionHistoryFunction.class);

    @Override
    public Void execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        NamedParameterJdbcTemplate jdbcTemplate = jdbcResource.getJdbcTemplate();
        Configuration conf = jdbcResource.getConf();
        ArrayList deleteSet = new ArrayList();
        long timeoutThreshold = System.currentTimeMillis() - MetastoreConf.getTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
        int didNotInitiateRetention = MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_DID_NOT_INITIATE);
        int failedRetention = this.getFailedCompactionRetention(conf);
        int succeededRetention = MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_SUCCEEDED);
        int refusedRetention = MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_REFUSED);
        jdbcTemplate.query("SELECT \"CC_ID\", \"CC_DATABASE\", \"CC_TABLE\", \"CC_PARTITION\", \"CC_STATE\" , \"CC_START\", \"CC_TYPE\" FROM \"COMPLETED_COMPACTIONS\" ORDER BY \"CC_DATABASE\", \"CC_TABLE\", \"CC_PARTITION\",\"CC_ID\" DESC", rs -> {
            String lastCompactedEntity = null;
            RetentionCounters counters = null;
            while (rs.next()) {
                CompactionInfo ci = new CompactionInfo(rs.getLong(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getString(5).charAt(0));
                ci.start = rs.getLong(6);
                ci.type = TxnUtils.dbCompactionType2ThriftType(rs.getString(7).charAt(0));
                if (!ci.getFullPartitionName().equals(lastCompactedEntity)) {
                    lastCompactedEntity = ci.getFullPartitionName();
                    counters = new RetentionCounters(didNotInitiateRetention, failedRetention, succeededRetention, refusedRetention);
                }
                this.checkForDeletion(deleteSet, ci, counters, timeoutThreshold);
            }
            return null;
        });
        if (deleteSet.size() == 0) {
            return null;
        }
        int totalCount = jdbcResource.execute(new InClauseBatchCommand("DELETE FROM \"COMPLETED_COMPACTIONS\" WHERE \"CC_ID\" in (:ids)", (SqlParameterSource)new MapSqlParameterSource().addValue("ids", deleteSet), "ids", Long::compareTo));
        LOG.debug("Removed {} records from COMPLETED_COMPACTIONS", (Object)totalCount);
        return null;
    }

    private void checkForDeletion(List<Long> deleteSet, CompactionInfo ci, RetentionCounters rc, long timeoutThreshold) {
        switch (ci.state) {
            case 'a': {
                if (--rc.didNotInitiateRetention >= 0 && !PurgeCompactionHistoryFunction.timedOut(ci, rc, timeoutThreshold)) break;
                deleteSet.add(ci.id);
                break;
            }
            case 'f': {
                if (--rc.failedRetention >= 0 && !PurgeCompactionHistoryFunction.timedOut(ci, rc, timeoutThreshold)) break;
                deleteSet.add(ci.id);
                break;
            }
            case 's': {
                if (--rc.succeededRetention < 0) {
                    deleteSet.add(ci.id);
                }
                if (ci.type == CompactionType.MAJOR) {
                    rc.hasSucceededMajorCompaction = true;
                    break;
                }
                rc.hasSucceededMinorCompaction = true;
                break;
            }
            case 'c': {
                if (--rc.refusedRetention >= 0 && !PurgeCompactionHistoryFunction.timedOut(ci, rc, timeoutThreshold)) break;
                deleteSet.add(ci.id);
                break;
            }
        }
    }

    private static boolean timedOut(CompactionInfo ci, RetentionCounters rc, long pastTimeout) {
        return ci.start < pastTimeout && (rc.hasSucceededMajorCompaction || rc.hasSucceededMinorCompaction && ci.type == CompactionType.MINOR);
    }

    private int getFailedCompactionRetention(Configuration conf) {
        int failedThreshold = MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_THRESHOLD);
        int failedRetention = MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED);
        if (failedRetention < failedThreshold) {
            LOG.warn("Invalid configuration {}={} < {}={}.  Will use {}={}", new Object[]{MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_THRESHOLD.getVarname(), failedRetention, MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED, failedRetention, MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_THRESHOLD.getVarname(), failedRetention});
            failedRetention = failedThreshold;
        }
        return failedRetention;
    }

    private static class RetentionCounters {
        int didNotInitiateRetention;
        int failedRetention;
        int succeededRetention;
        int refusedRetention;
        boolean hasSucceededMajorCompaction = false;
        boolean hasSucceededMinorCompaction = false;

        RetentionCounters(int didNotInitiateRetention, int failedRetention, int succeededRetention, int refusedRetention) {
            this.didNotInitiateRetention = didNotInitiateRetention;
            this.failedRetention = failedRetention;
            this.succeededRetention = succeededRetention;
            this.refusedRetention = refusedRetention;
        }
    }
}

