/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.action;

import com.google.cloud.Timestamp;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.TimestampConverter;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.action.GenerateInitialPartitionsAction;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao.MetadataTableDao;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.model.PartitionRecord;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class DetectNewPartitionsAction {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(DetectNewPartitionsAction.class);
    private static final @UnknownKeyFor @NonNull @Initialized Duration DEBUG_WATERMARK_DELAY = Duration.standardMinutes((long)5L);
    private final @UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics;
    private final @UnknownKeyFor @NonNull @Initialized MetadataTableDao metadataTableDao;
    @Nullable
    private final @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp endTime;
    private final @UnknownKeyFor @NonNull @Initialized GenerateInitialPartitionsAction generateInitialPartitionsAction;

    public DetectNewPartitionsAction(@UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics, @UnknownKeyFor @NonNull @Initialized MetadataTableDao metadataTableDao, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp endTime, @UnknownKeyFor @NonNull @Initialized GenerateInitialPartitionsAction generateInitialPartitionsAction) {
        this.metrics = metrics;
        this.metadataTableDao = metadataTableDao;
        this.endTime = endTime;
        this.generateInitialPartitionsAction = generateInitialPartitionsAction;
    }

    @VisibleForTesting
    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.ProcessContinuation run(@UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized OffsetRange, @UnknownKeyFor @NonNull @Initialized Long> tracker, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized PartitionRecord> receiver, @UnknownKeyFor @NonNull @Initialized ManualWatermarkEstimator<@UnknownKeyFor @NonNull @Initialized Instant> watermarkEstimator, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.BundleFinalizer bundleFinalizer, @UnknownKeyFor @NonNull @Initialized Timestamp startTime) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (this.endTime != null && this.endTime.compareTo(TimestampConverter.toCloudTimestamp(watermarkEstimator.currentWatermark())) <= 0) {
            tracker.tryClaim((Object)((OffsetRange)tracker.currentRestriction()).getTo());
            return DoFn.ProcessContinuation.stop();
        }
        if (!tracker.tryClaim((Object)((OffsetRange)tracker.currentRestriction()).getFrom())) {
            return DoFn.ProcessContinuation.stop();
        }
        return DoFn.ProcessContinuation.resume().withResumeDelay(Duration.standardSeconds((long)1L));
    }
}

