/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mongodbdelete;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.mongo.metadata.MongoDbConnection;
import org.apache.hop.mongo.wrapper.MongoClientWrapper;
import org.apache.hop.mongo.wrapper.collection.MongoCollectionWrapper;
import org.apache.hop.mongo.wrapper.cursor.MongoCursorWrapper;
import org.apache.hop.pipeline.transform.BaseTransformData;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transforms.mongodbdelete.Comparator;
import org.apache.hop.pipeline.transforms.mongodbdelete.MongoDbDeleteField;
import org.apache.hop.pipeline.transforms.mongodbdelete.MongoDbDeleteMeta;

public class MongoDbDeleteData
extends BaseTransformData
implements ITransformData {
    private static final Class<?> PKG = MongoDbDeleteMeta.class;
    public static final int MONGO_DEFAULT_PORT = 27017;
    public IRowMeta outputRowMeta;
    public MongoDbConnection connection;
    public MongoClientWrapper clientWrapper;
    public MongoCollectionWrapper collection;
    public MongoCursorWrapper cursor;
    protected List<MongoDbDeleteField> mUserFields;

    public void init(IVariables vars) throws HopException {
        if (this.mUserFields != null) {
            for (MongoDbDeleteField f : this.mUserFields) {
                f.init(vars);
            }
        }
    }

    public MongoClientWrapper getConnection() {
        return this.clientWrapper;
    }

    public void setConnection(MongoClientWrapper clientWrapper) {
        this.clientWrapper = clientWrapper;
    }

    public void createCollection(String db, String collectionName) throws Exception {
        if (this.clientWrapper == null) {
            throw new Exception(BaseMessages.getString(PKG, (String)"MongoDbDelete.ErrorMessage.NoDatabaseSet", (String[])new String[0]));
        }
        this.clientWrapper.createCollection(db, collectionName);
    }

    public void setCollection(MongoCollectionWrapper col) {
        this.collection = col;
    }

    public MongoCollectionWrapper getCollection() {
        return this.collection;
    }

    public void setOutputRowMeta(IRowMeta outM) {
        this.outputRowMeta = outM;
    }

    public IRowMeta getOutputRowMeta() {
        return this.outputRowMeta;
    }

    public void setMongoFields(List<MongoDbDeleteField> fields) {
        this.mUserFields = new ArrayList<MongoDbDeleteField>();
        for (MongoDbDeleteField f : fields) {
            this.mUserFields.add(f.copy());
        }
    }

    public static DBObject getQueryObject(List<MongoDbDeleteField> fieldDefs, IRowMeta inputMeta, Object[] row, IVariables vars) throws HopException {
        BasicDBObject query = new BasicDBObject();
        boolean haveMatchFields = false;
        boolean hasNonNullMatchValues = false;
        for (MongoDbDeleteField field : fieldDefs) {
            BasicDBObject exist;
            IValueMeta vm;
            int index;
            String field1;
            boolean hasPath;
            haveMatchFields = true;
            hasNonNullMatchValues = true;
            String mongoPath = field.mongoDocPath;
            String path = vars.resolve(mongoPath);
            boolean bl = hasPath = !StringUtil.isEmpty((String)path);
            if (!hasPath) {
                throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbDelete.ErrorMessage.NoMongoPathsDefined", (String[])new String[0]));
            }
            if (path.indexOf(91) > 0) {
                path = path.replace("[", ".").replace("]", "");
            }
            if (Comparator.EQUAL.getValue().equals(field.comparator)) {
                field1 = vars.resolve(field.incomingField1);
                index = inputMeta.indexOfValue(field1);
                vm = inputMeta.getValueMeta(index);
                if (vm.isNull(row[index])) continue;
                MongoDbDeleteData.setMongoValueFromValueMeta((DBObject)query, path, vm, row[index]);
                continue;
            }
            if (Comparator.NOT_EQUAL.getValue().equals(field.comparator)) {
                field1 = vars.resolve(field.incomingField1);
                index = inputMeta.indexOfValue(field1);
                vm = inputMeta.getValueMeta(index);
                if (vm.isNull(row[index])) continue;
                BasicDBObject notEqual = new BasicDBObject();
                MongoDbDeleteData.setMongoValueFromValueMeta((DBObject)notEqual, "$ne", vm, row[index]);
                query.put(path, (Object)notEqual);
                continue;
            }
            if (Comparator.GREATER_THAN.getValue().equals(field.comparator)) {
                field1 = vars.resolve(field.incomingField1);
                index = inputMeta.indexOfValue(field1);
                vm = inputMeta.getValueMeta(index);
                if (vm.isNull(row[index])) continue;
                BasicDBObject greaterThan = new BasicDBObject();
                MongoDbDeleteData.setMongoValueFromValueMeta((DBObject)greaterThan, "$gt", vm, row[index]);
                query.put(path, (Object)greaterThan);
                continue;
            }
            if (Comparator.GREATER_THAN_EQUAL.getValue().equals(field.comparator)) {
                field1 = vars.resolve(field.incomingField1);
                index = inputMeta.indexOfValue(field1);
                vm = inputMeta.getValueMeta(index);
                if (vm.isNull(row[index])) continue;
                BasicDBObject greaterThanEqual = new BasicDBObject();
                MongoDbDeleteData.setMongoValueFromValueMeta((DBObject)greaterThanEqual, "$gte", vm, row[index]);
                query.put(path, (Object)greaterThanEqual);
                continue;
            }
            if (Comparator.LESS_THAN.getValue().equals(field.comparator)) {
                field1 = vars.resolve(field.incomingField1);
                index = inputMeta.indexOfValue(field1);
                vm = inputMeta.getValueMeta(index);
                if (vm.isNull(row[index])) continue;
                BasicDBObject lessThan = new BasicDBObject();
                MongoDbDeleteData.setMongoValueFromValueMeta((DBObject)lessThan, "$lt", vm, row[index]);
                query.put(path, (Object)lessThan);
                continue;
            }
            if (Comparator.LESS_THAN_EQUAL.getValue().equals(field.comparator)) {
                field1 = vars.resolve(field.incomingField1);
                index = inputMeta.indexOfValue(field1);
                vm = inputMeta.getValueMeta(index);
                if (vm.isNull(row[index])) continue;
                BasicDBObject lessThanEqual = new BasicDBObject();
                MongoDbDeleteData.setMongoValueFromValueMeta((DBObject)lessThanEqual, "$lte", vm, row[index]);
                query.put(path, (Object)lessThanEqual);
                continue;
            }
            if (Comparator.BETWEEN.getValue().equals(field.comparator)) {
                if (StringUtil.isEmpty((String)field.incomingField1) || StringUtil.isEmpty((String)field.incomingField2)) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbDelete.ErrorMessage.BetweenTwoFieldsRequired", (String[])new String[0]));
                }
                field1 = vars.resolve(field.incomingField1);
                int index1 = inputMeta.indexOfValue(field1);
                IValueMeta vm1 = inputMeta.getValueMeta(index1);
                String field2 = vars.resolve(field.incomingField2);
                int index2 = inputMeta.indexOfValue(field2);
                IValueMeta vm2 = inputMeta.getValueMeta(index2);
                if (vm1.isNull(row[index1]) && vm2.isNull(row[index2])) continue;
                BasicDBObject between = new BasicDBObject();
                MongoDbDeleteData.setMongoValueFromValueMeta((DBObject)between, "$gt", vm1, row[index1]);
                MongoDbDeleteData.setMongoValueFromValueMeta((DBObject)between, "$lt", vm2, row[index2]);
                query.put(path, (Object)between);
                continue;
            }
            if (Comparator.IS_NULL.getValue().equals(field.comparator)) {
                exist = new BasicDBObject();
                exist.put((Object)"$exists", (Object)false);
                query.put(path, (Object)exist);
                continue;
            }
            if (Comparator.IS_NOT_NULL.getValue().equals(field.comparator)) {
                exist = new BasicDBObject();
                exist.put((Object)"$exists", (Object)true);
                query.put(path, (Object)exist);
                continue;
            }
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbDelete.ErrorMessage.ComparatorNotSupported", (String[])new String[]{field.comparator}));
        }
        if (!haveMatchFields) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbDelete.ErrorMessage.NoFieldsToDeleteSpecifiedForMatch", (String[])new String[0]));
        }
        if (!hasNonNullMatchValues) {
            return null;
        }
        return query;
    }

    private static boolean setMongoValueFromValueMeta(DBObject mongoObject, Object lookup, IValueMeta valueMeta, Object objectValue) throws HopValueException {
        if (valueMeta.isNull(objectValue)) {
            return false;
        }
        if (valueMeta.isString()) {
            String val = valueMeta.getString(objectValue);
            mongoObject.put(lookup.toString(), (Object)val);
            return true;
        }
        if (valueMeta.isBoolean()) {
            Boolean val = valueMeta.getBoolean(objectValue);
            mongoObject.put(lookup.toString(), (Object)val);
            return true;
        }
        if (valueMeta.isInteger()) {
            Long val = valueMeta.getInteger(objectValue);
            mongoObject.put(lookup.toString(), (Object)val);
            return true;
        }
        if (valueMeta.isDate()) {
            Date val = valueMeta.getDate(objectValue);
            mongoObject.put(lookup.toString(), (Object)val);
            return true;
        }
        if (valueMeta.isNumber()) {
            Double val = valueMeta.getNumber(objectValue);
            mongoObject.put(lookup.toString(), (Object)val);
            return true;
        }
        if (valueMeta.isBigNumber()) {
            String val = valueMeta.getString(objectValue);
            mongoObject.put(lookup.toString(), (Object)val);
            return true;
        }
        if (valueMeta.isBinary()) {
            byte[] val = valueMeta.getBinary(objectValue);
            mongoObject.put(lookup.toString(), (Object)val);
            return true;
        }
        if (valueMeta.isSerializableType()) {
            throw new HopValueException(BaseMessages.getString(PKG, (String)"MongoDbDelete.ErrorMessage.CantStoreHopSerializableVals", (String[])new String[0]));
        }
        return false;
    }

    public static String cleansePath(String path) {
        String cleanKey;
        String key;
        int index = path.indexOf("${");
        int endIndex = 0;
        String tempStr = path;
        while (index >= 0 && (endIndex += tempStr.indexOf("}")) > 0 && endIndex > (index += 2) + 1 && endIndex + 1 < (path = path.replace(key = path.substring(index, endIndex), cleanKey = key.replace('.', '_'))).length()) {
            tempStr = path.substring(endIndex + 1, path.length());
            index = tempStr.indexOf("${");
            if (index <= 0) continue;
            index += endIndex;
        }
        return path;
    }
}

