/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.execution;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowBuffer;
import org.apache.hop.core.row.RowMetaBuilder;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.execution.ExecutionData;
import org.apache.hop.execution.ExecutionDataSetMeta;
import org.apache.hop.execution.ExecutionType;
import org.apache.hop.execution.sampler.IExecutionDataSamplerStore;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.engine.IWorkflowEngine;

public final class ExecutionDataBuilder {
    public static final String ALL_TRANSFORMS = "all-transforms";
    public static final String KEY_RESULT = "result";
    public static final String KEY_ROWS = "rows";
    public static final String KEY_FILES = "files";
    public static final String KEY_VARIABLES_BEFORE = "variables_before";
    public static final String KEY_VARIABLES_AFTER = "variables_after";
    public static final String RESULT_KEY_RESULT = "result?";
    public static final String RESULT_KEY_ERRORS = "errors";
    public static final String RESULT_KEY_STOPPED = "stopped?";
    private ExecutionType executionType;
    private ExecutionDataSetMeta dataSetMeta;
    private boolean finished;
    private Date collectionDate = new Date();
    private String parentId;
    private String ownerId;
    private Map<String, RowBuffer> dataSets = Collections.synchronizedMap(new HashMap());
    private Map<String, ExecutionDataSetMeta> setMetaData = Collections.synchronizedMap(new HashMap());

    private ExecutionDataBuilder() {
    }

    public static ExecutionDataBuilder of() {
        return new ExecutionDataBuilder();
    }

    public static ExecutionDataBuilder fromAllTransformData(IPipelineEngine<PipelineMeta> pipeline, Map<String, List<IExecutionDataSamplerStore>> samplerStoresMap, boolean finished) {
        ExecutionDataBuilder dataBuilder = ExecutionDataBuilder.of().withExecutionType(ExecutionType.Transform).withParentId(pipeline.getLogChannelId()).withOwnerId(ALL_TRANSFORMS).withFinished(finished);
        if (samplerStoresMap != null) {
            for (String transformName : samplerStoresMap.keySet()) {
                List<IExecutionDataSamplerStore> samplerStores = samplerStoresMap.get(transformName);
                for (IExecutionDataSamplerStore samplerStore : samplerStores) {
                    dataBuilder = dataBuilder.addDataSets(samplerStore.getSamples()).addSetMeta(samplerStore.getSamplesMetadata());
                }
            }
        }
        dataBuilder = dataBuilder.withCollectionDate(new Date());
        return dataBuilder;
    }

    public static ExecutionDataBuilder beforeActionExecution(IWorkflowEngine<WorkflowMeta> workflow, ActionMeta actionMeta, IAction action, IVariables referenceVariables) {
        String logChannelId = action.getLogChannel().getLogChannelId();
        ExecutionDataBuilder dataBuilder = ExecutionDataBuilder.of().withExecutionType(ExecutionType.Action).withParentId(workflow.getLogChannelId()).withOwnerId(logChannelId).withDataSetMeta(new ExecutionDataSetMeta(logChannelId, logChannelId, actionMeta.getName(), "", "action")).withFinished(false);
        ExecutionDataBuilder.addBeforeVariables(dataBuilder, referenceVariables, workflow, action.getLogChannel().getLogChannelId(), action.getName());
        return dataBuilder;
    }

    private static void addBeforeVariables(ExecutionDataBuilder dataBuilder, IVariables referenceVariables, IVariables variables, String logChannelId, String actionName) {
        IRowMeta rowMeta = new RowMetaBuilder().addString("variable").addString("value").build();
        RowBuffer rowBuffer = new RowBuffer(rowMeta);
        String[] variableNames = referenceVariables.getVariableNames();
        for (String variableName : variables.getVariableNames()) {
            if (Const.indexOfString((String)variableName, (String[])variableNames) >= 0) continue;
            String valueValue = variables.getVariable(variableName);
            rowBuffer.addRow(new Object[]{variableName, valueValue});
        }
        if (!rowBuffer.isEmpty()) {
            String resultKey = KEY_VARIABLES_BEFORE;
            ExecutionDataSetMeta dataSetMeta = new ExecutionDataSetMeta(resultKey, logChannelId, actionName, "", "Variables before execution");
            dataBuilder.addSetMeta(resultKey, dataSetMeta);
            dataBuilder.addDataSet(resultKey, rowBuffer);
        }
    }

    public static ExecutionDataBuilder afterActionExecution(IWorkflowEngine<WorkflowMeta> workflow, ActionMeta actionMeta, IAction action, Result result, IVariables referenceVariables, IVariables beforeVariables) {
        String logChannelId = action.getLogChannel().getLogChannelId();
        ExecutionDataBuilder dataBuilder = ExecutionDataBuilder.of().withExecutionType(ExecutionType.Action).withParentId(workflow.getLogChannelId()).withOwnerId(logChannelId).withDataSetMeta(new ExecutionDataSetMeta(logChannelId, logChannelId, actionMeta.getName(), Long.toString(result.getEntryNr()), "action")).withFinished(true);
        IRowMeta resultRowMeta = new RowMetaBuilder().addString("key").addString("value").build();
        RowBuffer resultBuffer = new RowBuffer(resultRowMeta);
        resultBuffer.addRow(new Object[]{RESULT_KEY_RESULT, result.getResult() ? "true" : "false"});
        resultBuffer.addRow(new Object[]{RESULT_KEY_ERRORS, Long.toString(result.getNrErrors())});
        resultBuffer.addRow(new Object[]{RESULT_KEY_STOPPED, result.isStopped() ? "true" : "false"});
        Object resultKey = KEY_RESULT;
        ExecutionDataSetMeta executionDataSetMeta = new ExecutionDataSetMeta((String)resultKey, action.getLogChannel().getLogChannelId(), actionMeta.getName(), Long.toString(result.getEntryNr()), "Result details of action");
        dataBuilder.addSetMeta((String)resultKey, executionDataSetMeta);
        dataBuilder.addDataSet((String)resultKey, resultBuffer);
        if (result.getRows() != null && !result.getRows().isEmpty()) {
            IRowMeta rowsMeta = ((RowMetaAndData)result.getRows().get(0)).getRowMeta();
            RowBuffer rowsBuffer = new RowBuffer(rowsMeta);
            for (RowMetaAndData rowMetaAndData : result.getRows()) {
                rowsBuffer.addRow(rowMetaAndData.getData());
            }
            resultKey = KEY_ROWS;
            ExecutionDataSetMeta executionDataSetMeta2 = new ExecutionDataSetMeta((String)resultKey, action.getLogChannel().getLogChannelId(), actionMeta.getName(), Long.toString(result.getEntryNr()), "Result rows of action");
            dataBuilder.addSetMeta((String)resultKey, executionDataSetMeta2);
            dataBuilder.addDataSet((String)resultKey, rowsBuffer);
        }
        if (result.getResultFiles() != null && !result.getResultFiles().isEmpty()) {
            IRowMeta filesMeta = new RowMetaBuilder().addString("filename").addString("type").addString("origin").build();
            RowBuffer filesBuffer = new RowBuffer(filesMeta);
            for (ResultFile resultFile : result.getResultFilesList()) {
                filesBuffer.addRow(new Object[]{resultFile.getFile().toString(), resultFile.getTypeDesc(), resultFile.getOrigin()});
            }
            resultKey = KEY_FILES;
            ExecutionDataSetMeta executionDataSetMeta3 = new ExecutionDataSetMeta((String)resultKey, action.getLogChannel().getLogChannelId(), actionMeta.getName(), Long.toString(result.getEntryNr()), "Result files of action");
            dataBuilder.addSetMeta((String)resultKey, executionDataSetMeta3);
            dataBuilder.addDataSet((String)resultKey, filesBuffer);
        }
        IRowMeta rowMeta = new RowMetaBuilder().addString("variable").addString("value").build();
        RowBuffer rowBuffer = new RowBuffer(rowMeta);
        String[] variableNames = referenceVariables.getVariableNames();
        for (String variableName : workflow.getVariableNames()) {
            if (Const.indexOfString((String)variableName, (String[])variableNames) >= 0) continue;
            String valueValue = workflow.getVariable(variableName);
            rowBuffer.addRow(new Object[]{variableName, valueValue});
        }
        if (!rowBuffer.isEmpty()) {
            String string = KEY_VARIABLES_AFTER;
            ExecutionDataSetMeta dataSetMeta2 = new ExecutionDataSetMeta(string, action.getLogChannel().getLogChannelId(), actionMeta.getName(), Long.toString(result.getEntryNr()), "Variables after execution");
            dataBuilder.addSetMeta(string, dataSetMeta2);
            dataBuilder.addDataSet(string, rowBuffer);
        }
        if (beforeVariables != null) {
            ExecutionDataBuilder.addBeforeVariables(dataBuilder, referenceVariables, beforeVariables, action.getLogChannel().getLogChannelId(), action.getName());
        }
        return dataBuilder;
    }

    public ExecutionDataBuilder withExecutionType(ExecutionType executionType) {
        this.executionType = executionType;
        return this;
    }

    public ExecutionDataBuilder withDataSetMeta(ExecutionDataSetMeta dataSetMeta) {
        this.dataSetMeta = dataSetMeta;
        return this;
    }

    public ExecutionDataBuilder withFinished(boolean finished) {
        this.finished = finished;
        return this;
    }

    public ExecutionDataBuilder withCollectionDate(Date collectionDate) {
        this.collectionDate = collectionDate;
        return this;
    }

    public ExecutionDataBuilder withParentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    public ExecutionDataBuilder withOwnerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public ExecutionDataBuilder withDataSets(Map<String, RowBuffer> dataSets) {
        this.dataSets = dataSets;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionDataBuilder withSetDescriptions(Map<String, ExecutionDataSetMeta> setDescriptions) {
        Map<String, ExecutionDataSetMeta> map = setDescriptions;
        synchronized (map) {
            this.setMetaData = setDescriptions;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionDataBuilder addDataSets(Map<String, RowBuffer> dataSets) {
        Map<String, RowBuffer> map = dataSets;
        synchronized (map) {
            this.dataSets.putAll(dataSets);
        }
        return this;
    }

    public ExecutionDataBuilder addDataSet(String key, RowBuffer buffer) {
        return this.addDataSets(Map.of(key, buffer));
    }

    public ExecutionDataBuilder addSetMeta(Map<String, ExecutionDataSetMeta> setDescriptions) {
        this.setMetaData.putAll(setDescriptions);
        return this;
    }

    public ExecutionDataBuilder addSetMeta(String key, ExecutionDataSetMeta setMeta) {
        return this.addSetMeta(Map.of(key, setMeta));
    }

    public ExecutionData build() {
        ExecutionData executionData = new ExecutionData();
        executionData.setExecutionType(this.executionType);
        executionData.setDataSetMeta(this.dataSetMeta);
        executionData.setFinished(this.finished);
        executionData.setCollectionDate(this.collectionDate);
        executionData.setParentId(this.parentId);
        executionData.setOwnerId(this.ownerId);
        executionData.setDataSets(this.dataSets);
        executionData.setSetMetaData(this.setMetaData);
        return executionData;
    }
}

