/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow;

import java.util.ArrayList;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.AreaOwner;
import org.apache.hop.core.gui.DPoint;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.gui.SvgGc;
import org.apache.hop.core.svg.HopSvgGraphics2D;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.WorkflowPainter;

public class WorkflowSvgPainter {
    public static final String generateWorkflowSvg(WorkflowMeta workflowMeta, float magnification, IVariables variables) throws HopException {
        try {
            Point maximum = workflowMeta.getMaximum();
            maximum.multiply(magnification);
            HopSvgGraphics2D graphics2D = HopSvgGraphics2D.newDocument();
            SvgGc gc = new SvgGc(graphics2D, new Point(maximum.x, maximum.y), 32, 0, 0);
            WorkflowPainter workflowPainter = new WorkflowPainter(gc, variables, workflowMeta, maximum, new DPoint(0.0, 0.0), null, null, new ArrayList<AreaOwner>(), 32, 1, 0, "Arial", 10, 1.0, false);
            workflowPainter.setMagnification(magnification);
            workflowPainter.drawWorkflow();
            return graphics2D.toXml();
        }
        catch (Exception e) {
            throw new HopException("Unable to generate SVG for workflow " + workflowMeta.getName(), (Throwable)e);
        }
    }
}

