/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.json.HopJson;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.HopServerConfig;
import org.apache.hop.www.HopServerObjectEntry;
import org.apache.hop.www.HopServerPipelineStatus;
import org.apache.hop.www.HopServerStatus;
import org.apache.hop.www.HopServerWorkflowStatus;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.PipelineMap;
import org.apache.hop.www.WorkflowMap;

@HopServerServlet(id="status", name="Get the status of the server")
public class GetStatusServlet
extends BaseHttpServlet
implements IHopServerPlugin {
    private static final Class<?> PKG = GetStatusServlet.class;
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/hop/status";

    public GetStatusServlet() {
    }

    public GetStatusServlet(PipelineMap pipelineMap, WorkflowMap workflowMap) {
        super(pipelineMap, workflowMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"GetStatusServlet.StatusRequested", (String[])new String[0]));
        }
        response.setStatus(200);
        String root = request.getRequestURI() == null ? "/hop" : request.getRequestURI().substring(0, request.getRequestURI().indexOf(CONTEXT_PATH));
        Object prefix = this.isJettyMode() ? "/static" : root + "/content/common-ui/resources/themes";
        boolean useXml = "Y".equalsIgnoreCase(request.getParameter("xml"));
        boolean useJson = "Y".equalsIgnoreCase(request.getParameter("json"));
        boolean useLightTheme = "Y".equalsIgnoreCase(request.getParameter("useLightTheme"));
        if (useXml) {
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
        }
        if (useJson) {
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
        } else {
            response.setContentType("text/html;charset=UTF-8");
        }
        PrintWriter out = response.getWriter();
        List<HopServerObjectEntry> pipelineEntries = this.getPipelineMap().getPipelineObjects();
        List<HopServerObjectEntry> actions = this.getWorkflowMap().getWorkflowObjects();
        if (useXml || useJson) {
            HopServerStatus serverStatus = new HopServerStatus();
            serverStatus.setStatusDescription("Online");
            GetStatusServlet.getSystemInfo(serverStatus);
            for (HopServerObjectEntry entry : pipelineEntries) {
                IPipelineEngine<PipelineMeta> pipeline = this.getPipelineMap().getPipeline(entry);
                String statusDescription = pipeline.getStatusDescription();
                HopServerPipelineStatus pipelineStatus = new HopServerPipelineStatus(entry.getName(), entry.getId(), statusDescription);
                pipelineStatus.setLogDate(new Date());
                pipelineStatus.setExecutionStartDate(pipeline.getExecutionStartDate());
                pipelineStatus.setExecutionEndDate(pipeline.getExecutionEndDate());
                pipelineStatus.setPaused(pipeline.isPaused());
                serverStatus.getPipelineStatusList().add(pipelineStatus);
            }
            for (HopServerObjectEntry entry : actions) {
                IWorkflowEngine<WorkflowMeta> workflow = this.getWorkflowMap().getWorkflow(entry);
                String status = workflow.getStatusDescription();
                HopServerWorkflowStatus workflowStatus = new HopServerWorkflowStatus(entry.getName(), entry.getId(), status);
                workflowStatus.setLogDate(new Date());
                workflowStatus.setExecutionStartDate(workflow.getExecutionStartDate());
                workflowStatus.setExecutionEndDate(workflow.getExecutionEndDate());
                serverStatus.getWorkflowStatusList().add(workflowStatus);
            }
            if (useXml) {
                try {
                    out.print(XmlHandler.getXmlHeader((String)"UTF-8"));
                    out.println(serverStatus.getXml());
                }
                catch (HopException e) {
                    throw new ServletException("Unable to get the server status in XML format", (Throwable)e);
                }
            } else {
                ObjectMapper mapper = HopJson.newMapper();
                String jsonString = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)serverStatus);
                out.println(jsonString);
            }
        } else {
            out.println("<HTML>");
            out.println("<HEAD><TITLE>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.HopHopServerStatus", (String[])new String[0]) + "</TITLE>");
            out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
            int tableBorder = 1;
            if (!useLightTheme) {
                if (this.isJettyMode()) {
                    out.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"/static/css/hop-server.css\" />");
                } else {
                    out.println("<style>");
                    out.println(".hop-table td, tr.cellTableRow, td.gwt-MenuItem, .toolbar-button:not(.toolbar-button-disabled) {");
                    out.println("  cursor: pointer;");
                    out.println("}");
                    out.println(".toolbar-button-disabled {");
                    out.println("  opacity: 0.4;");
                    out.println("}");
                    out.println("div#messageDialogBody:first-letter {");
                    out.println("  text-transform: capitalize;");
                    out.println("}");
                    out.println("</style>");
                }
                tableBorder = 0;
            }
            out.println("</HEAD>");
            out.println("<BODY class=\"hop-page-background dragdrop-dropTarget dragdrop-boundary\" style=\"overflow: auto;\">");
            out.println("<div id=\"selectedTableItem\">");
            out.println("<value></value>");
            out.println("</div>");
            out.println("<div class=\"row\" id=\"pucHeader\">");
            String htmlClass = useLightTheme ? "h1" : "div";
            out.println("<" + htmlClass + " class=\"workspaceHeading\" style=\"padding: 0px 0px 0px 10px;\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.TopStatus", (String[])new String[0]) + "</" + htmlClass + ">");
            out.println("</div>");
            try {
                String run = BaseMessages.getString(PKG, (String)"HopServerStatusServlet.Run", (String[])new String[0]);
                String stop = BaseMessages.getString(PKG, (String)"HopServerStatusServlet.StopPipeline", (String[])new String[0]);
                String cleanup = BaseMessages.getString(PKG, (String)"HopServerStatusServlet.CleanupPipeline", (String[])new String[0]);
                String view = BaseMessages.getString(PKG, (String)"HopServerStatusServlet.ViewPipelineDetails", (String[])new String[0]);
                String remove = BaseMessages.getString(PKG, (String)"HopServerStatusServlet.RemovePipeline", (String[])new String[0]);
                out.println("<div class=\"row\" style=\"padding: 0px 0px 0px 30px\">");
                htmlClass = useLightTheme ? "h2" : "div";
                out.println("<div class=\"row\" style=\"padding: 25px 30px 75px 0px;\">");
                out.println("<" + htmlClass + " class=\"workspaceHeading\" style=\"padding: 0px 0px 0px 0px;\">Pipelines</" + htmlClass + ">");
                out.println("<table id=\"pipeline-table\" cellspacing=\"0\" cellpadding=\"0\"><tbody><tr><td align=\"left\" width=\"100%\" style=\"vertical-align:middle;\">");
                out.println("<table cellspacing=\"0\" cellpadding=\"0\" class=\"toolbar\" style=\"width: 100%; height: 26px; margin-bottom: 2px; border: 0;\">");
                out.println("<tbody><tr>");
                out.println("<td align=\"left\" style=\"vertical-align: middle; width: 100%\" id=\"pipeline-align\"></td>");
                out.println("<td " + this.setupIconEnterLeaveJavascript("pause") + " align=\"left\" style=\"vertical-align: middle;\"><div style=\"padding: 2px;\" onClick=\"resumeFunction( this )\" class=\"toolbar-button toolbar-button-disabled\" id=\"pause\"><img style=\"width: 22px; height: 22px\" src=\"" + (String)prefix + "/images/run.svg\" title=\"" + run + "\"/></div></td>");
                out.println("<td " + this.setupIconEnterLeaveJavascript("stop") + " align=\"left\" style=\"vertical-align: middle;\"><div style=\"padding: 2px;\" onClick=\"stopFunction( this )\" class=\"toolbar-button toolbar-button-disabled\" id=\"stop\"><img style=\"width: 22px; height: 22px\"src=\"" + (String)prefix + "/images/stop.svg\" title=\"" + stop + "\"/></div></td>");
                out.println("<td " + this.setupIconEnterLeaveJavascript("cleanup") + " align=\"left\" style=\"vertical-align: middle;\"><div style=\"padding: 2px; margin-left: 10px !important;\" onClick=\"cleanupFunction( this )\" class=\"toolbar-button toolbar-button-disabled\" id=\"cleanup\"><img style=\"width: 22px; height: 22px\"src=\"" + (String)prefix + "/images/cleanup.svg\" title=\"" + cleanup + "\"/></div></td>");
                out.println("<td " + this.setupIconEnterLeaveJavascript("view") + " align=\"left\" style=\"vertical-align: middle;\"><div style=\"padding: 2px; margin-left: 0 !important;\" onClick=\"viewFunction( this )\" class=\"toolbar-button toolbar-button-disabled\" id=\"view\"><img style=\"width: 22px; height: 22px\" src=\"" + (String)prefix + "/images/view.svg\" title=\"" + view + "\"/></div></td>");
                out.println("<td " + this.setupIconEnterLeaveJavascript("close") + " align=\"left\" style=\"vertical-align: middle;\"><div style=\"padding: 2px; margin-right: 10px;\" onClick=\"removeFunction( this )\" class=\"toolbar-button toolbar-button-disabled\" id=\"close\"><img style=\"width: 22px; height: 22px\" src=\"" + (String)prefix + "/images/close.svg\" title=\"" + remove + "\"/></div></td>");
                out.println("</tr></tbody></table>");
                out.println("<div id=\"runActions\" class=\"custom-dropdown-popup\" style=\"visibility: hidden; overflow: visible; position: fixed;\" onLoad=\"repositionActions( this, document.getElementById( 'pause' ) )\" onMouseLeave=\"this.style='visibility: hidden; overflow: visible; position: fixed;'\"><div class=\"popupContent\"><div style=\"padding: 0;\" class=\"gwt-MenuBar gwt-MenuBar-vertical\"><table><tbody><tr><td class=\"gwt-MenuItem\" onClick=\"runPipelineSelector( this )\" onMouseEnter=\"this.className='gwt-MenuItem gwt-MenuItem-selected'\" onMouseLeave=\"this.className='gwt-MenuItem'\">Prepare the execution</td></tr><tr><td class=\"gwt-MenuItem\" onClick=\"runPipelineSelector( this )\" onMouseEnter=\"this.className='gwt-MenuItem gwt-MenuItem-selected'\" onMouseLeave=\"this.className='gwt-MenuItem'\">Run</td></tr></tbody></table></div></div></div>");
                out.println("<div id=\"stopActions\" class=\"custom-dropdown-popup\" style=\"visibility: hidden; overflow: visible; position: fixed;\" onLoad=\"repositionActions( this, document.getElementById( 'stop' ) )\" onMouseLeave=\"this.style='visibility: hidden; overflow: visible; position: fixed;'\"><div class=\"popupContent\"><div style=\"padding: 0;\" class=\"gwt-MenuBar gwt-MenuBar-vertical\"><table><tbody><tr><td class=\"gwt-MenuItem\" onClick=\"stopPipelineSelector( this )\" onMouseEnter=\"this.className='gwt-MenuItem gwt-MenuItem-selected'\" onMouseLeave=\"this.className='gwt-MenuItem'\">Stop pipeline</td></tr><tr><td class=\"gwt-MenuItem\" onClick=\"stopPipelineSelector( this )\" onMouseEnter=\"this.className='gwt-MenuItem gwt-MenuItem-selected'\" onMouseLeave=\"this.className='gwt-MenuItem'\">Stop input processing</td></tr></tbody></table></div></div></div>");
                out.println(this.messageDialog());
                out.println("<table class=\"hop-table\" border=\"" + tableBorder + "\">");
                out.print("<tr> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.PipelineName", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.ServerId", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Status", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.StartDate", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.LastLogTime", (String[])new String[0]) + "</th> </tr>");
                Comparator pipelineComparator = (o1, o2) -> {
                    int logDateCompare;
                    IPipelineEngine<PipelineMeta> t1 = this.getPipelineMap().getPipeline((HopServerObjectEntry)o1);
                    IPipelineEngine<PipelineMeta> t2 = this.getPipelineMap().getPipeline((HopServerObjectEntry)o2);
                    Date d1 = t1.getExecutionStartDate();
                    Date d2 = t2.getExecutionStartDate();
                    if (d1 != null && d2 != null && (logDateCompare = d2.compareTo(d1)) != 0) {
                        return logDateCompare;
                    }
                    return o1.compareTo((HopServerObjectEntry)o2);
                };
                Collections.sort(pipelineEntries, pipelineComparator);
                boolean evenRow = true;
                for (int i = 0; i < pipelineEntries.size(); ++i) {
                    String name = pipelineEntries.get(i).getName();
                    String id = pipelineEntries.get(i).getId();
                    IPipelineEngine<PipelineMeta> pipeline = this.getPipelineMap().getPipeline(pipelineEntries.get(i));
                    String statusDescription = pipeline.getStatusDescription();
                    String trClass = evenRow ? "cellTableEvenRow" : "cellTableOddRow";
                    String tdClass = evenRow ? "cellTableEvenRowCell" : "cellTableOddRowCell";
                    evenRow = !evenRow;
                    String firstColumn = i == 0 ? "cellTableFirstColumn" : "";
                    String lastColumn = i == pipelineEntries.size() - 1 ? "cellTableLastColumn" : "";
                    out.print("<tr onMouseEnter=\"mouseEnterFunction( this, '" + trClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + trClass + "' )\" onClick=\"clickFunction( this, '" + trClass + "' )\" id=\"cellTableRow_" + i + "\" class=\"" + trClass + "\">");
                    out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"cellTableFirstCell_" + i + "\" class=\"cellTableCell cellTableFirstColumn " + tdClass + "\">" + name + "</td>");
                    out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"cellTableCell_" + i + "\" class=\"cellTableCell " + tdClass + "\">" + id + "</td>");
                    out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"cellTableCellStatus_" + i + "\" class=\"cellTableCell " + tdClass + "\">" + statusDescription + "</td>");
                    String dateStr = XmlHandler.date2string((Date)pipeline.getExecutionStartDate());
                    out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"cellTableCell_" + i + "\" class=\"cellTableCell " + tdClass + "\">" + (dateStr != null ? dateStr.substring(0, dateStr.indexOf(32)) : "-") + "</td>");
                    out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"cellTableLastCell_" + i + "\" class=\"cellTableCell cellTableLastColumn " + tdClass + "\">" + (dateStr != null ? dateStr.substring(dateStr.indexOf(32)) : "-") + "</td>");
                    out.print("</tr>");
                }
                out.print("</table></table>");
                out.print("</div>");
                String runJ = BaseMessages.getString(PKG, (String)"HopServerStatusServlet.Run", (String[])new String[0]);
                String stopJ = BaseMessages.getString(PKG, (String)"HopServerStatusServlet.StopWorkflow", (String[])new String[0]);
                String viewJ = BaseMessages.getString(PKG, (String)"HopServerStatusServlet.ViewWorkflowDetails", (String[])new String[0]);
                String removeJ = BaseMessages.getString(PKG, (String)"HopServerStatusServlet.RemoveWorkflow", (String[])new String[0]);
                out.println("<div class=\"row\" style=\"padding: 0px 30px 75px 0px;\">");
                out.println("<" + htmlClass + " class=\"workspaceHeading\" style=\"padding: 0px 0px 0px 0px;\">Workflows</" + htmlClass + ">");
                out.println("<table cellspacing=\"0\" cellpadding=\"0\"><tbody><tr><td align=\"left\" width=\"100%\" style=\"vertical-align:middle;\">");
                out.println("<table cellspacing=\"0\" cellpadding=\"0\" class=\"toolbar\" style=\"width: 100%; height: 26px; margin-bottom: 2px; border: 0;\">");
                out.println("<tbody><tr>");
                out.println("<td align=\"left\" style=\"vertical-align: middle; width: 100%\"></td>");
                out.println("<td " + this.setupIconEnterLeaveJavascript("j-pause") + " align=\"left\" style=\"vertical-align: middle;\"><div style=\"padding: 2px;\" onClick=\"resumeFunction( this )\" class=\"toolbar-button toolbar-button-disabled\" id=\"j-pause\"><img style=\"width: 22px; height: 22px\" src=\"" + (String)prefix + "/images/run.svg\" title=\"" + runJ + "\"/></div></td>");
                out.println("<td " + this.setupIconEnterLeaveJavascript("j-stop") + " align=\"left\" style=\"vertical-align: middle;\"><div style=\"padding: 2px;\" onClick=\"stopFunction( this )\" class=\"toolbar-button toolbar-button-disabled\" id=\"j-stop\"><img style=\"width: 22px; height: 22px\"src=\"" + (String)prefix + "/images/stop.svg\" title=\"" + stopJ + "\"/></div></td>");
                out.println("<td " + this.setupIconEnterLeaveJavascript("j-view") + " align=\"left\" style=\"vertical-align: middle;\"><div style=\"padding: 2px;\" onClick=\"viewFunction( this )\" class=\"toolbar-button toolbar-button-disabled\" id=\"j-view\"><img style=\"width: 22px; height: 22px\" src=\"" + (String)prefix + "/images/view.svg\" title=\"" + viewJ + "\"/></div></td>");
                out.println("<td " + this.setupIconEnterLeaveJavascript("j-close") + " align=\"left\" style=\"vertical-align: middle;\"><div style=\"padding: 2px; margin-right: 10px;\" onClick=\"removeFunction( this )\" class=\"toolbar-button toolbar-button-disabled\" id=\"j-close\"><img style=\"width: 22px; height: 22px\" src=\"" + (String)prefix + "/images/close.svg\" title=\"" + removeJ + "\"/></div></td>");
                out.println("</tr></tbody></table>");
                out.println("<table class=\"hop-table\" border=\"" + tableBorder + "\">");
                out.print("<tr> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.WorkflowName", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.ServerId", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Status", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.StartDate", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.LastLogTime", (String[])new String[0]) + "</th> </tr>");
                Comparator jobComparator = (o1, o2) -> {
                    int logDateCompare;
                    IWorkflowEngine<WorkflowMeta> t1 = this.getWorkflowMap().getWorkflow((HopServerObjectEntry)o1);
                    IWorkflowEngine<WorkflowMeta> t2 = this.getWorkflowMap().getWorkflow((HopServerObjectEntry)o2);
                    Date d1 = t1.getExecutionStartDate();
                    Date d2 = t2.getExecutionStartDate();
                    if (d1 != null && d2 != null && (logDateCompare = d2.compareTo(d1)) != 0) {
                        return logDateCompare;
                    }
                    return o1.compareTo((HopServerObjectEntry)o2);
                };
                Collections.sort(actions, jobComparator);
                evenRow = true;
                for (int i = 0; i < actions.size(); ++i) {
                    String name = actions.get(i).getName();
                    String id = actions.get(i).getId();
                    IWorkflowEngine<WorkflowMeta> workflow = this.getWorkflowMap().getWorkflow(actions.get(i));
                    String status = workflow.getStatusDescription();
                    String trClass = evenRow ? "cellTableEvenRow" : "cellTableOddRow";
                    String tdClass = evenRow ? "cellTableEvenRowCell" : "cellTableOddRowCell";
                    evenRow = !evenRow;
                    out.print("<tr onMouseEnter=\"mouseEnterFunction( this, '" + trClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + trClass + "' )\" onClick=\"clickFunction( this, '" + trClass + "' )\" id=\"j-cellTableRow_" + i + "\" class=\"cellTableCell " + trClass + "\">");
                    out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"j-cellTableFirstCell_" + i + "\" class=\"cellTableCell cellTableFirstColumn " + tdClass + "\">" + name + "</a></td>");
                    out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"j-cellTableCell_" + i + "\" class=\"cellTableCell " + tdClass + "\">" + id + "</td>");
                    out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"j-cellTableCell_" + i + "\" class=\"cellTableCell " + tdClass + "\">" + status + "</td>");
                    String dateStr = XmlHandler.date2string((Date)workflow.getExecutionStartDate());
                    out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"j-cellTableCell_" + i + "\" class=\"cellTableCell " + tdClass + "\">" + (dateStr != null ? dateStr.substring(0, dateStr.indexOf(32)) : "-") + "</td>");
                    out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"j-cellTableLastCell_" + i + "\" class=\"cellTableCell cellTableLastColumn " + tdClass + "\">" + (dateStr != null ? dateStr.substring(dateStr.indexOf(32)) : "-") + "</td>");
                    out.print("</tr>");
                }
                out.print("</table></table>");
                out.print("</div>");
            }
            catch (Exception ex) {
                out.println("<pre>");
                ex.printStackTrace(out);
                out.println("</pre>");
            }
            out.println("<div class=\"row\" style=\"padding: 0px 0px 30px 0px;\">");
            htmlClass = useLightTheme ? "h3" : "div";
            out.println("<div><" + htmlClass + " class=\"workspaceHeading\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.ConfigurationDetails.Title", (String[])new String[0]) + "</" + htmlClass + "></div>");
            out.println("<table border=\"" + tableBorder + "\">");
            HopServerConfig serverConfig = this.getPipelineMap().getHopServerConfig();
            if (serverConfig != null) {
                Object maxLines = "";
                maxLines = serverConfig.getMaxLogLines() == 0 ? BaseMessages.getString(PKG, (String)"GetStatusServlet.NoLimit", (String[])new String[0]) : serverConfig.getMaxLogLines() + BaseMessages.getString(PKG, (String)"GetStatusServlet.Lines", (String[])new String[0]);
                out.print("<tr style=\"font-size: 12;\"> <td style=\"padding: 2px 10px 2px 10px\" class=\"cellTableCell cellTableEvenRowCell cellTableFirstColumn\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Parameter.MaxLogLines", (String[])new String[0]) + "</td> <td style=\"padding: 2px 10px 2px 10px\" class=\"cellTableCell cellTableEvenRowCell cellTableLastColumn\">" + (String)maxLines + "</td> </tr>");
                Object maxAge = "";
                maxAge = serverConfig.getMaxLogTimeoutMinutes() == 0 ? BaseMessages.getString(PKG, (String)"GetStatusServlet.NoLimit", (String[])new String[0]) : serverConfig.getMaxLogTimeoutMinutes() + BaseMessages.getString(PKG, (String)"GetStatusServlet.Minutes", (String[])new String[0]);
                out.print("<tr style=\"font-size: 12;\"> <td style=\"padding: 2px 10px 2px 10px\" class=\"cellTableCell cellTableEvenRowCell cellTableFirstColumn\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Parameter.MaxLogLinesAge", (String[])new String[0]) + "</td> <td style=\"padding: 2px 10px 2px 10px\" class=\"cellTableCell cellTableEvenRowCell cellTableLastColumn\">" + (String)maxAge + "</td> </tr>");
                Object maxObjAge = "";
                maxObjAge = serverConfig.getObjectTimeoutMinutes() == 0 ? BaseMessages.getString(PKG, (String)"GetStatusServlet.NoLimit", (String[])new String[0]) : serverConfig.getObjectTimeoutMinutes() + BaseMessages.getString(PKG, (String)"GetStatusServlet.Minutes", (String[])new String[0]);
                out.print("<tr style=\"font-size: 12;\"> <td style=\"padding: 2px 10px 2px 10px\" class=\"cellTableCell cellTableEvenRowCell cellTableFirstColumn\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Parameter.MaxObjectsAge", (String[])new String[0]) + "</td> <td style=\"padding: 2px 10px 2px 10px\" class=\"cellTableCell cellTableEvenRowCell cellTableLastColumn\">" + (String)maxObjAge + "</td> </tr>");
                out.print("</table>");
                String filename = serverConfig.getFilename();
                if (filename == null) {
                    filename = BaseMessages.getString(PKG, (String)"GetStatusServlet.ConfigurationDetails.UsingDefaults", (String[])new String[0]);
                }
                out.println("</div>");
                out.print("<div class=\"row\">");
                out.println("<i>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.ConfigurationDetails.Advice", (String[])new String[]{filename}) + "</i>");
                out.print("</div>");
                out.print("</div>");
                out.print("</div>");
            }
            out.println("<script type=\"text/javascript\">");
            out.println("if (!String.prototype.endsWith) {");
            out.println("  String.prototype.endsWith = function(suffix) {");
            out.println("    return this.indexOf(suffix, this.length - suffix.length) !== -1;");
            out.println("  };");
            out.println("}");
            out.println("if (!String.prototype.startsWith) {");
            out.println("  String.prototype.startsWith = function(searchString, position) {");
            out.println("    position = position || 0;");
            out.println("    return this.indexOf(searchString, position) === position;");
            out.println("  };");
            out.println("}");
            out.println("var selectedPipelineRowIndex = -1;");
            out.println("var selectedWorkflowRowIndex = -1;");
            out.println("var removeElement = null;");
            out.println("var selectedPipelineName = \"\";");
            out.println("var selectedWorkflowName = \"\";");
            out.println("function repositionActions( element, elementFrom ) {");
            out.println("element.style.left = ( 10 + elementFrom.getBoundingClientRect().left ) + 'px';");
            out.println("}");
            out.println("function resumeFunction( element ) {");
            out.println("if( !element.classList.contains('toolbar-button-disabled') ) {");
            out.println("if( element.id.startsWith( 'j-' ) && selectedWorkflowRowIndex != -1 ) {");
            out.println(this.setupAjaxCall(this.setupJobURI(this.convertContextPath("/hop/startWorkflow")), BaseMessages.getString(PKG, (String)"GetStatusServlet.StartWorkflow.Title", (String[])new String[0]), "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.TheWorkflow.Label", (String[])new String[0]) + " ' + selectedWorkflowName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.StartWorkflow.Success.Body", (String[])new String[0]) + "'", "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.TheWorkflow.Label", (String[])new String[0]) + " ' + selectedWorkflowName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.StartWorkflow.Failure.Body", (String[])new String[0]) + "'"));
            out.println("} else if ( !element.id.startsWith( 'j-' ) && selectedPipelineRowIndex != -1 && document.getElementById( 'cellTableCellStatus_' + selectedPipelineRowIndex ).innerHTML == 'Running') {");
            out.println(this.setupAjaxCall(this.setupPipelineURI(this.convertContextPath("/hop/pausePipeline")), BaseMessages.getString(PKG, (String)"GetStatusServlet.PausePipeline.Title", (String[])new String[0]), "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.ThePipeline.Label", (String[])new String[0]) + " ' + selectedPipelineName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.PausePipeline.Success.Body", (String[])new String[0]) + "'", "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.ThePipeline.Label", (String[])new String[0]) + " ' + selectedPipelineName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.PausePipeline.Failure.Body", (String[])new String[0]) + "'"));
            out.println("} else if( !element.id.startsWith( 'j-' ) && selectedPipelineRowIndex != -1 && document.getElementById( 'cellTableCellStatus_' + selectedPipelineRowIndex ).innerHTML == 'Paused') {");
            out.println(this.setupAjaxCall(this.setupPipelineURI(this.convertContextPath("/hop/pausePipeline")), BaseMessages.getString(PKG, (String)"GetStatusServlet.ResumePipeline.Title", (String[])new String[0]), "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.ThePipeline.Label", (String[])new String[0]) + " ' + selectedPipelineName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.ResumePipeline.Success.Body", (String[])new String[0]) + "'", "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.ThePipeline.Label", (String[])new String[0]) + " ' + selectedPipelineName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.ResumePipeline.Failure.Body", (String[])new String[0]) + "'"));
            out.println("} else if( !element.id.startsWith( 'j-' ) && selectedPipelineRowIndex != -1 ){");
            out.println("repositionActions( document.getElementById( 'runActions' ), element );");
            out.println("document.getElementById( 'runActions' ).style.visibility = 'visible';");
            out.println("}");
            out.println("}");
            out.println("}");
            out.println("function stopFunction( element ) {");
            out.println("if( !element.classList.contains('toolbar-button-disabled') ) {");
            out.println("if( element.id.startsWith( 'j-' ) && selectedWorkflowRowIndex != -1 ) {");
            out.println(this.setupAjaxCall(this.setupJobURI(this.convertContextPath("/hop/stopWorkflow")), BaseMessages.getString(PKG, (String)"GetStatusServlet.StopWorkflow.Title", (String[])new String[0]), "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.StopWorkflow.Success.Body1", (String[])new String[0]) + " " + BaseMessages.getString(PKG, (String)"GetStatusServlet.TheWorkflow.Label", (String[])new String[0]) + " ' + selectedWorkflowName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.StopWorkflow.Success.Body2", (String[])new String[0]) + "'", "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.TheWorkflow.Label", (String[])new String[0]) + " ' + selectedWorkflowName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.StopWorkflow.Failure.Body", (String[])new String[0]) + "'"));
            out.println("} else if ( !element.id.startsWith( 'j-' ) && selectedPipelineRowIndex != -1 ) {");
            out.println("repositionActions( document.getElementById( 'stopActions' ), element );");
            out.println("document.getElementById( 'stopActions' ).style.visibility = 'visible';");
            out.println("}");
            out.println("}");
            out.println("}");
            out.println("function runPipelineSelector( element ) {");
            out.println("if( element.innerHTML == 'Prepare the execution' ){");
            out.println(this.setupAjaxCall(this.setupPipelineURI(this.convertContextPath("/hop/prepareExec")), BaseMessages.getString(PKG, (String)"GetStatusServlet.PreparePipeline.Title", (String[])new String[0]), "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.ThePipeline.Label", (String[])new String[0]) + " ' + selectedPipelineName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.PreparePipeline.Success.Body", (String[])new String[0]) + "'", "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.ThePipeline.Label", (String[])new String[0]) + " ' + selectedPipelineName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.PreparePipeline.Failure.Body", (String[])new String[0]) + "'"));
            out.println("} else {");
            out.println(this.setupAjaxCall(this.setupPipelineURI(this.convertContextPath("/hop/startPipeline")), BaseMessages.getString(PKG, (String)"GetStatusServlet.StartPipeline.Title", (String[])new String[0]), "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.ThePipeline.Label", (String[])new String[0]) + " ' + selectedPipelineName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.StartPipeline.Success.Body", (String[])new String[0]) + "'", "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.ThePipeline.Label", (String[])new String[0]) + " ' + selectedPipelineName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.StartPipeline.Failure.Body", (String[])new String[0]) + "'"));
            out.println("}");
            out.println("}");
            out.println("function stopPipelineSelector( element ) {");
            out.println("if( element.innerHTML == 'Stop pipeline' ) {");
            out.println(this.setupAjaxCall(this.setupPipelineURI(this.convertContextPath("/hop/stopPipeline")), BaseMessages.getString(PKG, (String)"GetStatusServlet.StopPipeline.Title", (String[])new String[0]), "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.PipelineStop.Success.Body1", (String[])new String[0]) + " " + BaseMessages.getString(PKG, (String)"GetStatusServlet.ThePipeline.Label", (String[])new String[0]) + " ' + selectedPipelineName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.PipelineStop.Success.Body2", (String[])new String[0]) + "'", "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.ThePipeline.Label", (String[])new String[0]) + " ' + selectedPipelineName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.StopPipeline.Failure.Body", (String[])new String[0]) + "'"));
            out.println("} else if( element.innerHTML == 'Stop input processing' ) {");
            out.println(this.setupAjaxCall(this.setupPipelineURI(this.convertContextPath("/hop/stopPipeline")) + " + '&inputOnly=Y'", BaseMessages.getString(PKG, (String)"GetStatusServlet.StopInputPipeline.Title", (String[])new String[0]), "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.StopInputPipeline.Success.Body1", (String[])new String[0]) + " " + BaseMessages.getString(PKG, (String)"GetStatusServlet.ThePipeline.Label", (String[])new String[0]) + " ' + selectedPipelineName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.StopInputPipeline.Success.Body2", (String[])new String[0]) + "'", "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.ThePipeline.Label", (String[])new String[0]) + " ' + selectedPipelineName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.StopInputPipeline.Failure.Body", (String[])new String[0]) + "'"));
            out.println("}");
            out.println("document.getElementById( 'stopActions' ).style.visibility = 'hidden';");
            out.println("}");
            out.println("function viewFunction( element ) {");
            out.println("if( !element.classList.contains('toolbar-button-disabled') ) {");
            out.println("if( element.id.startsWith( 'j-' ) && selectedWorkflowRowIndex != -1 ) {");
            out.println("window.location.replace( '" + this.convertContextPath("/hop/workflowStatus") + "' + '?name=' + document.getElementById( 'j-cellTableFirstCell_' + selectedWorkflowRowIndex ).innerHTML + '&id=' + document.getElementById( 'j-cellTableCell_' + selectedWorkflowRowIndex ).innerHTML );");
            out.println("} else if ( selectedPipelineRowIndex != -1 ) {");
            out.println("window.location.replace( '" + this.convertContextPath("/hop/pipelineStatus") + "' + '?name=' + document.getElementById( 'cellTableFirstCell_' + selectedPipelineRowIndex ).innerHTML + '&id=' + document.getElementById( 'cellTableCell_' + selectedPipelineRowIndex ).innerHTML );");
            out.println("}");
            out.println("}");
            out.println("}");
            out.println("function removeFunction( element ) {");
            out.println("if( !element.classList.contains('toolbar-button-disabled') ) {");
            out.println("removeElement = element;");
            out.println("if( element.id.startsWith( 'j-' ) && selectedWorkflowRowIndex != -1 ) {");
            out.println("openMessageDialog( '" + BaseMessages.getString(PKG, (String)"GetStatusServlet.RemoveWorkflow.Title", (String[])new String[0]) + "','" + BaseMessages.getString(PKG, (String)"GetStatusServlet.RemoveWorkflow.Confirm.Body", (String[])new String[0]) + " " + BaseMessages.getString(PKG, (String)"GetStatusServlet.TheWorkflow.Label", (String[])new String[0]) + " ' + selectedWorkflowName + '?', false );");
            out.println("} else if ( selectedPipelineRowIndex != -1 ) {");
            out.println("openMessageDialog( '" + BaseMessages.getString(PKG, (String)"GetStatusServlet.RemovePipeline.Title", (String[])new String[0]) + "','" + BaseMessages.getString(PKG, (String)"GetStatusServlet.RemovePipeline.Confirm.Body", (String[])new String[0]) + " " + BaseMessages.getString(PKG, (String)"GetStatusServlet.ThePipeline.Label", (String[])new String[0]) + " ' + selectedPipelineName + '?', false );");
            out.println("}");
            out.println("}");
            out.println("}");
            out.println("function clickFunction( element, tableClass ) {");
            out.println("var prefix = element.id.startsWith( 'j-' ) ? 'j-' : '';");
            out.println("var rowNum = getRowNum( element.id );");
            out.println("if( tableClass.endsWith( 'Row' ) ) {");
            out.println("element.className='cellTableRow ' + tableClass + ' cellTableSelectedRow';");
            out.println("} else {");
            out.println("document.getElementById( prefix + 'cellTableFirstCell_' + rowNum ).className='cellTableCell cellTableFirstColumn ' + tableClass + ' cellTableSelectedRowCell';");
            out.println("element.className='cellTableCell ' + tableClass + ' cellTableSelectedRowCell';");
            out.println("}");
            out.println("if( element.id.startsWith( 'j-' ) ) {");
            out.println("document.getElementById( \"j-pause\" ).classList.remove( \"toolbar-button-disabled\" )");
            out.println("document.getElementById( \"j-stop\" ).classList.remove( \"toolbar-button-disabled\" )");
            out.println("document.getElementById( \"j-view\" ).classList.remove( \"toolbar-button-disabled\" )");
            out.println("document.getElementById( \"j-close\" ).classList.remove( \"toolbar-button-disabled\" )");
            out.println("if( selectedWorkflowRowIndex != -1 && rowNum != selectedWorkflowRowIndex ) {");
            out.println("document.getElementById( prefix + 'cellTableRow_' + selectedWorkflowRowIndex ).className='cellTableRow ' + tableClass;");
            out.println("document.getElementById( prefix + 'cellTableFirstCell_' + selectedWorkflowRowIndex ).className='cellTableCell cellTableFirstColumn ' + tableClass;");
            out.println("document.getElementById( prefix + 'cellTableCell_' + selectedWorkflowRowIndex ).className='cellTableCell ' + tableClass;");
            out.println("document.getElementById( prefix + 'cellTableLastCell_' + selectedWorkflowRowIndex ).className='cellTableCell cellTableLastColumn ' + tableClass;");
            out.println("}");
            out.println("selectedWorkflowRowIndex = rowNum;");
            out.println("} else {");
            out.println("document.getElementById( \"pause\" ).classList.remove( \"toolbar-button-disabled\" )");
            out.println("document.getElementById( \"stop\" ).classList.remove( \"toolbar-button-disabled\" )");
            out.println("document.getElementById( \"cleanup\" ).classList.remove( \"toolbar-button-disabled\" )");
            out.println("document.getElementById( \"view\" ).classList.remove( \"toolbar-button-disabled\" )");
            out.println("document.getElementById( \"close\" ).classList.remove( \"toolbar-button-disabled\" )");
            out.println("if( selectedPipelineRowIndex != -1 && rowNum != selectedPipelineRowIndex ) {");
            out.println("document.getElementById( prefix + 'cellTableRow_' + selectedPipelineRowIndex ).className='cellTableRow ' + tableClass;");
            out.println("document.getElementById( prefix + 'cellTableFirstCell_' + selectedPipelineRowIndex ).className='cellTableCell cellTableFirstColumn ' + tableClass;");
            out.println("document.getElementById( prefix + 'cellTableCell_' + selectedPipelineRowIndex ).className='cellTableCell ' + tableClass;");
            out.println("document.getElementById( prefix + 'cellTableLastCell_' + selectedPipelineRowIndex ).className='cellTableCell cellTableLastColumn ' + tableClass;");
            out.println("}");
            out.println("selectedPipelineRowIndex = rowNum;");
            out.println("if( document.getElementById( 'cellTableCellStatus_' + selectedPipelineRowIndex ).innerHTML == 'Running' ) {");
            out.println("document.getElementById( 'pause' ).innerHTML = '<img style=\"width: 22px; height: 22px\" src=\"" + (String)prefix + "/images/pause.svg\"/ title=\"Pause pipeline\">';");
            out.println("} else if( document.getElementById( 'cellTableCellStatus_' + selectedPipelineRowIndex ).innerHTML == 'Paused' ) {");
            out.println("document.getElementById( 'pause' ).innerHTML = '<img style=\"width: 22px; height: 22px\" src=\"" + (String)prefix + "/images/pause.svg\" title=\"Resume pipeline\"/>';");
            out.println("}");
            out.println("}");
            out.println("setSelectedNames();");
            out.println("}");
            out.println("function setSelectedNames() {");
            out.println("  selectedWorkflowName = selectedPipelineName = \"\";");
            out.println("  var selectedElementNames = document.getElementsByClassName( \"cellTableFirstColumn cellTableSelectedRowCell\" );");
            out.println("  if( selectedElementNames ) {");
            out.println("    for(var i = 0; i < selectedElementNames.length; i++) {");
            out.println("      if(selectedElementNames[i].id.startsWith(\"j-\")) {");
            out.println("        selectedWorkflowName = selectedElementNames[i].innerHTML;");
            out.println("      } else {");
            out.println("        selectedPipelineName = selectedElementNames[i].innerHTML;");
            out.println("      }");
            out.println("    }");
            out.println("  }");
            out.println("}");
            out.println("function mouseEnterFunction( element, tableClass ) {");
            out.println("var prefix = '';");
            out.println("var rowNum = getRowNum( element.id );");
            out.println("var selectedIndex = selectedPipelineRowIndex;");
            out.println("if( element.id.startsWith( 'j-' ) ) {");
            out.println("prefix = 'j-';");
            out.println("selectedIndex = selectedWorkflowRowIndex;");
            out.println("}");
            out.println("if( rowNum != selectedIndex ) {");
            out.println("if( tableClass.endsWith( 'Row' ) ) {");
            out.println("element.className='cellTableRow ' + tableClass + ' cellTableHoveredRow';");
            out.println("} else {");
            out.println("document.getElementById( prefix + 'cellTableFirstCell_' + element.id.charAt( element.id.length - 1 ) ).className='cellTableCell cellTableFirstColumn ' + tableClass + ' cellTableHoveredRowCell';");
            out.println("document.getElementById( prefix + 'cellTableCell_' + element.id.charAt( element.id.length - 1 ) ).className='cellTableCell ' + tableClass + ' cellTableHoveredRowCell';");
            out.println("document.getElementById( prefix + 'cellTableLastCell_' + element.id.charAt( element.id.length - 1 ) ).className='cellTableCell cellTableLastColumn ' + tableClass + ' cellTableHoveredRowCell';");
            out.println("}");
            out.println("}");
            out.println("}");
            out.println("function mouseLeaveFunction( element, tableClass ) {");
            out.println("var prefix = '';");
            out.println("var rowNum = getRowNum( element.id );");
            out.println("var selectedIndex = selectedPipelineRowIndex;");
            out.println("if( element.id.startsWith( 'j-' ) ) {");
            out.println("prefix = 'j-';");
            out.println("selectedIndex = selectedWorkflowRowIndex;");
            out.println("}");
            out.println("if( rowNum != selectedIndex ) {");
            out.println("if( tableClass.endsWith( 'Row' ) ) {");
            out.println("element.className='cellTableRow ' + tableClass;");
            out.println("} else {");
            out.println("document.getElementById( prefix + 'cellTableFirstCell_' + element.id.charAt( element.id.length - 1 ) ).className='cellTableCell cellTableFirstColumn ' + tableClass;");
            out.println("document.getElementById( prefix + 'cellTableCell_' + element.id.charAt( element.id.length - 1 ) ).className='cellTableCell ' + tableClass;");
            out.println("document.getElementById( prefix + 'cellTableLastCell_' + element.id.charAt( element.id.length - 1 ) ).className='cellTableCell cellTableLastColumn ' + tableClass;");
            out.println("}");
            out.println("}");
            out.println("}");
            out.println("function closeMessageDialog( refresh ) {");
            out.println("  document.getElementById( \"messageDialogBackdrop\" ).style.visibility = 'hidden';");
            out.println("  document.getElementById( \"messageDialog\" ).style.visibility = 'hidden';");
            out.println("  if( refresh ) {");
            out.println("    window.location.reload();");
            out.println("  }");
            out.println("}");
            out.println("function openMessageDialog( title, body, single ) {");
            out.println("  document.getElementById( \"messageDialogBackdrop\" ).style.visibility = 'visible';");
            out.println("  document.getElementById( \"messageDialog\" ).style.visibility = 'visible';");
            out.println("  document.getElementById( \"messageDialogTitle\" ).innerHTML = title;");
            out.println("  document.getElementById( \"messageDialogBody\" ).innerHTML = body;");
            out.println("  if( single ) {");
            out.println("    document.getElementById( \"singleButton\" ).style.display = 'block';");
            out.println("    document.getElementById( \"doubleButton\" ).style.display = 'none';");
            out.println("  } else {");
            out.println("    document.getElementById( \"singleButton\" ).style.display = 'none';");
            out.println("    document.getElementById( \"doubleButton\" ).style.display = 'block';");
            out.println("  }");
            out.println("}");
            out.println("function removeSelection() {");
            out.println("  if( removeElement !== null ) {");
            out.println("    if( removeElement.id.startsWith( 'j-' ) && selectedWorkflowRowIndex != -1 ) {");
            out.println(this.setupAjaxCall(this.setupJobURI(this.convertContextPath("/hop/removeWorkflow")), BaseMessages.getString(PKG, (String)"GetStatusServlet.RemoveWorkflow.Title", (String[])new String[0]), "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.TheWorkflow.Label", (String[])new String[0]) + " ' + selectedWorkflowName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.RemoveWorkflow.Success.Body", (String[])new String[0]) + "'", "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.TheWorkflow.Label", (String[])new String[0]) + " ' + selectedWorkflowName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.RemoveWorkflow.Failure.Body", (String[])new String[0]) + "'"));
            out.println("} else if ( selectedPipelineRowIndex != -1 ) {");
            out.println(this.setupAjaxCall(this.setupPipelineURI(this.convertContextPath("/hop/removePipeline")), BaseMessages.getString(PKG, (String)"GetStatusServlet.RemovePipeline.Title", (String[])new String[0]), "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.ThePipeline.Label", (String[])new String[0]) + " ' + selectedPipelineName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.RemovePipeline.Success.Body", (String[])new String[0]) + "'", "'" + BaseMessages.getString(PKG, (String)"GetStatusServlet.ThePipeline.Label", (String[])new String[0]) + " ' + selectedPipelineName + ' " + BaseMessages.getString(PKG, (String)"GetStatusServlet.RemovePipeline.Failure.Body", (String[])new String[0]) + "'"));
            out.println("    }");
            out.println("  }");
            out.println("}");
            out.println("function getRowNum( id ) {");
            out.println("  return id.substring( id.indexOf('_') + 1, id.length);");
            out.println("}");
            out.println("</script>");
            out.println("</BODY>");
            out.println("</HTML>");
        }
    }

    private static void getSystemInfo(HopServerStatus serverStatus) {
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        int cores = Runtime.getRuntime().availableProcessors();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long totalMemory = Runtime.getRuntime().totalMemory();
        String osArch = operatingSystemMXBean.getArch();
        String osName = operatingSystemMXBean.getName();
        String osVersion = operatingSystemMXBean.getVersion();
        double loadAvg = operatingSystemMXBean.getSystemLoadAverage();
        int threadCount = threadMXBean.getThreadCount();
        long allThreadsCpuTime = 0L;
        long[] threadIds = threadMXBean.getAllThreadIds();
        for (int i = 0; i < threadIds.length; ++i) {
            allThreadsCpuTime += threadMXBean.getThreadCpuTime(threadIds[i]);
        }
        long uptime = runtimeMXBean.getUptime();
        serverStatus.setCpuCores(cores);
        serverStatus.setCpuProcessTime(allThreadsCpuTime);
        serverStatus.setUptime(uptime);
        serverStatus.setThreadCount(threadCount);
        serverStatus.setLoadAvg(loadAvg);
        serverStatus.setOsName(osName);
        serverStatus.setOsVersion(osVersion);
        serverStatus.setOsArchitecture(osArch);
        serverStatus.setMemoryFree(freeMemory);
        serverStatus.setMemoryTotal(totalMemory);
    }

    public String toString() {
        return "Status IHandler";
    }

    @Override
    public String getService() {
        return "/hop/status (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }

    private String setupIconEnterLeaveJavascript(String id) {
        return "onMouseEnter=\"if( !document.getElementById('" + id + "').classList.contains('toolbar-button-disabled') ) { document.getElementById('" + id + "').classList.add('toolbar-button-hovering') }\" onMouseLeave=\"document.getElementById('" + id + "').classList.remove('toolbar-button-hovering')\"";
    }

    private String messageDialog() {
        Object retVal = "<div id=\"messageDialogBackdrop\" style=\"visibility: hidden; position: absolute; top: 0; right: 0; bottom: 0; left: 0; opacity: 0.5; background-color: #000; z-index: 1000;\"></div>\n";
        retVal = (String)retVal + "<div class=\"hop-dialog\" id=\"messageDialog\" style=\"visibility: hidden; margin: 0; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); -ms-transform: translate(-50%, -50%);-webkit-transform: translate(-50%, -50%); padding: 30px; height: auto; width: 423px; border: 1px solid #CCC; -webkit-box-shadow: none; -moz-box-shadow: none;box-shadow: none; -webkit-box-sizing: border-box; -moz-box-sizing: border-box; box-sizing: border-box; overflow: hidden; line-height: 20px; background-color: #FFF; z-index: 10000;\">\n";
        retVal = (String)retVal + "<div id=\"messageDialogTitle\" class=\"Caption\"></div>\n";
        retVal = (String)retVal + "<div id=\"messageDialogBody\" class=\"dialog-content\"></div>\n";
        retVal = (String)retVal + "<div id=\"singleButton\" style=\"margin-top: 30px;\">\n<button class=\"hop-button\" style=\"float: right;\" onclick=\"closeMessageDialog( true );\">\n<span>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Button.OK", (String[])new String[0]) + "</span>\n</button>\n</div>\n";
        retVal = (String)retVal + "<div id=\"doubleButton\" style=\"margin-top: 30px;\">\n<button class=\"hop-button\" style=\"float: right; margin-left: 10px;\" onclick=\"closeMessageDialog( false );\">\n<span>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Button.No", (String[])new String[0]) + "</span>\n</button>\n<button class=\"hop-button\" style=\"float: right;\" onclick=\"closeMessageDialog( false ); removeSelection();\">\n<span>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Button.YesRemove", (String[])new String[0]) + "</span>\n</button>\n</div>\n";
        retVal = (String)retVal + "</div>\n";
        return retVal;
    }

    private String setupAjaxCall(String uri, String title, String success, String failure) {
        Object retVal = "";
        retVal = (String)retVal + "var xhttp = new XMLHttpRequest();\n";
        retVal = (String)retVal + "xhttp.onreadystatechange = function() {\n";
        retVal = (String)retVal + " if ( this.readyState === 4 ) {\n";
        retVal = (String)retVal + "   if ( this.status === 200 ) {\n";
        retVal = (String)retVal + "     openMessageDialog( '" + title + "', " + success + ", true );\n";
        retVal = (String)retVal + "   } else {\n";
        retVal = (String)retVal + "     openMessageDialog( '" + BaseMessages.getString(PKG, (String)"GetStatusServlet.UnableTo.Label", (String[])new String[0]) + " " + title + "', " + failure + ", true );\n";
        retVal = (String)retVal + "   }\n";
        retVal = (String)retVal + " }\n";
        retVal = (String)retVal + "};\n";
        retVal = (String)retVal + "xhttp.open( \"GET\", " + uri + ", true );\n";
        retVal = (String)retVal + "xhttp.send();\n";
        return retVal;
    }

    private String setupPipelineURI(String context) {
        return "'" + context + "' + '?name=' + document.getElementById( 'cellTableFirstCell_' + selectedPipelineRowIndex ).innerHTML + '&id=' + document.getElementById( 'cellTableCell_' + selectedPipelineRowIndex ).innerHTML";
    }

    private String setupJobURI(String context) {
        return "'" + context + "' + '?name=' + document.getElementById( 'j-cellTableFirstCell_' + selectedWorkflowRowIndex ).innerHTML + '&id=' + document.getElementById( 'j-cellTableCell_' + selectedWorkflowRowIndex ).innerHTML";
    }
}

