/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.triggers;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.beam.repackaged.direct_java.runners.core.StateMerging;
import org.apache.beam.repackaged.direct_java.runners.core.StateTag;
import org.apache.beam.repackaged.direct_java.runners.core.StateTags;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.state.CombiningState;
import org.apache.beam.sdk.state.GroupingState;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.Min;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormat;
import org.joda.time.format.PeriodFormatter;

public abstract class AfterDelayFromFirstElementStateMachine
extends TriggerStateMachine {
    protected static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Instant, @UnknownKeyFor @NonNull @Initialized Instant>> IDENTITY = ImmutableList.of();
    protected static final @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized CombiningState<@UnknownKeyFor @NonNull @Initialized Instant, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.Holder<@UnknownKeyFor @NonNull @Initialized Instant>, @UnknownKeyFor @NonNull @Initialized Instant>> DELAYED_UNTIL_TAG = StateTags.makeSystemTagInternal(StateTags.combiningValueFromInputInternal("delayed", InstantCoder.of(), Min.naturalOrder()));
    private static final @UnknownKeyFor @NonNull @Initialized PeriodFormatter PERIOD_FORMATTER = PeriodFormat.wordBased((Locale)Locale.ENGLISH);
    protected final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Instant, @UnknownKeyFor @NonNull @Initialized Instant>> timestampMappers;
    protected final @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain;

    public abstract @Nullable @UnknownKeyFor @Initialized Instant getCurrentTime(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.TriggerContext var1);

    protected abstract @UnknownKeyFor @NonNull @Initialized AfterDelayFromFirstElementStateMachine newWith(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Instant, @UnknownKeyFor @NonNull @Initialized Instant>> var1);

    public AfterDelayFromFirstElementStateMachine(@UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Instant, @UnknownKeyFor @NonNull @Initialized Instant>> timestampMappers) {
        super(null);
        this.timestampMappers = timestampMappers;
        this.timeDomain = timeDomain;
    }

    private @UnknownKeyFor @NonNull @Initialized Instant getTargetTimestamp(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.OnElementContext c) {
        return this.computeTargetTimestamp(c.currentProcessingTime());
    }

    public @UnknownKeyFor @NonNull @Initialized TimeDomain getTimeDomain() {
        return this.timeDomain;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Instant, @UnknownKeyFor @NonNull @Initialized Instant>> getTimestampMappers() {
        return this.timestampMappers;
    }

    public @UnknownKeyFor @NonNull @Initialized AfterDelayFromFirstElementStateMachine alignedTo(@UnknownKeyFor @NonNull @Initialized Duration size, @UnknownKeyFor @NonNull @Initialized Instant offset) {
        return this.newWith(new AlignFn(size, offset));
    }

    public @UnknownKeyFor @NonNull @Initialized AfterDelayFromFirstElementStateMachine alignedTo(@UnknownKeyFor @NonNull @Initialized Duration size) {
        return this.alignedTo(size, new Instant(0L));
    }

    public @UnknownKeyFor @NonNull @Initialized AfterDelayFromFirstElementStateMachine plusDelayOf(@UnknownKeyFor @NonNull @Initialized Duration delay) {
        return this.newWith(new DelayFn(delay));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isCompatible(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        AfterDelayFromFirstElementStateMachine that = (AfterDelayFromFirstElementStateMachine)other;
        return this.timestampMappers.equals(that.timestampMappers);
    }

    private @UnknownKeyFor @NonNull @Initialized AfterDelayFromFirstElementStateMachine newWith(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Instant, @UnknownKeyFor @NonNull @Initialized Instant> timestampMapper) {
        return this.newWith((List<SerializableFunction<Instant, Instant>>)ImmutableList.builder().addAll(this.timestampMappers).add(timestampMapper).build());
    }

    @Override
    public void prefetchOnElement(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.PrefetchContext c) {
        c.state().access(DELAYED_UNTIL_TAG).readLater();
    }

    @Override
    public void onElement(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.OnElementContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        GroupingState delayUntilState = (GroupingState)c.state().access(DELAYED_UNTIL_TAG);
        Instant oldDelayUntil = (Instant)delayUntilState.read();
        if (oldDelayUntil != null) {
            return;
        }
        Instant targetTimestamp = this.getTargetTimestamp(c);
        delayUntilState.add((Object)targetTimestamp);
        c.setTimer(targetTimestamp, this.timeDomain);
    }

    @Override
    public void prefetchOnMerge(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.MergingPrefetchContext c) {
        StateMerging.prefetchCombiningValues(c.state(), DELAYED_UNTIL_TAG);
    }

    @Override
    public void onMerge(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.OnMergeContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (c.trigger().isFinished()) {
            StateMerging.clear(c.state(), DELAYED_UNTIL_TAG);
            return;
        }
        StateMerging.mergeCombiningValues(c.state(), DELAYED_UNTIL_TAG);
        Instant earliestTargetTime = (Instant)c.state().access(DELAYED_UNTIL_TAG).read();
        if (earliestTargetTime != null) {
            c.setTimer(earliestTargetTime, this.timeDomain);
        }
    }

    @Override
    public void prefetchShouldFire(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.PrefetchContext c) {
        c.state().access(DELAYED_UNTIL_TAG).readLater();
    }

    @Override
    public void clear(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.TriggerContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        c.state().access(DELAYED_UNTIL_TAG).clear();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean shouldFire(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.TriggerContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Instant delayedUntil = (Instant)context.state().access(DELAYED_UNTIL_TAG).read();
        return delayedUntil != null && this.getCurrentTime(context) != null && this.getCurrentTime(context).isAfter((ReadableInstant)delayedUntil);
    }

    @Override
    public final void onFire(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.TriggerContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.clear(context);
        context.trigger().setFinished(true);
    }

    protected @UnknownKeyFor @NonNull @Initialized Instant computeTargetTimestamp(@UnknownKeyFor @NonNull @Initialized Instant time) {
        Instant result = time;
        for (SerializableFunction<Instant, Instant> timestampMapper : this.timestampMappers) {
            result = (Instant)timestampMapper.apply((Object)result);
        }
        return result;
    }

    static final class AlignFn
    implements SerializableFunction<Instant, Instant> {
        private final @UnknownKeyFor @NonNull @Initialized Duration size;
        private final @UnknownKeyFor @NonNull @Initialized Instant offset;

        public AlignFn(@UnknownKeyFor @NonNull @Initialized Duration size, @UnknownKeyFor @NonNull @Initialized Instant offset) {
            this.size = size;
            this.offset = offset;
        }

        public @UnknownKeyFor @NonNull @Initialized Instant apply(@UnknownKeyFor @NonNull @Initialized Instant point) {
            long millisSinceStart = new Duration((ReadableInstant)this.offset, (ReadableInstant)point).getMillis() % this.size.getMillis();
            return millisSinceStart == 0L ? point : point.plus((ReadableDuration)this.size).minus((ReadableDuration)Duration.millis((long)millisSinceStart));
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof AlignFn)) {
                return false;
            }
            AlignFn other = (AlignFn)object;
            return other.size.equals((Object)this.size) && other.offset.equals((Object)this.offset);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.size, this.offset);
        }
    }

    static final class DelayFn
    implements SerializableFunction<Instant, Instant> {
        private final @UnknownKeyFor @NonNull @Initialized Duration delay;

        public DelayFn(@UnknownKeyFor @NonNull @Initialized Duration delay) {
            this.delay = delay;
        }

        public @UnknownKeyFor @NonNull @Initialized Instant apply(@UnknownKeyFor @NonNull @Initialized Instant input) {
            return input.plus((ReadableDuration)this.delay);
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof DelayFn)) {
                return false;
            }
            return this.delay.equals((Object)((DelayFn)object).delay);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.delay);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return PERIOD_FORMATTER.print((ReadablePeriod)this.delay.toPeriod());
        }
    }
}

