/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.dynamodb;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import org.apache.beam.sdk.io.aws.dynamodb.AwsClientsProvider;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BasicDynamoDBProvider
implements AwsClientsProvider {
    private final @UnknownKeyFor @NonNull @Initialized String accessKey;
    private final @UnknownKeyFor @NonNull @Initialized String secretKey;
    private final @UnknownKeyFor @NonNull @Initialized Regions region;
    private final @Nullable @UnknownKeyFor @Initialized String serviceEndpoint;

    BasicDynamoDBProvider(@UnknownKeyFor @NonNull @Initialized String accessKey, @UnknownKeyFor @NonNull @Initialized String secretKey, @UnknownKeyFor @NonNull @Initialized Regions region, @Nullable @UnknownKeyFor @Initialized String serviceEndpoint) {
        Preconditions.checkArgument((accessKey != null ? 1 : 0) != 0, (Object)"accessKey can not be null");
        Preconditions.checkArgument((secretKey != null ? 1 : 0) != 0, (Object)"secretKey can not be null");
        Preconditions.checkArgument((region != null ? 1 : 0) != 0, (Object)"region can not be null");
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.region = region;
        this.serviceEndpoint = serviceEndpoint;
    }

    private @UnknownKeyFor @NonNull @Initialized AWSCredentialsProvider getCredentialsProvider() {
        return new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.accessKey, this.secretKey));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized AmazonDynamoDB createDynamoDB() {
        AmazonDynamoDBClientBuilder clientBuilder = (AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withCredentials(this.getCredentialsProvider());
        if (this.serviceEndpoint == null) {
            clientBuilder.withRegion(this.region);
        } else {
            clientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.serviceEndpoint, this.region.getName()));
        }
        return (AmazonDynamoDB)clientBuilder.build();
    }
}

