/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.s3;

import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.SSECustomerKey;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.aws.s3.S3FileSystemConfiguration;

final class AutoValue_S3FileSystemConfiguration
extends S3FileSystemConfiguration {
    private final String scheme;
    private final String s3StorageClass;
    private final int s3UploadBufferSizeBytes;
    private final int s3ThreadPoolSize;
    private final String SSEAlgorithm;
    private final SSECustomerKey SSECustomerKey;
    private final SSEAwsKeyManagementParams SSEAwsKeyManagementParams;
    private final boolean bucketKeyEnabled;
    private final AmazonS3ClientBuilder s3ClientBuilder;

    private AutoValue_S3FileSystemConfiguration(String scheme, String s3StorageClass, int s3UploadBufferSizeBytes, int s3ThreadPoolSize, @Nullable String SSEAlgorithm, @Nullable SSECustomerKey SSECustomerKey2, @Nullable SSEAwsKeyManagementParams SSEAwsKeyManagementParams2, boolean bucketKeyEnabled, AmazonS3ClientBuilder s3ClientBuilder) {
        this.scheme = scheme;
        this.s3StorageClass = s3StorageClass;
        this.s3UploadBufferSizeBytes = s3UploadBufferSizeBytes;
        this.s3ThreadPoolSize = s3ThreadPoolSize;
        this.SSEAlgorithm = SSEAlgorithm;
        this.SSECustomerKey = SSECustomerKey2;
        this.SSEAwsKeyManagementParams = SSEAwsKeyManagementParams2;
        this.bucketKeyEnabled = bucketKeyEnabled;
        this.s3ClientBuilder = s3ClientBuilder;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public String getS3StorageClass() {
        return this.s3StorageClass;
    }

    @Override
    public int getS3UploadBufferSizeBytes() {
        return this.s3UploadBufferSizeBytes;
    }

    @Override
    public int getS3ThreadPoolSize() {
        return this.s3ThreadPoolSize;
    }

    @Override
    @Nullable
    public String getSSEAlgorithm() {
        return this.SSEAlgorithm;
    }

    @Override
    @Nullable
    public SSECustomerKey getSSECustomerKey() {
        return this.SSECustomerKey;
    }

    @Override
    @Nullable
    public SSEAwsKeyManagementParams getSSEAwsKeyManagementParams() {
        return this.SSEAwsKeyManagementParams;
    }

    @Override
    public boolean getBucketKeyEnabled() {
        return this.bucketKeyEnabled;
    }

    @Override
    public AmazonS3ClientBuilder getS3ClientBuilder() {
        return this.s3ClientBuilder;
    }

    public String toString() {
        return "S3FileSystemConfiguration{scheme=" + this.scheme + ", s3StorageClass=" + this.s3StorageClass + ", s3UploadBufferSizeBytes=" + this.s3UploadBufferSizeBytes + ", s3ThreadPoolSize=" + this.s3ThreadPoolSize + ", SSEAlgorithm=" + this.SSEAlgorithm + ", SSECustomerKey=" + this.SSECustomerKey + ", SSEAwsKeyManagementParams=" + this.SSEAwsKeyManagementParams + ", bucketKeyEnabled=" + this.bucketKeyEnabled + ", s3ClientBuilder=" + this.s3ClientBuilder + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof S3FileSystemConfiguration) {
            S3FileSystemConfiguration that = (S3FileSystemConfiguration)o;
            return this.scheme.equals(that.getScheme()) && this.s3StorageClass.equals(that.getS3StorageClass()) && this.s3UploadBufferSizeBytes == that.getS3UploadBufferSizeBytes() && this.s3ThreadPoolSize == that.getS3ThreadPoolSize() && (this.SSEAlgorithm == null ? that.getSSEAlgorithm() == null : this.SSEAlgorithm.equals(that.getSSEAlgorithm())) && (this.SSECustomerKey == null ? that.getSSECustomerKey() == null : this.SSECustomerKey.equals(that.getSSECustomerKey())) && (this.SSEAwsKeyManagementParams == null ? that.getSSEAwsKeyManagementParams() == null : this.SSEAwsKeyManagementParams.equals(that.getSSEAwsKeyManagementParams())) && this.bucketKeyEnabled == that.getBucketKeyEnabled() && this.s3ClientBuilder.equals(that.getS3ClientBuilder());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.scheme.hashCode();
        h$ *= 1000003;
        h$ ^= this.s3StorageClass.hashCode();
        h$ *= 1000003;
        h$ ^= this.s3UploadBufferSizeBytes;
        h$ *= 1000003;
        h$ ^= this.s3ThreadPoolSize;
        h$ *= 1000003;
        h$ ^= this.SSEAlgorithm == null ? 0 : this.SSEAlgorithm.hashCode();
        h$ *= 1000003;
        h$ ^= this.SSECustomerKey == null ? 0 : this.SSECustomerKey.hashCode();
        h$ *= 1000003;
        h$ ^= this.SSEAwsKeyManagementParams == null ? 0 : this.SSEAwsKeyManagementParams.hashCode();
        h$ *= 1000003;
        h$ ^= this.bucketKeyEnabled ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.s3ClientBuilder.hashCode();
    }

    @Override
    public S3FileSystemConfiguration.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends S3FileSystemConfiguration.Builder {
        private String scheme;
        private String s3StorageClass;
        private Integer s3UploadBufferSizeBytes;
        private Integer s3ThreadPoolSize;
        private String SSEAlgorithm;
        private SSECustomerKey SSECustomerKey;
        private SSEAwsKeyManagementParams SSEAwsKeyManagementParams;
        private Boolean bucketKeyEnabled;
        private AmazonS3ClientBuilder s3ClientBuilder;

        Builder() {
        }

        private Builder(S3FileSystemConfiguration source) {
            this.scheme = source.getScheme();
            this.s3StorageClass = source.getS3StorageClass();
            this.s3UploadBufferSizeBytes = source.getS3UploadBufferSizeBytes();
            this.s3ThreadPoolSize = source.getS3ThreadPoolSize();
            this.SSEAlgorithm = source.getSSEAlgorithm();
            this.SSECustomerKey = source.getSSECustomerKey();
            this.SSEAwsKeyManagementParams = source.getSSEAwsKeyManagementParams();
            this.bucketKeyEnabled = source.getBucketKeyEnabled();
            this.s3ClientBuilder = source.getS3ClientBuilder();
        }

        @Override
        public S3FileSystemConfiguration.Builder setScheme(String scheme) {
            if (scheme == null) {
                throw new NullPointerException("Null scheme");
            }
            this.scheme = scheme;
            return this;
        }

        @Override
        public S3FileSystemConfiguration.Builder setS3StorageClass(String s3StorageClass) {
            if (s3StorageClass == null) {
                throw new NullPointerException("Null s3StorageClass");
            }
            this.s3StorageClass = s3StorageClass;
            return this;
        }

        @Override
        public S3FileSystemConfiguration.Builder setS3UploadBufferSizeBytes(int s3UploadBufferSizeBytes) {
            this.s3UploadBufferSizeBytes = s3UploadBufferSizeBytes;
            return this;
        }

        @Override
        public S3FileSystemConfiguration.Builder setS3ThreadPoolSize(int s3ThreadPoolSize) {
            this.s3ThreadPoolSize = s3ThreadPoolSize;
            return this;
        }

        @Override
        public S3FileSystemConfiguration.Builder setSSEAlgorithm(@Nullable String SSEAlgorithm) {
            this.SSEAlgorithm = SSEAlgorithm;
            return this;
        }

        @Override
        public S3FileSystemConfiguration.Builder setSSECustomerKey(@Nullable SSECustomerKey SSECustomerKey2) {
            this.SSECustomerKey = SSECustomerKey2;
            return this;
        }

        @Override
        public S3FileSystemConfiguration.Builder setSSEAwsKeyManagementParams(@Nullable SSEAwsKeyManagementParams SSEAwsKeyManagementParams2) {
            this.SSEAwsKeyManagementParams = SSEAwsKeyManagementParams2;
            return this;
        }

        @Override
        public S3FileSystemConfiguration.Builder setBucketKeyEnabled(boolean bucketKeyEnabled) {
            this.bucketKeyEnabled = bucketKeyEnabled;
            return this;
        }

        @Override
        public S3FileSystemConfiguration.Builder setS3ClientBuilder(AmazonS3ClientBuilder s3ClientBuilder) {
            if (s3ClientBuilder == null) {
                throw new NullPointerException("Null s3ClientBuilder");
            }
            this.s3ClientBuilder = s3ClientBuilder;
            return this;
        }

        @Override
        public S3FileSystemConfiguration build() {
            if (this.scheme == null || this.s3StorageClass == null || this.s3UploadBufferSizeBytes == null || this.s3ThreadPoolSize == null || this.bucketKeyEnabled == null || this.s3ClientBuilder == null) {
                StringBuilder missing = new StringBuilder();
                if (this.scheme == null) {
                    missing.append(" scheme");
                }
                if (this.s3StorageClass == null) {
                    missing.append(" s3StorageClass");
                }
                if (this.s3UploadBufferSizeBytes == null) {
                    missing.append(" s3UploadBufferSizeBytes");
                }
                if (this.s3ThreadPoolSize == null) {
                    missing.append(" s3ThreadPoolSize");
                }
                if (this.bucketKeyEnabled == null) {
                    missing.append(" bucketKeyEnabled");
                }
                if (this.s3ClientBuilder == null) {
                    missing.append(" s3ClientBuilder");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_S3FileSystemConfiguration(this.scheme, this.s3StorageClass, this.s3UploadBufferSizeBytes, this.s3ThreadPoolSize, this.SSEAlgorithm, this.SSECustomerKey, this.SSEAwsKeyManagementParams, this.bucketKeyEnabled, this.s3ClientBuilder);
        }
    }
}

