/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.values.ShardedKey;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@VisibleForTesting
public class ShardedKeyCoder<@UnknownKeyFor KeyT>
extends StructuredCoder<ShardedKey<KeyT>> {
    private final @UnknownKeyFor @NonNull @Initialized Coder<KeyT> keyCoder;
    private final @UnknownKeyFor @NonNull @Initialized VarIntCoder shardNumberCoder;

    public static <KeyT> @UnknownKeyFor @NonNull @Initialized ShardedKeyCoder<KeyT> of(@UnknownKeyFor @NonNull @Initialized Coder<KeyT> keyCoder) {
        return new ShardedKeyCoder<KeyT>(keyCoder);
    }

    protected ShardedKeyCoder(@UnknownKeyFor @NonNull @Initialized Coder<KeyT> keyCoder) {
        this.keyCoder = keyCoder;
        this.shardNumberCoder = VarIntCoder.of();
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
        return Arrays.asList(this.keyCoder);
    }

    @Override
    public void encode(@UnknownKeyFor @NonNull @Initialized ShardedKey<KeyT> key, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.keyCoder.encode(key.getKey(), outStream);
        this.shardNumberCoder.encode(key.getShardNumber(), outStream);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ShardedKey<KeyT> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return ShardedKey.of(this.keyCoder.decode(inStream), this.shardNumberCoder.decode(inStream));
    }

    @Override
    public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        this.keyCoder.verifyDeterministic();
    }
}

