/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Objects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class DefaultFilenamePolicy
extends FileBasedSink.FilenamePolicy {
    public static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_UNWINDOWED_SHARD_TEMPLATE = "-SSSSS-of-NNNNN";
    public static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_WINDOWED_SHARD_TEMPLATE = "W-P-SSSSS-of-NNNNN";
    private static final @UnknownKeyFor @NonNull @Initialized Pattern SHARD_FORMAT_RE = Pattern.compile("(S+|N+|W|P)");
    private final @UnknownKeyFor @NonNull @Initialized Params params;

    @VisibleForTesting
    DefaultFilenamePolicy(@UnknownKeyFor @NonNull @Initialized Params params) {
        this.params = params;
    }

    public static @UnknownKeyFor @NonNull @Initialized DefaultFilenamePolicy fromStandardParameters(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> baseFilename, @Nullable @UnknownKeyFor @Initialized String shardTemplate, @Nullable @UnknownKeyFor @Initialized String filenameSuffix, @UnknownKeyFor @NonNull @Initialized boolean windowedWrites) {
        Params params = new Params().withBaseFilename(baseFilename);
        if (shardTemplate != null) {
            params = params.withShardTemplate(shardTemplate);
        }
        if (filenameSuffix != null) {
            params = params.withSuffix(filenameSuffix);
        }
        if (windowedWrites) {
            params = params.withWindowedWrites();
        }
        return DefaultFilenamePolicy.fromParams(params);
    }

    public static @UnknownKeyFor @NonNull @Initialized DefaultFilenamePolicy fromParams(@UnknownKeyFor @NonNull @Initialized Params params) {
        return new DefaultFilenamePolicy(params);
    }

    public static @UnknownKeyFor @NonNull @Initialized ResourceId constructName(@UnknownKeyFor @NonNull @Initialized ResourceId baseFilename, @UnknownKeyFor @NonNull @Initialized String shardTemplate, @UnknownKeyFor @NonNull @Initialized String suffix, @UnknownKeyFor @NonNull @Initialized int shardNum, @UnknownKeyFor @NonNull @Initialized int numShards, @Nullable @UnknownKeyFor @Initialized String paneStr, @Nullable @UnknownKeyFor @Initialized String windowStr) {
        String prefix = DefaultFilenamePolicy.extractFilename(baseFilename);
        StringBuffer sb = new StringBuffer();
        sb.append(prefix);
        Matcher m = SHARD_FORMAT_RE.matcher(shardTemplate);
        while (m.find()) {
            String formatted;
            boolean isCurrentShardNum = m.group(1).charAt(0) == 'S';
            boolean isNumberOfShards = m.group(1).charAt(0) == 'N';
            boolean isPane = m.group(1).charAt(0) == 'P' && paneStr != null;
            boolean isWindow = m.group(1).charAt(0) == 'W' && windowStr != null;
            char[] zeros = new char[m.end() - m.start()];
            Arrays.fill(zeros, '0');
            DecimalFormat df = new DecimalFormat(String.valueOf(zeros));
            if (isCurrentShardNum) {
                formatted = df.format(shardNum);
                m.appendReplacement(sb, formatted);
                continue;
            }
            if (isNumberOfShards) {
                formatted = df.format(numShards);
                m.appendReplacement(sb, formatted);
                continue;
            }
            if (isPane) {
                m.appendReplacement(sb, paneStr);
                continue;
            }
            if (!isWindow) continue;
            m.appendReplacement(sb, windowStr);
        }
        m.appendTail(sb);
        sb.append(suffix);
        return baseFilename.getCurrentDirectory().resolve(sb.toString(), ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized ResourceId unwindowedFilename(@UnknownKeyFor @NonNull @Initialized int shardNumber, @UnknownKeyFor @NonNull @Initialized int numShards, @UnknownKeyFor @NonNull @Initialized FileBasedSink.OutputFileHints outputFileHints) {
        return DefaultFilenamePolicy.constructName((ResourceId)this.params.baseFilename.get(), this.params.shardTemplate, this.params.suffix + outputFileHints.getSuggestedFilenameSuffix(), shardNumber, numShards, null, null);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ResourceId windowedFilename(@UnknownKeyFor @NonNull @Initialized int shardNumber, @UnknownKeyFor @NonNull @Initialized int numShards, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo, @UnknownKeyFor @NonNull @Initialized FileBasedSink.OutputFileHints outputFileHints) {
        String paneStr = this.paneInfoToString(paneInfo);
        String windowStr = this.windowToString(window);
        return DefaultFilenamePolicy.constructName((ResourceId)this.params.baseFilename.get(), this.params.shardTemplate, this.params.suffix + outputFileHints.getSuggestedFilenameSuffix(), shardNumber, numShards, paneStr, windowStr);
    }

    private @UnknownKeyFor @NonNull @Initialized String windowToString(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
        if (window instanceof GlobalWindow) {
            return "GlobalWindow";
        }
        if (window instanceof IntervalWindow) {
            IntervalWindow iw = (IntervalWindow)window;
            return String.format("%s-%s", iw.start().toString(), iw.end().toString());
        }
        return window.toString();
    }

    private @UnknownKeyFor @NonNull @Initialized String paneInfoToString(@UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo) {
        String paneString = String.format("pane-%d", paneInfo.getIndex());
        if (paneInfo.getTiming() == PaneInfo.Timing.LATE) {
            paneString = String.format("%s-late", paneString);
        }
        if (paneInfo.isLast()) {
            paneString = String.format("%s-last", paneString);
        }
        return paneString;
    }

    @Override
    public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        String displayBaseFilename = this.params.baseFilename.isAccessible() ? ((ResourceId)this.params.baseFilename.get()).toString() : "(" + this.params.baseFilename + ")";
        builder.add(DisplayData.item("filenamePattern", String.format("%s%s%s", displayBaseFilename, this.params.shardTemplate, this.params.suffix)).withLabel("Filename pattern"));
        builder.add(DisplayData.item("filePrefix", this.params.baseFilename).withLabel("Output File Prefix"));
        builder.add(DisplayData.item("shardNameTemplate", this.params.shardTemplate).withLabel("Output Shard Name Template"));
        builder.add(DisplayData.item("fileSuffix", this.params.suffix).withLabel("Output file Suffix"));
    }

    private static @UnknownKeyFor @NonNull @Initialized String extractFilename(@UnknownKeyFor @NonNull @Initialized ResourceId input) {
        if (input.isDirectory()) {
            return "";
        }
        return (String)MoreObjects.firstNonNull((Object)input.getFilename(), (Object)"");
    }

    public static class ParamsCoder
    extends AtomicCoder<Params> {
        private static final @UnknownKeyFor @NonNull @Initialized ParamsCoder INSTANCE = new ParamsCoder();
        private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized String> STRING_CODER = StringUtf8Coder.of();

        public static @UnknownKeyFor @NonNull @Initialized ParamsCoder of() {
            return INSTANCE;
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized Params value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (value == null) {
                throw new CoderException("cannot encode a null value");
            }
            STRING_CODER.encode(((ResourceId)value.baseFilename.get()).toString(), outStream);
            STRING_CODER.encode(value.shardTemplate, outStream);
            STRING_CODER.encode(value.suffix, outStream);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Params decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            ResourceId prefix = FileBasedSink.convertToFileResourceIfPossible(STRING_CODER.decode(inStream));
            String shardTemplate = STRING_CODER.decode(inStream);
            String suffix = STRING_CODER.decode(inStream);
            return new Params().withBaseFilename(prefix).withShardTemplate(shardTemplate).withSuffix(suffix);
        }
    }

    public static class Params
    implements Serializable {
        private final @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> baseFilename;
        private final @UnknownKeyFor @NonNull @Initialized String shardTemplate;
        private final @UnknownKeyFor @NonNull @Initialized boolean explicitTemplate;
        private final @UnknownKeyFor @NonNull @Initialized String suffix;

        public Params() {
            this.baseFilename = null;
            this.shardTemplate = DefaultFilenamePolicy.DEFAULT_UNWINDOWED_SHARD_TEMPLATE;
            this.suffix = "";
            this.explicitTemplate = false;
        }

        private Params(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> baseFilename, @UnknownKeyFor @NonNull @Initialized String shardTemplate, @UnknownKeyFor @NonNull @Initialized String suffix, @UnknownKeyFor @NonNull @Initialized boolean explicitTemplate) {
            this.baseFilename = baseFilename;
            this.shardTemplate = shardTemplate;
            this.suffix = suffix;
            this.explicitTemplate = explicitTemplate;
        }

        public @UnknownKeyFor @NonNull @Initialized Params withWindowedWrites() {
            String template = this.shardTemplate;
            if (!this.explicitTemplate) {
                template = DefaultFilenamePolicy.DEFAULT_WINDOWED_SHARD_TEMPLATE;
            }
            return new Params(this.baseFilename, template, this.suffix, this.explicitTemplate);
        }

        public @UnknownKeyFor @NonNull @Initialized Params withBaseFilename(@UnknownKeyFor @NonNull @Initialized ResourceId baseFilename) {
            return this.withBaseFilename(ValueProvider.StaticValueProvider.of(baseFilename));
        }

        public @UnknownKeyFor @NonNull @Initialized Params withBaseFilename(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> baseFilename) {
            return new Params(baseFilename, this.shardTemplate, this.suffix, this.explicitTemplate);
        }

        public @UnknownKeyFor @NonNull @Initialized Params withShardTemplate(@UnknownKeyFor @NonNull @Initialized String shardTemplate) {
            return new Params(this.baseFilename, shardTemplate, this.suffix, true);
        }

        public @UnknownKeyFor @NonNull @Initialized Params withSuffix(@UnknownKeyFor @NonNull @Initialized String suffix) {
            return new Params(this.baseFilename, this.shardTemplate, suffix, this.explicitTemplate);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.baseFilename.get(), this.shardTemplate, this.suffix});
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (!(o instanceof Params)) {
                return false;
            }
            Params other = (Params)o;
            return this.baseFilename.get().equals(other.baseFilename.get()) && this.shardTemplate.equals(other.shardTemplate) && this.suffix.equals(other.suffix);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper((Object)this).add("baseFilename", this.baseFilename).add("shardTemplate", (Object)this.shardTemplate).add("suffix", (Object)this.suffix).toString();
        }
    }
}

