/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.DefaultFilenamePolicy;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class DynamicFileDestinations {
    public static <UserT, OutputT> @UnknownKeyFor @NonNull @Initialized FileBasedSink.DynamicDestinations<UserT, @UnknownKeyFor @Nullable @Initialized Void, OutputT> constant(@UnknownKeyFor @NonNull @Initialized FileBasedSink.FilenamePolicy filenamePolicy, @UnknownKeyFor @NonNull @Initialized SerializableFunction<UserT, OutputT> formatFunction) {
        return new ConstantFilenamePolicy<UserT, OutputT>(filenamePolicy, formatFunction);
    }

    public static <UserT> @UnknownKeyFor @NonNull @Initialized FileBasedSink.DynamicDestinations<UserT, @UnknownKeyFor @Nullable @Initialized Void, UserT> constant(@UnknownKeyFor @NonNull @Initialized FileBasedSink.FilenamePolicy filenamePolicy) {
        return new ConstantFilenamePolicy(filenamePolicy, SerializableFunctions.identity());
    }

    public static <UserT, OutputT> @UnknownKeyFor @NonNull @Initialized FileBasedSink.DynamicDestinations<UserT, @UnknownKeyFor @NonNull @Initialized DefaultFilenamePolicy.Params, OutputT> toDefaultPolicies(@UnknownKeyFor @NonNull @Initialized SerializableFunction<UserT, @UnknownKeyFor @NonNull @Initialized DefaultFilenamePolicy.Params> destinationFunction, @UnknownKeyFor @NonNull @Initialized DefaultFilenamePolicy.Params emptyDestination, @UnknownKeyFor @NonNull @Initialized SerializableFunction<UserT, OutputT> formatFunction) {
        return new DefaultPolicyDestinations<UserT, OutputT>(destinationFunction, emptyDestination, formatFunction);
    }

    private static class DefaultPolicyDestinations<@UnknownKeyFor UserT, @UnknownKeyFor OutputT>
    extends FileBasedSink.DynamicDestinations<UserT, DefaultFilenamePolicy.Params, OutputT> {
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<UserT, @UnknownKeyFor @NonNull @Initialized DefaultFilenamePolicy.Params> destinationFunction;
        private final @UnknownKeyFor @NonNull @Initialized DefaultFilenamePolicy.Params emptyDestination;
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<UserT, OutputT> formatFunction;

        public DefaultPolicyDestinations(@UnknownKeyFor @NonNull @Initialized SerializableFunction<UserT, @UnknownKeyFor @NonNull @Initialized DefaultFilenamePolicy.Params> destinationFunction, @UnknownKeyFor @NonNull @Initialized DefaultFilenamePolicy.Params emptyDestination, @UnknownKeyFor @NonNull @Initialized SerializableFunction<UserT, OutputT> formatFunction) {
            this.destinationFunction = destinationFunction;
            this.emptyDestination = emptyDestination;
            this.formatFunction = formatFunction;
        }

        @Override
        public OutputT formatRecord(UserT record) {
            return this.formatFunction.apply(record);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized DefaultFilenamePolicy.Params getDestination(UserT element) {
            return this.destinationFunction.apply(element);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized DefaultFilenamePolicy.Params getDefaultDestination() {
            return this.emptyDestination;
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Coder<@UnknownKeyFor @NonNull @Initialized DefaultFilenamePolicy.Params> getDestinationCoder() {
            return DefaultFilenamePolicy.ParamsCoder.of();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized FileBasedSink.FilenamePolicy getFilenamePolicy(@UnknownKeyFor @NonNull @Initialized DefaultFilenamePolicy.Params params) {
            return DefaultFilenamePolicy.fromParams(params);
        }
    }

    private static class ConstantFilenamePolicy<@UnknownKeyFor UserT, @UnknownKeyFor OutputT>
    extends FileBasedSink.DynamicDestinations<UserT, Void, OutputT> {
        private final @UnknownKeyFor @NonNull @Initialized FileBasedSink.FilenamePolicy filenamePolicy;
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<UserT, OutputT> formatFunction;

        public ConstantFilenamePolicy(@UnknownKeyFor @NonNull @Initialized FileBasedSink.FilenamePolicy filenamePolicy, @UnknownKeyFor @NonNull @Initialized SerializableFunction<UserT, OutputT> formatFunction) {
            this.filenamePolicy = filenamePolicy;
            this.formatFunction = formatFunction;
        }

        @Override
        public OutputT formatRecord(UserT record) {
            return this.formatFunction.apply(record);
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Void getDestination(UserT element) {
            return null;
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Coder<@UnknownKeyFor @Nullable @Initialized Void> getDestinationCoder() {
            return null;
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Void getDefaultDestination() {
            return null;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized FileBasedSink.FilenamePolicy getFilenamePolicy(@UnknownKeyFor @Nullable @Initialized Void destination) {
            return this.filenamePolicy;
        }

        @Override
        public void populateDisplayData( @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            Preconditions.checkState((this.filenamePolicy != null ? 1 : 0) != 0);
            this.filenamePolicy.populateDisplayData(builder);
        }
    }
}

