/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.metrics.AutoValue_MetricName;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

@Experimental(value=Experimental.Kind.METRICS)
@AutoValue
public abstract class MetricName
implements Serializable {
    public abstract @UnknownKeyFor @NonNull @Initialized String getNamespace();

    public abstract @UnknownKeyFor @NonNull @Initialized String getName();

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return this.getNamespace() + ":" + this.getName();
    }

    public static @UnknownKeyFor @NonNull @Initialized MetricName named(@UnknownKeyFor @NonNull @Initialized String namespace, @UnknownKeyFor @NonNull @Initialized String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"Metric namespace must be non-empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Metric name must be non-empty");
        return new AutoValue_MetricName(namespace, name);
    }

    public static @UnknownKeyFor @NonNull @Initialized MetricName named(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> namespace, @UnknownKeyFor @NonNull @Initialized String name) {
        Preconditions.checkArgument((namespace != null ? 1 : 0) != 0, (Object)"Metric namespace must be non-null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Metric name must be non-empty");
        return new AutoValue_MetricName(namespace.getName(), name);
    }
}

