/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.join;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.join.CoGbkResultSchema;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class KeyedPCollectionTuple<@UnknownKeyFor K>
implements PInput {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TaggedKeyedPCollection<K, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> keyedCollections;
    private @Nullable @UnknownKeyFor @Initialized Coder<K> keyCoder;
    private final @UnknownKeyFor @NonNull @Initialized CoGbkResultSchema schema;
    private final @UnknownKeyFor @NonNull @Initialized Pipeline pipeline;

    public static <K> @UnknownKeyFor @NonNull @Initialized KeyedPCollectionTuple<K> empty(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        return new KeyedPCollectionTuple<K>(pipeline);
    }

    public static <K, InputT> @UnknownKeyFor @NonNull @Initialized KeyedPCollectionTuple<K> of(@UnknownKeyFor @NonNull @Initialized TupleTag<InputT> tag, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>> pc) {
        return new KeyedPCollectionTuple<K>(pc.getPipeline()).and(tag, pc);
    }

    public static <K, InputT> @UnknownKeyFor @NonNull @Initialized KeyedPCollectionTuple<K> of(@UnknownKeyFor @NonNull @Initialized String tag, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>> pc) {
        return KeyedPCollectionTuple.of(new TupleTag(tag), pc);
    }

    public <V> @UnknownKeyFor @NonNull @Initialized KeyedPCollectionTuple<K> and(@UnknownKeyFor @NonNull @Initialized TupleTag<V> tag, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> pc) {
        if (pc.getPipeline() != this.getPipeline()) {
            throw new IllegalArgumentException("PCollections come from different Pipelines");
        }
        TaggedKeyedPCollection<K, V> wrapper = new TaggedKeyedPCollection<K, V>(tag, pc);
        Coder<K> myKeyCoder = this.keyCoder == null ? KeyedPCollectionTuple.getKeyCoder(pc) : this.keyCoder;
        List<TaggedKeyedPCollection<K, ?>> newKeyedCollections = KeyedPCollectionTuple.copyAddLast(this.keyedCollections, wrapper);
        return new KeyedPCollectionTuple<K>(this.getPipeline(), newKeyedCollections, this.schema.getTupleTagList().and(tag), myKeyCoder);
    }

    public <V> @UnknownKeyFor @NonNull @Initialized KeyedPCollectionTuple<K> and(@UnknownKeyFor @NonNull @Initialized String tag, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> pc) {
        return this.and(new TupleTag(tag), pc);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
        return this.keyedCollections.isEmpty();
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TaggedKeyedPCollection<K, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getKeyedCollections() {
        return this.keyedCollections;
    }

    public <OutputT extends POutput> OutputT apply(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized KeyedPCollectionTuple<K>, OutputT> transform) {
        return Pipeline.applyTransform(this, transform);
    }

    public <OutputT extends POutput> OutputT apply(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized KeyedPCollectionTuple<K>, OutputT> transform) {
        return Pipeline.applyTransform(name, this, transform);
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> expand() {
        ImmutableMap.Builder retval = ImmutableMap.builder();
        for (TaggedKeyedPCollection<K, ?> taggedPCollection : this.keyedCollections) {
            retval.put(taggedPCollection.tupleTag, taggedPCollection.pCollection);
        }
        return retval.build();
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<K> getKeyCoder() {
        if (this.keyCoder == null) {
            throw new IllegalStateException("cannot return null keyCoder");
        }
        return this.keyCoder;
    }

    public @UnknownKeyFor @NonNull @Initialized CoGbkResultSchema getCoGbkResultSchema() {
        return this.schema;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Pipeline getPipeline() {
        return this.pipeline;
    }

    private static <K, V> @UnknownKeyFor @NonNull @Initialized Coder<K> getKeyCoder(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> pc) {
        Coder<KV<K, V>> entryCoder = pc.getCoder();
        if (!(entryCoder instanceof KvCoder)) {
            throw new IllegalArgumentException("PCollection does not use a KvCoder");
        }
        KvCoder coder = (KvCoder)entryCoder;
        return coder.getKeyCoder();
    }

    KeyedPCollectionTuple(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        this(pipeline, new ArrayList(), TupleTagList.empty(), null);
    }

    KeyedPCollectionTuple(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TaggedKeyedPCollection<K, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> keyedCollections, @UnknownKeyFor @NonNull @Initialized TupleTagList tupleTagList, @Nullable @UnknownKeyFor @Initialized Coder<K> keyCoder) {
        this.pipeline = pipeline;
        this.keyedCollections = keyedCollections;
        this.schema = new CoGbkResultSchema(tupleTagList);
        this.keyCoder = keyCoder;
    }

    private static <K> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TaggedKeyedPCollection<K, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> copyAddLast(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TaggedKeyedPCollection<K, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> keyedCollections, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TaggedKeyedPCollection<K, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> taggedCollection) {
        ArrayList retval = new ArrayList(keyedCollections);
        retval.add(taggedCollection);
        return retval;
    }

    public static class TaggedKeyedPCollection<@UnknownKeyFor K, @UnknownKeyFor V> {
        final @UnknownKeyFor @NonNull @Initialized TupleTag<V> tupleTag;
        final @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> pCollection;

        public TaggedKeyedPCollection(@UnknownKeyFor @NonNull @Initialized TupleTag<V> tupleTag, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> pCollection) {
            this.tupleTag = tupleTag;
            this.pCollection = pCollection;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> getCollection() {
            return this.pCollection;
        }

        public @UnknownKeyFor @NonNull @Initialized TupleTag<V> getTupleTag() {
            return this.tupleTag;
        }
    }
}

