/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.http.InputStreamContent;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.BaseAbstractGoogleAsyncWriteChannel;
import com.google.cloud.hadoop.util.ClientRequestHelper;
import com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;

public abstract class AbstractGoogleAsyncWriteChannel<T extends AbstractGoogleClientRequest<S>, S>
extends BaseAbstractGoogleAsyncWriteChannel<S> {
    private final ClientRequestHelper<S> clientRequestHelper;

    public AbstractGoogleAsyncWriteChannel(ClientRequestHelper<S> clientRequestHelper, ExecutorService threadPool, AsyncWriteChannelOptions options) {
        super(threadPool, options);
        this.clientRequestHelper = clientRequestHelper;
    }

    public abstract T createRequest(InputStreamContent var1) throws IOException;

    @Override
    public void startUpload(InputStream pipeSource) throws IOException {
        InputStreamContent objectContentStream = new InputStreamContent(this.getContentType(), pipeSource).setLength(-1L).setCloseInputStream(false);
        T request = this.createRequest(objectContentStream);
        request.setDisableGZipContent(true);
        this.clientRequestHelper.setChunkSize((AbstractGoogleClientRequest<S>)request, this.channelOptions.getUploadChunkSize());
        this.uploadOperation = this.threadPool.submit(new UploadOperation(this, request, pipeSource));
    }

    protected abstract String getContentType();

    static class UploadOperation
    implements Callable<S> {
        private final T uploadObject;
        private final InputStream pipeSource;
        final /* synthetic */ AbstractGoogleAsyncWriteChannel this$0;

        public UploadOperation(T uploadObject, InputStream pipeSource) {
            this.this$0 = this$0;
            this.uploadObject = uploadObject;
            this.pipeSource = pipeSource;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public S call() throws Exception {
            try (InputStream ignore = this.pipeSource;){
                Object throwable3 = this.uploadObject.execute();
                return throwable3;
            }
            catch (IOException ioe) {
                Object response = this.this$0.createResponseFromException(ioe);
                if (response == null) throw ioe;
                ((GoogleLogger.Api)((GoogleLogger.Api)BaseAbstractGoogleAsyncWriteChannel.logger.atWarning()).withCause((Throwable)ioe)).log("Received IOException, but successfully converted to response '%s'.", response);
                return response;
            }
        }
    }
}

