/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.ldapinput;

import java.util.HashSet;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transforms.ldapinput.LdapInputMeta;

public class LdapInputField
implements Cloneable {
    private static final Class<?> PKG = LdapInputMeta.class;
    public static final String ATTRIBUTE_OBJECT_SID = "objectSid";
    public static final int FETCH_ATTRIBUTE_AS_STRING = 0;
    public static final int FETCH_ATTRIBUTE_AS_BINARY = 1;
    public static final String[] FetchAttributeAsCode = new String[]{"string", "binary"};
    public static final String[] FetchAttributeAsDesc = new String[]{BaseMessages.getString(PKG, (String)"LdapInputField.FetchAttributeAs.String", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LdapInputField.FetchAttributeAs.Binary", (String[])new String[0])};
    public static final int TYPE_TRIM_NONE = 0;
    public static final int TYPE_TRIM_LEFT = 1;
    public static final int TYPE_TRIM_RIGHT = 2;
    public static final int TYPE_TRIM_BOTH = 3;
    public static final String[] trimTypeCode = new String[]{"none", "left", "right", "both"};
    public static final String[] trimTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"LdapInputField.TrimType.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LdapInputField.TrimType.Left", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LdapInputField.TrimType.Right", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LdapInputField.TrimType.Both", (String[])new String[0])};
    private String name;
    private String attribute;
    private int fetchAttributeAs;
    private int type;
    private int length;
    private String format;
    private int trimtype;
    private int precision;
    private String currencySymbol;
    private String decimalSymbol;
    private String groupSymbol;
    private boolean repeat;
    private String realAttribute;
    private boolean objectSid;
    private boolean sortedKey;
    private String[] samples;
    public static HashSet<String> binaryAttributes = new HashSet();

    public LdapInputField(String fieldname) {
        this.name = fieldname;
        this.attribute = "";
        this.length = -1;
        this.fetchAttributeAs = 0;
        this.type = 2;
        this.format = "";
        this.trimtype = 0;
        this.groupSymbol = "";
        this.decimalSymbol = "";
        this.currencySymbol = "";
        this.precision = -1;
        this.repeat = false;
        this.realAttribute = "";
        this.sortedKey = false;
    }

    public LdapInputField() {
        this(null);
    }

    public static final int getTrimTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeCode.length; ++i) {
            if (!trimTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final int getFetchAttributeAsByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < FetchAttributeAsCode.length; ++i) {
            if (!FetchAttributeAsCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final int getTrimTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeDesc.length; ++i) {
            if (!trimTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final int getFetchAttributeAsByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < FetchAttributeAsDesc.length; ++i) {
            if (!FetchAttributeAsDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final String getTrimTypeCode(int i) {
        if (i < 0 || i >= trimTypeCode.length) {
            return trimTypeCode[0];
        }
        return trimTypeCode[i];
    }

    public static final String getFetchAttributeAsCode(int i) {
        if (i < 0 || i >= FetchAttributeAsCode.length) {
            return FetchAttributeAsCode[0];
        }
        return FetchAttributeAsCode[i];
    }

    public static final String getTrimTypeDesc(int i) {
        if (i < 0 || i >= trimTypeDesc.length) {
            return trimTypeDesc[0];
        }
        return trimTypeDesc[i];
    }

    public static final String getFetchAttributeAsDesc(int i) {
        if (i < 0 || i >= FetchAttributeAsDesc.length) {
            return FetchAttributeAsDesc[0];
        }
        return FetchAttributeAsDesc[i];
    }

    public Object clone() {
        try {
            LdapInputField retval = (LdapInputField)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String fieldattribute) {
        this.attribute = fieldattribute;
    }

    public void setName(String fieldname) {
        this.name = fieldname;
    }

    public int getType() {
        return this.type;
    }

    public int getReturnType() {
        return this.fetchAttributeAs;
    }

    public String getTypeDesc() {
        return ValueMetaFactory.getValueMetaName((int)this.type);
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setSamples(String[] samples) {
        this.samples = samples;
    }

    public String[] getSamples() {
        return this.samples;
    }

    public int getTrimType() {
        return this.trimtype;
    }

    public String getTrimTypeCode() {
        return LdapInputField.getTrimTypeCode(this.trimtype);
    }

    public String getFetchAttributeAsCode() {
        return LdapInputField.getFetchAttributeAsCode(this.fetchAttributeAs);
    }

    public String getTrimTypeDesc() {
        return LdapInputField.getTrimTypeDesc(this.trimtype);
    }

    public String getFetchAttributeAsDesc() {
        return LdapInputField.getFetchAttributeAsDesc(this.fetchAttributeAs);
    }

    public void setTrimType(int trimtype) {
        this.trimtype = trimtype;
    }

    public boolean isSortedKey() {
        return this.sortedKey;
    }

    public void setSortedKey(boolean value) {
        this.sortedKey = value;
    }

    public void setFetchAttributeAs(int fetchAttributeAs) {
        this.fetchAttributeAs = fetchAttributeAs;
    }

    public String getGroupSymbol() {
        return this.groupSymbol;
    }

    public void setGroupSymbol(String groupSymbol) {
        this.groupSymbol = groupSymbol;
    }

    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public void setDecimalSymbol(String decimalSymbol) {
        this.decimalSymbol = decimalSymbol;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public boolean isRepeated() {
        return this.repeat;
    }

    public void setRepeated(boolean repeat) {
        this.repeat = repeat;
    }

    public void flipRepeated() {
        this.repeat = !this.repeat;
    }

    public String getRealAttribute() {
        return this.realAttribute;
    }

    public void setRealAttribute(String realfieldattribute) {
        this.realAttribute = realfieldattribute;
        if (!Utils.isEmpty((CharSequence)realfieldattribute) && realfieldattribute.equals(ATTRIBUTE_OBJECT_SID)) {
            this.objectSid = true;
        }
    }

    public boolean isObjectSid() {
        return this.objectSid;
    }

    static {
        binaryAttributes.add("photo");
        binaryAttributes.add("personalSignature");
        binaryAttributes.add("audio");
        binaryAttributes.add("jpegPhoto");
        binaryAttributes.add("javaSerializedData");
        binaryAttributes.add("thumbnailPhoto");
        binaryAttributes.add("thumbnailLogo");
        binaryAttributes.add("userPassword");
        binaryAttributes.add("userCertificate");
        binaryAttributes.add("cACertificate");
        binaryAttributes.add("authorityRevocationList");
        binaryAttributes.add("certificateRevocationList");
        binaryAttributes.add("crossCertificatePair");
        binaryAttributes.add("x500UniqueIdentifier");
        binaryAttributes.add(ATTRIBUTE_OBJECT_SID);
        binaryAttributes.add("objectGUID");
        binaryAttributes.add("GUID");
    }
}

