/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.ldapinput;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.transforms.ldapinput.ILdapMeta;
import org.apache.hop.pipeline.transforms.ldapinput.LdapProtocol;
import org.apache.hop.pipeline.transforms.ldapinput.LdapSslProtocol;
import org.apache.hop.pipeline.transforms.ldapinput.LdapTlsProtocol;

public class LdapProtocolFactory {
    protected static final List<Class<? extends LdapProtocol>> protocols = LdapProtocolFactory.initProtocols();
    private final ILogChannel log;

    private static List<Class<? extends LdapProtocol>> initProtocols() {
        ArrayList<Class<? extends LdapProtocol>> protocols = new ArrayList<Class<? extends LdapProtocol>>();
        protocols.add(LdapProtocol.class);
        protocols.add(LdapSslProtocol.class);
        protocols.add(LdapTlsProtocol.class);
        return protocols;
    }

    private static String getName(Class<? extends LdapProtocol> protocol) throws HopException {
        try {
            return protocol.getMethod("getName", new Class[0]).invoke(null, new Object[0]).toString();
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<String> getConnectionTypes(ILogChannel log) {
        ArrayList<String> result = new ArrayList<String>();
        List<Class<? extends LdapProtocol>> list = protocols;
        synchronized (list) {
            for (Class<? extends LdapProtocol> protocol : protocols) {
                try {
                    result.add(LdapProtocolFactory.getName(protocol));
                }
                catch (HopException e) {
                    log.logError("Unable to get name for " + protocol.getCanonicalName());
                }
            }
        }
        return result;
    }

    public LdapProtocolFactory(ILogChannel log) {
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LdapProtocol createLdapProtocol(IVariables variables, ILdapMeta meta, Collection<String> binaryAttributes) throws HopException {
        String connectionType = variables.resolve(meta.getProtocol());
        List<Class<? extends LdapProtocol>> list = protocols;
        synchronized (list) {
            for (Class<? extends LdapProtocol> protocol : protocols) {
                if (!LdapProtocolFactory.getName(protocol).equals(connectionType)) continue;
                try {
                    return protocol.getConstructor(ILogChannel.class, IVariables.class, ILdapMeta.class, Collection.class).newInstance(this.log, variables, meta, binaryAttributes);
                }
                catch (Exception e) {
                    throw new HopException((Throwable)e);
                }
            }
        }
        return null;
    }
}

