/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.sink2.TwoPhaseCommittingSink;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessage;
import org.apache.flink.streaming.api.connector.sink2.WithPostCommitTopology;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.runtime.operators.sink.CommitterOperator;
import org.apache.flink.util.Preconditions;

@Internal
public final class CommitterOperatorFactory<CommT>
extends AbstractStreamOperatorFactory<CommittableMessage<CommT>>
implements OneInputStreamOperatorFactory<CommittableMessage<CommT>, CommittableMessage<CommT>> {
    private final TwoPhaseCommittingSink<?, CommT> sink;
    private final boolean isBatchMode;
    private final boolean isCheckpointingEnabled;

    public CommitterOperatorFactory(TwoPhaseCommittingSink<?, CommT> sink, boolean isBatchMode, boolean isCheckpointingEnabled) {
        this.sink = (TwoPhaseCommittingSink)Preconditions.checkNotNull(sink);
        this.isBatchMode = isBatchMode;
        this.isCheckpointingEnabled = isCheckpointingEnabled;
    }

    @Override
    public <T extends StreamOperator<CommittableMessage<CommT>>> T createStreamOperator(StreamOperatorParameters<CommittableMessage<CommT>> parameters) {
        try {
            CommitterOperator<CommT> committerOperator = new CommitterOperator<CommT>(this.processingTimeService, this.sink.getCommittableSerializer(), this.sink.createCommitter(), this.sink instanceof WithPostCommitTopology, this.isBatchMode, this.isCheckpointingEnabled);
            committerOperator.setup(parameters.getContainingTask(), parameters.getStreamConfig(), parameters.getOutput());
            return (T)committerOperator;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create commit operator for " + parameters.getStreamConfig().getOperatorName(), e);
        }
    }

    @Override
    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return CommitterOperator.class;
    }
}

