/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.engines.spark;

import java.util.Arrays;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.engines.BeamPipelineRunConfiguration;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.metadata.RunnerType;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;

@GuiPlugin
public class BeamSparkPipelineRunConfiguration
extends BeamPipelineRunConfiguration
implements IBeamPipelineEngineRunConfiguration,
IVariables,
Cloneable {
    @GuiWidgetElement(order="20000-spark-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesSpark.OptionsMaster.Label", toolTip="i18n::BeamEnginesSpark.OptionsMaster.ToolTip")
    @HopMetadataProperty
    private String sparkMaster;
    @GuiWidgetElement(order="20010-spark-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesSpark.OptionsBatchIntervalMillis.Label", toolTip="i18n::BeamEnginesSpark.OptionsBatchIntervalMillis.ToolTip")
    @HopMetadataProperty
    private String sparkBatchIntervalMillis;
    @GuiWidgetElement(order="20020-spark-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.FOLDER, label="i18n::BeamEnginesSpark.OptionsCheckpointDir.Label", toolTip="i18n::BeamEnginesSpark.OptionsCheckpointDir.ToolTip")
    @HopMetadataProperty
    private String sparkCheckpointDir;
    @GuiWidgetElement(order="20030-spark-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesSpark.OptionsCheckpointDurationMillis.Label", toolTip="i18n::BeamEnginesSpark.OptionsCheckpointDurationMillis.ToolTip")
    @HopMetadataProperty
    private String sparkCheckpointDurationMillis;
    @GuiWidgetElement(order="20040-spark-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.CHECKBOX, label="i18n::BeamEnginesSpark.OptionsEnableSparkMetricSinks.Label", toolTip="i18n::BeamEnginesSpark.OptionsEnableSparkMetricSinks.ToolTip")
    @HopMetadataProperty
    private boolean sparkEnableSparkMetricSinks;
    @GuiWidgetElement(order="20050-spark-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesSpark.OptionsMaxRecordsPerBatch.Label", toolTip="i18n::BeamEnginesSpark.OptionsMaxRecordsPerBatch.ToolTip")
    @HopMetadataProperty
    private String sparkMaxRecordsPerBatch;
    @GuiWidgetElement(order="20060-spark-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesSpark.OptionsMinReadTimeMillis.Label", toolTip="i18n::BeamEnginesSpark.OptionsMinReadTimeMillis.ToolTip")
    @HopMetadataProperty
    private String sparkMinReadTimeMillis;
    @GuiWidgetElement(order="20070-spark-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesSpark.OptionsReadTimePercentage.Label", toolTip="i18n::BeamEnginesSpark.OptionsReadTimePercentage.ToolTip")
    @HopMetadataProperty
    private String sparkReadTimePercentage;
    @GuiWidgetElement(order="20080-spark-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesSpark.OptionsBundleSize.Label", toolTip="i18n::BeamEnginesSpark.OptionsBundleSize.ToolTip")
    @HopMetadataProperty
    private String sparkBundleSize;
    @GuiWidgetElement(order="20090-spark-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesSpark.OptionsAppName.Label", toolTip="i18n::BeamEnginesSpark.OptionsAppName.ToolTip")
    @HopMetadataProperty
    private String sparkAppName;
    @HopMetadataProperty
    private String sparkStorageLevel;

    public BeamSparkPipelineRunConfiguration() {
        this.tempLocation = System.getProperty("java.io.tmpdir");
    }

    public BeamSparkPipelineRunConfiguration(BeamSparkPipelineRunConfiguration config) {
        super(config);
        this.sparkMaster = config.sparkMaster;
        this.sparkBatchIntervalMillis = config.sparkBatchIntervalMillis;
        this.sparkCheckpointDir = config.sparkCheckpointDir;
        this.sparkCheckpointDurationMillis = config.sparkCheckpointDurationMillis;
        this.sparkEnableSparkMetricSinks = config.sparkEnableSparkMetricSinks;
        this.sparkMaxRecordsPerBatch = config.sparkMaxRecordsPerBatch;
        this.sparkMinReadTimeMillis = config.sparkMinReadTimeMillis;
        this.sparkReadTimePercentage = config.sparkReadTimePercentage;
        this.sparkBundleSize = config.sparkBundleSize;
        this.sparkStorageLevel = config.sparkStorageLevel;
        this.sparkAppName = config.sparkAppName;
    }

    public BeamSparkPipelineRunConfiguration clone() {
        return new BeamSparkPipelineRunConfiguration(this);
    }

    public RunnerType getRunnerType() {
        return RunnerType.Spark;
    }

    public PipelineOptions getPipelineOptions() throws HopException {
        long bundleSize;
        double percentage;
        long readTime;
        long records;
        long duration;
        long interval;
        SparkPipelineOptions options = (SparkPipelineOptions)PipelineOptionsFactory.as(SparkPipelineOptions.class);
        if (StringUtils.isNotEmpty((String)this.getSparkMaster())) {
            options.setSparkMaster(this.resolve(this.getSparkMaster()));
        }
        if (StringUtils.isNotEmpty((String)this.getSparkBatchIntervalMillis()) && (interval = Const.toLong((String)this.resolve(this.getSparkBatchIntervalMillis()), (long)-1L)) >= 0L) {
            options.setBatchIntervalMillis(Long.valueOf(interval));
        }
        if (StringUtils.isNotEmpty((String)this.getSparkCheckpointDir())) {
            options.setCheckpointDir(this.resolve(this.getSparkCheckpointDir()));
        }
        if (StringUtils.isNotEmpty((String)this.getSparkCheckpointDurationMillis()) && (duration = Const.toLong((String)this.resolve(this.getSparkCheckpointDurationMillis()), (long)-1L)) >= 0L) {
            options.setCheckpointDurationMillis(Long.valueOf(duration));
        }
        if (StringUtils.isNotEmpty((String)this.getSparkMaxRecordsPerBatch()) && (records = Const.toLong((String)this.resolve(this.getSparkMaxRecordsPerBatch()), (long)-1L)) >= 0L) {
            options.setMaxRecordsPerBatch(Long.valueOf(records));
        }
        if (StringUtils.isNotEmpty((String)this.getSparkMinReadTimeMillis()) && (readTime = Const.toLong((String)this.resolve(this.getSparkMinReadTimeMillis()), (long)-1L)) >= 0L) {
            options.setMinReadTimeMillis(Long.valueOf(readTime));
        }
        if (StringUtils.isNotEmpty((String)this.getSparkReadTimePercentage()) && (percentage = Const.toDouble((String)this.resolve(this.getSparkReadTimePercentage()), (double)-1.0)) >= 0.0) {
            options.setReadTimePercentage(Double.valueOf(percentage / 100.0));
        }
        if (StringUtils.isNotEmpty((String)this.getSparkBundleSize()) && (bundleSize = Const.toLong((String)this.resolve(this.getSparkBundleSize()), (long)-1L)) >= 0L) {
            options.setBundleSize(Long.valueOf(bundleSize));
        }
        if (StringUtils.isNotEmpty((String)this.getSparkStorageLevel())) {
            options.setStorageLevel(this.resolve(this.getSparkStorageLevel()));
        }
        if (StringUtils.isNotEmpty((String)this.getFatJar())) {
            options.setFilesToStage(Arrays.asList(this.resolve(this.fatJar)));
        }
        options.setEnableSparkMetricSinks(Boolean.valueOf(this.isSparkEnableSparkMetricSinks()));
        if (StringUtils.isNotEmpty((String)this.getSparkAppName())) {
            options.setAppName(this.resolve(this.getSparkAppName()));
        }
        return options;
    }

    public boolean isRunningAsynchronous() {
        return true;
    }

    public String getSparkMaster() {
        return this.sparkMaster;
    }

    public void setSparkMaster(String sparkMaster) {
        this.sparkMaster = sparkMaster;
    }

    public String getSparkBatchIntervalMillis() {
        return this.sparkBatchIntervalMillis;
    }

    public void setSparkBatchIntervalMillis(String sparkBatchIntervalMillis) {
        this.sparkBatchIntervalMillis = sparkBatchIntervalMillis;
    }

    public String getSparkCheckpointDir() {
        return this.sparkCheckpointDir;
    }

    public void setSparkCheckpointDir(String sparkCheckpointDir) {
        this.sparkCheckpointDir = sparkCheckpointDir;
    }

    public String getSparkCheckpointDurationMillis() {
        return this.sparkCheckpointDurationMillis;
    }

    public void setSparkCheckpointDurationMillis(String sparkCheckpointDurationMillis) {
        this.sparkCheckpointDurationMillis = sparkCheckpointDurationMillis;
    }

    public boolean isSparkEnableSparkMetricSinks() {
        return this.sparkEnableSparkMetricSinks;
    }

    public void setSparkEnableSparkMetricSinks(boolean sparkEnableSparkMetricSinks) {
        this.sparkEnableSparkMetricSinks = sparkEnableSparkMetricSinks;
    }

    public String getSparkMaxRecordsPerBatch() {
        return this.sparkMaxRecordsPerBatch;
    }

    public void setSparkMaxRecordsPerBatch(String sparkMaxRecordsPerBatch) {
        this.sparkMaxRecordsPerBatch = sparkMaxRecordsPerBatch;
    }

    public String getSparkMinReadTimeMillis() {
        return this.sparkMinReadTimeMillis;
    }

    public void setSparkMinReadTimeMillis(String sparkMinReadTimeMillis) {
        this.sparkMinReadTimeMillis = sparkMinReadTimeMillis;
    }

    public String getSparkReadTimePercentage() {
        return this.sparkReadTimePercentage;
    }

    public void setSparkReadTimePercentage(String sparkReadTimePercentage) {
        this.sparkReadTimePercentage = sparkReadTimePercentage;
    }

    public String getSparkBundleSize() {
        return this.sparkBundleSize;
    }

    public void setSparkBundleSize(String sparkBundleSize) {
        this.sparkBundleSize = sparkBundleSize;
    }

    public String getSparkStorageLevel() {
        return this.sparkStorageLevel;
    }

    public void setSparkStorageLevel(String sparkStorageLevel) {
        this.sparkStorageLevel = sparkStorageLevel;
    }

    public String getSparkAppName() {
        return this.sparkAppName;
    }

    public void setSparkAppName(String sparkAppName) {
        this.sparkAppName = sparkAppName;
    }
}

