/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.clouddocs;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.clouddocs.Content;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

class UpdateContentArg {
    protected final String fileId;
    protected final List<String> actorTokens;
    protected final List<Content> additionalContents;

    public UpdateContentArg(String fileId, List<String> actorTokens, List<Content> additionalContents) {
        if (fileId == null) {
            throw new IllegalArgumentException("Required value for 'fileId' is null");
        }
        if (fileId.length() < 4) {
            throw new IllegalArgumentException("String 'fileId' is shorter than 4");
        }
        if (!Pattern.matches("id:.+", fileId)) {
            throw new IllegalArgumentException("String 'fileId' does not match pattern");
        }
        this.fileId = fileId;
        if (actorTokens == null) {
            throw new IllegalArgumentException("Required value for 'actorTokens' is null");
        }
        for (String string : actorTokens) {
            if (string != null) continue;
            throw new IllegalArgumentException("An item in list 'actorTokens' is null");
        }
        this.actorTokens = actorTokens;
        if (additionalContents != null) {
            for (Content content : additionalContents) {
                if (content != null) continue;
                throw new IllegalArgumentException("An item in list 'additionalContents' is null");
            }
        }
        this.additionalContents = additionalContents;
    }

    public UpdateContentArg(String fileId, List<String> actorTokens) {
        this(fileId, actorTokens, null);
    }

    public String getFileId() {
        return this.fileId;
    }

    public List<String> getActorTokens() {
        return this.actorTokens;
    }

    public List<Content> getAdditionalContents() {
        return this.additionalContents;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.fileId, this.actorTokens, this.additionalContents});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            UpdateContentArg other = (UpdateContentArg)obj;
            return !(this.fileId != other.fileId && !this.fileId.equals(other.fileId) || this.actorTokens != other.actorTokens && !this.actorTokens.equals(other.actorTokens) || this.additionalContents != other.additionalContents && (this.additionalContents == null || !this.additionalContents.equals(other.additionalContents)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<UpdateContentArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UpdateContentArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("file_id");
            StoneSerializers.string().serialize(value.fileId, g);
            g.writeFieldName("actor_tokens");
            StoneSerializers.list(StoneSerializers.string()).serialize(value.actorTokens, g);
            if (value.additionalContents != null) {
                g.writeFieldName("additional_contents");
                StoneSerializers.nullable(StoneSerializers.list(Content.Serializer.INSTANCE)).serialize(value.additionalContents, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public UpdateContentArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<Content> f_additionalContents;
            List<String> f_actorTokens;
            String f_fileId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_fileId = null;
                f_actorTokens = null;
                f_additionalContents = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("file_id".equals(field)) {
                        f_fileId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("actor_tokens".equals(field)) {
                        f_actorTokens = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("additional_contents".equals(field)) {
                        f_additionalContents = StoneSerializers.nullable(StoneSerializers.list(Content.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_fileId == null) {
                    throw new JsonParseException(p, "Required field \"file_id\" missing.");
                }
                if (f_actorTokens == null) {
                    throw new JsonParseException(p, "Required field \"actor_tokens\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            UpdateContentArg value = new UpdateContentArg(f_fileId, f_actorTokens, f_additionalContents);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

