/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public class FileLockMetadata {
    protected final Boolean isLockholder;
    protected final String lockholderName;
    protected final String lockholderAccountId;
    protected final Date created;

    public FileLockMetadata(Boolean isLockholder, String lockholderName, String lockholderAccountId, Date created) {
        this.isLockholder = isLockholder;
        this.lockholderName = lockholderName;
        if (lockholderAccountId != null) {
            if (lockholderAccountId.length() < 40) {
                throw new IllegalArgumentException("String 'lockholderAccountId' is shorter than 40");
            }
            if (lockholderAccountId.length() > 40) {
                throw new IllegalArgumentException("String 'lockholderAccountId' is longer than 40");
            }
        }
        this.lockholderAccountId = lockholderAccountId;
        this.created = LangUtil.truncateMillis(created);
    }

    public FileLockMetadata() {
        this(null, null, null, null);
    }

    public Boolean getIsLockholder() {
        return this.isLockholder;
    }

    public String getLockholderName() {
        return this.lockholderName;
    }

    public String getLockholderAccountId() {
        return this.lockholderAccountId;
    }

    public Date getCreated() {
        return this.created;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.isLockholder, this.lockholderName, this.lockholderAccountId, this.created});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            FileLockMetadata other = (FileLockMetadata)obj;
            return (this.isLockholder == other.isLockholder || this.isLockholder != null && this.isLockholder.equals(other.isLockholder)) && (this.lockholderName == other.lockholderName || this.lockholderName != null && this.lockholderName.equals(other.lockholderName)) && (this.lockholderAccountId == other.lockholderAccountId || this.lockholderAccountId != null && this.lockholderAccountId.equals(other.lockholderAccountId)) && (this.created == other.created || this.created != null && this.created.equals(other.created));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<FileLockMetadata> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FileLockMetadata value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            if (value.isLockholder != null) {
                g.writeFieldName("is_lockholder");
                StoneSerializers.nullable(StoneSerializers.boolean_()).serialize(value.isLockholder, g);
            }
            if (value.lockholderName != null) {
                g.writeFieldName("lockholder_name");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.lockholderName, g);
            }
            if (value.lockholderAccountId != null) {
                g.writeFieldName("lockholder_account_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.lockholderAccountId, g);
            }
            if (value.created != null) {
                g.writeFieldName("created");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.created, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public FileLockMetadata deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Date f_created;
            String f_lockholderAccountId;
            String f_lockholderName;
            Boolean f_isLockholder;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_isLockholder = null;
                f_lockholderName = null;
                f_lockholderAccountId = null;
                f_created = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("is_lockholder".equals(field)) {
                        f_isLockholder = StoneSerializers.nullable(StoneSerializers.boolean_()).deserialize(p);
                        continue;
                    }
                    if ("lockholder_name".equals(field)) {
                        f_lockholderName = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("lockholder_account_id".equals(field)) {
                        f_lockholderAccountId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("created".equals(field)) {
                        f_created = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            FileLockMetadata value = new FileLockMetadata(f_isLockholder, f_lockholderName, f_lockholderAccountId, f_created);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected Boolean isLockholder = null;
        protected String lockholderName = null;
        protected String lockholderAccountId = null;
        protected Date created = null;

        protected Builder() {
        }

        public Builder withIsLockholder(Boolean isLockholder) {
            this.isLockholder = isLockholder;
            return this;
        }

        public Builder withLockholderName(String lockholderName) {
            this.lockholderName = lockholderName;
            return this;
        }

        public Builder withLockholderAccountId(String lockholderAccountId) {
            if (lockholderAccountId != null) {
                if (lockholderAccountId.length() < 40) {
                    throw new IllegalArgumentException("String 'lockholderAccountId' is shorter than 40");
                }
                if (lockholderAccountId.length() > 40) {
                    throw new IllegalArgumentException("String 'lockholderAccountId' is longer than 40");
                }
            }
            this.lockholderAccountId = lockholderAccountId;
            return this;
        }

        public Builder withCreated(Date created) {
            this.created = LangUtil.truncateMillis(created);
            return this;
        }

        public FileLockMetadata build() {
            return new FileLockMetadata(this.isLockholder, this.lockholderName, this.lockholderAccountId, this.created);
        }
    }
}

