/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AFPResource;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPIDAFPResource;
import com.ibm.as400.access.NPCPSelRes;
import com.ibm.as400.access.PrintObject;
import com.ibm.as400.access.PrintObjectList;
import com.ibm.as400.access.PrintObjectListImpl;
import com.ibm.as400.access.SpooledFile;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.Serializable;

public class AFPResourceList
extends PrintObjectList
implements Serializable {
    static final long serialVersionUID = 4L;
    private SpooledFile spooledFileFilter_;
    private static final String RESOURCE_FILTER = "resourceFilter";
    private static final String SPOOLED_FILE_FILTER = "spooledFileFilter";

    public AFPResourceList() {
        super(7, new NPCPSelRes());
    }

    public AFPResourceList(AS400 aS400) {
        super(7, new NPCPSelRes(), aS400);
    }

    void chooseImpl() {
        AS400 aS400 = this.getSystem();
        if (aS400 == null) {
            Trace.log(2, "Attempt to use AFPResourceList before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.impl_ = (PrintObjectListImpl)aS400.loadImpl2("com.ibm.as400.access.AFPResourceListImplRemote", "com.ibm.as400.access.AFPResourceListImplProxy");
        super.setImpl();
    }

    public String getResourceFilter() {
        NPCPSelRes nPCPSelRes = (NPCPSelRes)this.getSelectionCP();
        return nPCPSelRes.getResource();
    }

    public SpooledFile getSpooledFileFilter() {
        return this.spooledFileFilter_;
    }

    PrintObject newNPObject(NPCPID nPCPID, NPCPAttribute nPCPAttribute) {
        return new AFPResource(this.system_, (NPCPIDAFPResource)nPCPID, nPCPAttribute);
    }

    public void setResourceFilter(String string) throws PropertyVetoException {
        if (string == null) {
            Trace.log(2, "Parameter 'resourceFilter' is null");
            throw new NullPointerException(RESOURCE_FILTER);
        }
        String string2 = this.getResourceFilter();
        this.vetos.fireVetoableChange(RESOURCE_FILTER, string2, string);
        NPCPSelRes nPCPSelRes = (NPCPSelRes)this.getSelectionCP();
        nPCPSelRes.setResource(string);
        if (this.impl_ != null) {
            this.impl_.setFilter("resource", string);
        }
        this.changes.firePropertyChange(RESOURCE_FILTER, string2, string);
    }

    public void setSpooledFileFilter(SpooledFile spooledFile) throws PropertyVetoException {
        SpooledFile spooledFile2 = this.getSpooledFileFilter();
        this.vetos.fireVetoableChange(SPOOLED_FILE_FILTER, spooledFile2, spooledFile);
        this.spooledFileFilter_ = spooledFile;
        if (this.spooledFileFilter_ == null) {
            this.setIDCodePointFilter(null);
        } else {
            this.setIDCodePointFilter(this.spooledFileFilter_.getIDCodePoint());
        }
        this.changes.firePropertyChange(SPOOLED_FILE_FILTER, spooledFile2, spooledFile);
    }
}

