/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.SQLDataFactory;
import com.ibm.as400.access.Trace;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;

public class AS400DecFloat
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private int digits;
    private static final long defaultValue = 0L;
    static final boolean HIGH_NIBBLE = true;
    static final boolean LOW_NIBBLE = false;
    private static final int DEC_FLOAT_16_BIAS = 398;
    private static final long DEC_FLOAT_16_SIGNAL_MASK = 0x200000000000000L;
    private static final long DEC_FLOAT_16_SIGN_MASK = Long.MIN_VALUE;
    private static final long DEC_FLOAT_16_COMBINATION_MASK = 0x7C00000000000000L;
    private static final long DEC_FLOAT_16_EXPONENT_CONTINUATION_MASK = 287104476244869120L;
    private static final long DEC_FLOAT_16_COEFFICIENT_CONTINUATION_MASK = 0x3FFFFFFFFFFFFL;
    private static final int DEC_FLOAT_34_BIAS = 6176;
    private static final long DEC_FLOAT_34_SIGNAL_MASK = 0x200000000000000L;
    private static final long DEC_FLOAT_34_SIGN_MASK = Long.MIN_VALUE;
    private static final long DEC_FLOAT_34_COMBINATION_MASK = 0x7C00000000000000L;
    private static final long DEC_FLOAT_34_EXPONENT_CONTINUATION_MASK = 288160007407534080L;
    static final long DEC_FLOAT_34_COEFFICIENT_CONTINUATION_MASK = 0x3FFFFFFFFFFFL;
    private static final int[][] tenRadixMagnitude = new int[][]{{1000000000}, {232830643, -1486618624}, {54210108, -1613725636, -402653184}};
    static /* synthetic */ Class class$java$math$BigDecimal;

    public AS400DecFloat(int n) {
        if (n != 16 && n != 34) {
            throw new ExtendedIllegalArgumentException("numDigits (" + String.valueOf(n) + ")", 4);
        }
        this.digits = n;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Trace.log(2, "Unexpected cloning error", (Throwable)cloneNotSupportedException);
            throw new InternalErrorException(6);
        }
    }

    public int getByteLength() {
        return this.digits == 16 ? 8 : 16;
    }

    public Object getDefaultValue() {
        return BigDecimal.valueOf(0L);
    }

    public int getInstanceType() {
        return 13;
    }

    public Class getJavaType() {
        return class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = AS400DecFloat.class$("java.math.BigDecimal")) : class$java$math$BigDecimal;
    }

    public int getNumberOfDigits() {
        return this.digits;
    }

    public byte[] toBytes(Object object) {
        byte[] byArray = new byte[this.getByteLength()];
        this.toBytes(object, byArray, 0);
        return byArray;
    }

    public int toBytes(Object object, byte[] byArray) {
        return this.toBytes(object, byArray, 0);
    }

    public int toBytes(Object object, byte[] byArray, int n) {
        long l;
        int n2;
        int n3;
        long l2 = 0L;
        int n4 = -1;
        if (object instanceof String) {
            if (object.equals("NaN")) {
                object = new BigDecimal("1");
                l2 = 31L;
                n4 = 0;
            } else if (object.equals("-NaN")) {
                object = new BigDecimal("-1");
                l2 = 31L;
                n4 = 0;
            } else if (object.equals("SNaN")) {
                object = new BigDecimal("1");
                l2 = 31L;
                n4 = 1;
            } else if (object.equals("-SNaN")) {
                object = new BigDecimal("-1");
                l2 = 31L;
                n4 = 1;
            } else if (object.equals("Infinity")) {
                object = new BigDecimal("1");
                l2 = 30L;
            } else if (object.equals("-Infinity")) {
                object = new BigDecimal("-1");
                l2 = 30L;
            }
        }
        BigDecimal bigDecimal = (BigDecimal)object;
        int n5 = bigDecimal.signum();
        long l3 = bigDecimal.scale() * -1;
        String string = bigDecimal.abs().unscaledValue().toString();
        if (this.digits == 16) {
            long l4;
            int n6 = SQLDataFactory.getPrecisionForTruncation(bigDecimal, 16)[0];
            int n7 = 0;
            if (l3 > 368L && string.length() < 16) {
                n7 = 16 - string.length();
                string = string + "0000000000000000";
                string = string.substring(0, 16);
                n6 += n7;
                l3 -= (long)n7;
            }
            if (string.length() > n6) {
                l3 = string.length() - n6;
            }
            if (l3 + (long)(n6 - 1) > 384L) {
                throw new ExtendedIllegalArgumentException("numDecimalPositions (" + String.valueOf(l3 + (long)(n6 - 1)) + ")", 4);
            }
            if (l3 + (long)(n6 - 1) < -383L) {
                throw new ExtendedIllegalArgumentException("numDecimalPositions (" + String.valueOf(l3 + (long)(n6 - 1)) + ")", 4);
            }
            int[] nArray = new int[16];
            int n8 = 48;
            for (int i = 0; i < n6; ++i) {
                nArray[16 - n6 + i] = string.charAt(i) - n8;
            }
            long l5 = 0L;
            for (int i = 1; i < 16; i += 3) {
                l5 <<= 10;
                int n9 = AS400DecFloat.packDenselyPackedDecimal(nArray, i);
                l5 |= (long)n9;
            }
            l5 |= ((l3 += 398L) & 0xFFL) << 50;
            if (l2 != 0L) {
                l4 = l2;
            } else if (nArray[0] >= 8) {
                l4 = 24L;
                l4 |= (l3 & 0x300L) >> 7;
                l4 |= (long)(nArray[0] & 1);
            } else {
                l4 = 0L;
                l4 |= (l3 & 0x300L) >> 5;
                l4 |= (long)nArray[0];
            }
            l5 |= l4 << 58;
            if (n5 == -1) {
                l5 |= Long.MIN_VALUE;
            }
            byArray[n] = (byte)(l5 >> 56 & 0xFFL);
            byArray[n + 1] = (byte)(l5 >> 48 & 0xFFL);
            byArray[n + 2] = (byte)(l5 >> 40 & 0xFFL);
            byArray[n + 3] = (byte)(l5 >> 32 & 0xFFL);
            byArray[n + 4] = (byte)(l5 >> 24 & 0xFFL);
            byArray[n + 5] = (byte)(l5 >> 16 & 0xFFL);
            byArray[n + 6] = (byte)(l5 >> 8 & 0xFFL);
            byArray[n + 7] = (byte)(l5 & 0xFFL);
            if (n4 == 0) {
                int n10 = n;
                byArray[n10] = (byte)(byArray[n10] & 0xFD);
            } else if (n4 == 1) {
                int n11 = n;
                byArray[n11] = (byte)(byArray[n11] | 2);
            }
            return 8;
        }
        int n12 = SQLDataFactory.getPrecisionForTruncation(bigDecimal, 34)[0];
        int n13 = 0;
        if (l3 > 6110L && string.length() < 34) {
            n13 = 34 - string.length();
            string = string + "00000000000000000000000000000000";
            string = string.substring(0, 34);
            n12 += n13;
            l3 -= (long)n13;
        }
        if (string.length() > n12) {
            l3 = string.length() - n12;
        }
        if (l3 + (long)(n12 - 1) > 6144L) {
            throw new ExtendedIllegalArgumentException("numDecimalPositions (" + String.valueOf(l3 + (long)(n12 - 1)) + ")", 4);
        }
        if (l3 + (long)(n12 - 1) < -6143L) {
            throw new ExtendedIllegalArgumentException("numDecimalPositions (" + String.valueOf(l3 + (long)(n12 - 1)) + ")", 4);
        }
        int[] nArray = new int[34];
        int n14 = 48;
        for (int i = 0; i < n12; ++i) {
            nArray[34 - n12 + i] = string.charAt(i) - n14;
        }
        long l6 = 0L;
        long l7 = 0L;
        for (n3 = 1; n3 < 13; n3 += 3) {
            l6 <<= 10;
            n2 = AS400DecFloat.packDenselyPackedDecimal(nArray, n3);
            l6 |= (long)n2;
        }
        n2 = AS400DecFloat.packDenselyPackedDecimal(nArray, n3);
        l6 <<= 6;
        l6 |= (long)((n2 & 0x3F0) >> 4);
        l7 |= (long)(n2 & 0xF);
        n3 += 3;
        while (n3 < 34) {
            l7 <<= 10;
            n2 = AS400DecFloat.packDenselyPackedDecimal(nArray, n3);
            l7 |= (long)n2;
            n3 += 3;
        }
        l6 |= ((l3 += 6176L) & 0xFFFL) << 46;
        if (l2 != 0L) {
            l = l2;
        } else if (nArray[0] >= 8) {
            l = 24L;
            l |= (l3 & 0x3000L) >> 11;
            l |= (long)(nArray[0] & 1);
        } else {
            l = 0L;
            l |= (l3 & 0x3000L) >> 9;
            l |= (long)nArray[0];
        }
        l6 |= l << 58;
        if (n5 == -1) {
            l6 |= Long.MIN_VALUE;
        }
        byArray[n] = (byte)(l6 >> 56 & 0xFFL);
        byArray[n + 1] = (byte)(l6 >> 48 & 0xFFL);
        byArray[n + 2] = (byte)(l6 >> 40 & 0xFFL);
        byArray[n + 3] = (byte)(l6 >> 32 & 0xFFL);
        byArray[n + 4] = (byte)(l6 >> 24 & 0xFFL);
        byArray[n + 5] = (byte)(l6 >> 16 & 0xFFL);
        byArray[n + 6] = (byte)(l6 >> 8 & 0xFFL);
        byArray[n + 7] = (byte)(l6 & 0xFFL);
        byArray[n + 8] = (byte)(l7 >> 56 & 0xFFL);
        byArray[n + 9] = (byte)(l7 >> 48 & 0xFFL);
        byArray[n + 10] = (byte)(l7 >> 40 & 0xFFL);
        byArray[n + 11] = (byte)(l7 >> 32 & 0xFFL);
        byArray[n + 12] = (byte)(l7 >> 24 & 0xFFL);
        byArray[n + 13] = (byte)(l7 >> 16 & 0xFFL);
        byArray[n + 14] = (byte)(l7 >> 8 & 0xFFL);
        byArray[n + 15] = (byte)(l7 & 0xFFL);
        if (n4 == 0) {
            int n15 = n;
            byArray[n15] = (byte)(byArray[n15] & 0xFD);
        } else if (n4 == 1) {
            int n16 = n;
            byArray[n16] = (byte)(byArray[n16] | 2);
        }
        return 16;
    }

    public byte[] toBytes(double d) {
        byte[] byArray = new byte[this.digits == 16 ? 64 : 128];
        this.toBytes(d, byArray, 0);
        return byArray;
    }

    public int toBytes(double d, byte[] byArray) {
        return this.toBytes(d, byArray, 0);
    }

    public int toBytes(double d, byte[] byArray, int n) {
        BigDecimal bigDecimal = new BigDecimal(d);
        return this.toBytes(bigDecimal, byArray, n);
    }

    public double toDouble(byte[] byArray) {
        return this.toDouble(byArray, 0);
    }

    public double toDouble(byte[] byArray, int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n));
        }
        BigDecimal bigDecimal = (BigDecimal)this.toObject(byArray, n);
        return bigDecimal.doubleValue();
    }

    public Object toObject(byte[] byArray) {
        return this.toObject(byArray, 0);
    }

    public Object toObject(byte[] byArray, int n) {
        long l;
        int n2;
        int n3;
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n));
        }
        if (this.digits == 16) {
            long l2;
            int n4;
            int n5;
            long l3 = BinaryConverter.byteArrayToLong(byArray, n);
            long l4 = (l3 & 0x7C00000000000000L) >> 58;
            int n6 = n5 = (l3 & Long.MIN_VALUE) == Long.MIN_VALUE ? -1 : 1;
            if (l4 == 31L && n5 == 1) {
                long l5 = (l3 & 0x200000000000000L) >> 57;
                if (l5 == 1L) {
                    throw new ExtendedIllegalArgumentException("SNaN", 2);
                }
                throw new ExtendedIllegalArgumentException("NaN", 2);
            }
            if (l4 == 31L && n5 == -1) {
                long l6 = (l3 & 0x200000000000000L) >> 57;
                if (l6 == 1L) {
                    throw new ExtendedIllegalArgumentException("-SNaN", 2);
                }
                throw new ExtendedIllegalArgumentException("-NaN", 2);
            }
            if (l4 == 30L && n5 == 1) {
                throw new ExtendedIllegalArgumentException("Infinity", 2);
            }
            if (l4 == 30L && n5 == -1) {
                throw new ExtendedIllegalArgumentException("-Infinity", 2);
            }
            if ((l4 & 0x18L) == 24L) {
                n4 = (int)((l4 & 6L) >> 1);
                l2 = 8L + (l4 & 1L);
            } else {
                n4 = (int)((l4 & 0x18L) >> 3);
                l2 = l4 & 7L;
            }
            int n7 = (int)((l3 & 0x3FC000000000000L) >> 50);
            n7 |= n4 << 8;
            n7 -= 398;
            long l7 = l3 & 0x3FFFFFFFFFFFFL;
            int n8 = AS400DecFloat.decFloatBitsToDigits((int)(l7 & 0x3FFFFFFFL));
            int n9 = AS400DecFloat.decFloatBitsToDigits((int)(l7 >> 30 & 0xFFFFFL));
            n9 = (int)((long)n9 + l2 * 1000000L);
            int[] nArray = AS400DecFloat.computeMagnitude(new int[]{n9, n8});
            byte[] byArray2 = new byte[]{(byte)(nArray[0] >>> 24), (byte)(nArray[0] >>> 16), (byte)(nArray[0] >>> 8), (byte)nArray[0], (byte)(nArray[1] >>> 24), (byte)(nArray[1] >>> 16), (byte)(nArray[1] >>> 8), (byte)nArray[1]};
            BigInteger bigInteger = new BigInteger(n5, byArray2);
            return AS400DecFloat.getNewBigDecimal(bigInteger, -n7);
        }
        long l8 = BinaryConverter.byteArrayToLong(byArray, n);
        long l9 = BinaryConverter.byteArrayToLong(byArray, n + 8);
        long l10 = (l8 & 0x7C00000000000000L) >> 58;
        int n10 = n3 = (l8 & Long.MIN_VALUE) == Long.MIN_VALUE ? -1 : 1;
        if (l10 == 31L && n3 == 1) {
            long l11 = (l8 & 0x200000000000000L) >> 57;
            if (l11 == 1L) {
                throw new ExtendedIllegalArgumentException("SNaN", 2);
            }
            throw new ExtendedIllegalArgumentException("NaN", 2);
        }
        if (l10 == 31L && n3 == -1) {
            long l12 = (l8 & 0x200000000000000L) >> 57;
            if (l12 == 1L) {
                throw new ExtendedIllegalArgumentException("-SNaN", 2);
            }
            throw new ExtendedIllegalArgumentException("-NaN", 2);
        }
        if (l10 == 30L && n3 == 1) {
            throw new ExtendedIllegalArgumentException("Infinity", 2);
        }
        if (l10 == 30L && n3 == -1) {
            throw new ExtendedIllegalArgumentException("-Infinity", 2);
        }
        if ((l10 & 0x18L) == 24L) {
            n2 = (int)((l10 & 6L) >> 1);
            l = 8L + (l10 & 1L);
        } else {
            n2 = (int)((l10 & 0x18L) >> 3);
            l = l10 & 7L;
        }
        int n11 = (int)((l8 & 0x3FFC00000000000L) >> 46);
        n11 |= n2 << 12;
        n11 -= 6176;
        int n12 = AS400DecFloat.decFloatBitsToDigits((int)(l9 & 0x3FFFFFFFL));
        int n13 = AS400DecFloat.decFloatBitsToDigits((int)(l9 >> 30 & 0x3FFFFFFFL));
        int n14 = AS400DecFloat.decFloatBitsToDigits((int)((l8 & 0x3FFFFFFL) << 4 | l9 >> 60 & 0xFL));
        int n15 = AS400DecFloat.decFloatBitsToDigits((int)(l8 >> 26 & 0xFFFFFL));
        n15 = (int)((long)n15 + l * 1000000L);
        int[] nArray = AS400DecFloat.computeMagnitude(new int[]{n15, n14, n13, n12});
        byte[] byArray3 = new byte[]{(byte)(nArray[0] >>> 24), (byte)(nArray[0] >>> 16), (byte)(nArray[0] >>> 8), (byte)nArray[0], (byte)(nArray[1] >>> 24), (byte)(nArray[1] >>> 16), (byte)(nArray[1] >>> 8), (byte)nArray[1], (byte)(nArray[2] >>> 24), (byte)(nArray[2] >>> 16), (byte)(nArray[2] >>> 8), (byte)nArray[2], (byte)(nArray[3] >>> 24), (byte)(nArray[3] >>> 16), (byte)(nArray[3] >>> 8), (byte)nArray[3]};
        BigInteger bigInteger = new BigInteger(n3, byArray3);
        return AS400DecFloat.getNewBigDecimal(bigInteger, -n11);
    }

    static final String byteToString(int n) {
        int n2 = n >>> 4 & 0xF;
        int n3 = n & 0xF;
        char[] cArray = new char[]{n2 < 10 ? (char)(48 + n2) : (char)(n2 - 10 + 65), n3 < 10 ? (char)(48 + n3) : (char)(n3 - 10 + 65)};
        return new String(cArray);
    }

    private static int packDenselyPackedDecimal(int[] nArray, int n) {
        int n2 = 0;
        int n3 = (nArray[n + 0] & 8) >> 1 | (nArray[n + 1] & 8) >> 2 | (nArray[n + 2] & 8) >> 3;
        switch (n3) {
            case 0: {
                n2 = nArray[n + 0] << 7 | nArray[n + 1] << 4 | nArray[n + 2];
                break;
            }
            case 1: {
                n2 = nArray[n + 0] << 7 | nArray[n + 1] << 4 | nArray[n + 2] & 1 | 8;
                break;
            }
            case 2: {
                n2 = nArray[n + 0] << 7 | (nArray[n + 2] & 6) << 4 | (nArray[n + 1] & 1) << 4 | nArray[n + 2] & 1 | 0xA;
                break;
            }
            case 3: {
                n2 = nArray[n + 0] << 7 | (nArray[n + 1] & 1) << 4 | nArray[n + 2] & 1 | 0x4E;
                break;
            }
            case 4: {
                n2 = (nArray[n + 2] & 6) << 7 | (nArray[n + 0] & 1) << 7 | nArray[n + 1] << 4 | nArray[n + 2] & 1 | 0xC;
                break;
            }
            case 5: {
                n2 = (nArray[n + 1] & 6) << 7 | (nArray[n + 0] & 1) << 7 | (nArray[n + 1] & 1) << 4 | nArray[n + 2] & 1 | 0x2E;
                break;
            }
            case 6: {
                n2 = (nArray[n + 2] & 6) << 7 | (nArray[n + 0] & 1) << 7 | (nArray[n + 1] & 1) << 4 | nArray[n + 2] & 1 | 0xE;
                break;
            }
            case 7: {
                n2 = (nArray[n + 0] & 1) << 7 | (nArray[n + 1] & 1) << 4 | nArray[n + 2] & 1 | 0x6E;
            }
        }
        return n2;
    }

    private static int unpackDenselyPackedDecimal(int n) {
        int n2 = (n & 0xE) == 14 ? (n & 0x60) >> 5 | 4 : ((n & 8) == 8 ? (~n & 6) >> 1 : 0);
        int n3 = 0;
        switch (n2) {
            case 0: {
                n3 = (n & 0x380) << 1 | n & 0x77;
                break;
            }
            case 1: {
                n3 = (n & 0x80) << 1 | n & 0x71 | (n & 0x300) >> 7 | 0x800;
                break;
            }
            case 2: {
                n3 = (n & 0x380) << 1 | n & 0x11 | (n & 0x60) >> 4 | 0x80;
                break;
            }
            case 3: {
                n3 = (n & 0x380) << 1 | n & 0x71 | 8;
                break;
            }
            case 4: {
                n3 = (n & 0x80) << 1 | n & 0x11 | (n & 0x300) >> 7 | 0x880;
                break;
            }
            case 5: {
                n3 = (n & 0x80) << 1 | n & 0x11 | (n & 0x300) >> 3 | 0x808;
                break;
            }
            case 6: {
                n3 = (n & 0x380) << 1 | n & 0x11 | 0x88;
                break;
            }
            case 7: {
                n3 = (n & 0x80) << 1 | n & 0x11 | 0x888;
            }
        }
        return ((n3 & 0xF00) >> 8) * 100 + ((n3 & 0xF0) >> 4) * 10 + (n3 & 0xF);
    }

    private static final int[] computeMagnitude(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        nArray2[n - 1] = nArray[n - 1];
        for (int i = 0; i < n - 1; ++i) {
            int n2 = 0;
            int n3 = tenRadixMagnitude[i].length - 1;
            int n4 = n - 1;
            while (n3 >= 0) {
                long l = ((long)nArray[n - 2 - i] & 0xFFFFFFFFL) * ((long)tenRadixMagnitude[i][n3] & 0xFFFFFFFFL) + ((long)nArray2[n4] & 0xFFFFFFFFL) + ((long)n2 & 0xFFFFFFFFL);
                n2 = (int)(l >>> 32);
                nArray2[n4] = (int)(l & 0xFFFFFFFFL);
                --n3;
                --n4;
            }
            nArray2[n4] = n2;
        }
        return nArray2;
    }

    private static final int decFloatBitsToDigits(int n) {
        int n2 = 0;
        for (int i = 2; i >= 0; --i) {
            n2 *= 1000;
            n2 += AS400DecFloat.unpackDenselyPackedDecimal((int)((long)(n >> i * 10) & 0x3FFL));
        }
        return n2;
    }

    private static BigDecimal roundByModePreJDK5(BigInteger bigInteger, int n, int n2, String string) {
        BigInteger bigInteger2 = null;
        bigInteger2 = n2 == 16 ? new BigInteger("10000000000000000") : new BigInteger("10000000000000000000000000000000000");
        BigInteger bigInteger3 = bigInteger2.negate();
        if (bigInteger2 != null && bigInteger.compareTo(bigInteger2) < 0 && bigInteger.compareTo(bigInteger3) > 0) {
            return AS400DecFloat.getNewBigDecimal(bigInteger, n);
        }
        int[] nArray = SQLDataFactory.getPrecisionForTruncation(AS400DecFloat.getNewBigDecimal(bigInteger, n), n2);
        int n3 = nArray[0];
        int n4 = nArray[1];
        if (n4 != 0) {
            bigInteger = bigInteger.divide(new BigInteger("10").pow(n4));
        }
        int n5 = n3 - n2;
        BigDecimal bigDecimal = AS400DecFloat.roundOffDigits(bigInteger, n, string, n5);
        if (n4 != 0) {
            bigDecimal = bigDecimal.movePointRight(n4);
        }
        return bigDecimal;
    }

    private static BigDecimal roundOffDigits(BigInteger bigInteger, int n, String string, int n2) {
        BigDecimal bigDecimal = new BigDecimal(new BigInteger("10").pow(n2), 0);
        BigDecimal bigDecimal2 = AS400DecFloat.getNewBigDecimal(bigInteger, n);
        int n3 = 0;
        try {
            n3 = (Integer)Class.forName("java.math.BigDecimal").getDeclaredField(string).get(null);
        }
        catch (Exception exception) {
            throw new InternalErrorException(6);
        }
        BigDecimal bigDecimal3 = bigDecimal2.divide(bigDecimal, n, n3);
        BigInteger bigInteger2 = bigDecimal3.unscaledValue();
        bigDecimal3 = AS400DecFloat.getNewBigDecimal(bigInteger2, n - n2);
        return bigDecimal3;
    }

    private static BigDecimal getNewBigDecimal(BigInteger bigInteger, int n) {
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = new BigDecimal(bigInteger, n);
        }
        catch (NumberFormatException numberFormatException) {
            if (n > 0) {
                throw numberFormatException;
            }
            bigDecimal = new BigDecimal(bigInteger);
            bigDecimal = bigDecimal.movePointRight(-n);
        }
        return bigDecimal;
    }

    public static BigDecimal roundByMode(BigDecimal bigDecimal, int n, String string) {
        BigDecimal bigDecimal2 = null;
        boolean bl = true;
        try {
            Class<?> clazz = Class.forName("java.math.MathContext");
            Constructor<?> constructor = clazz.getConstructor(Integer.TYPE, Class.forName("java.math.RoundingMode"));
            Object[] objectArray = new Object[]{new Integer(n), Class.forName("java.math.RoundingMode").getDeclaredField(string.substring(6)).get(null)};
            Object obj = constructor.newInstance(objectArray);
            Object[] objectArray2 = new Object[]{obj};
            Class[] classArray = new Class[]{Class.forName("java.math.MathContext")};
            Method method = (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = AS400DecFloat.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getDeclaredMethod("round", classArray);
            bigDecimal2 = (BigDecimal)method.invoke((Object)bigDecimal, objectArray2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            bl = false;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            bl = false;
        }
        catch (IllegalAccessException illegalAccessException) {
            bl = false;
        }
        catch (InvocationTargetException invocationTargetException) {
            bl = false;
        }
        catch (InstantiationException instantiationException) {
            bl = false;
        }
        if (!bl) {
            bigDecimal2 = AS400DecFloat.roundByModePreJDK5(bigDecimal.unscaledValue(), bigDecimal.scale(), n, string);
        }
        return bigDecimal2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

