/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import java.io.Serializable;

final class IFSObjAttrs2
implements Serializable {
    static final long serialVersionUID = 4L;
    private byte[] data_;

    IFSObjAttrs2(byte[] byArray) {
        this.data_ = byArray;
    }

    final int getCCSID(int n) {
        int n2 = IFSObjAttrs2.determineCCSIDOffset(n);
        return BinaryConverter.byteArrayToShort(this.data_, n2) & 0xFFFF;
    }

    final void setCCSID(int n, int n2) {
        int n3 = IFSObjAttrs2.determineCCSIDOffset(n2);
        byte[] byArray = BinaryConverter.shortToByteArray((short)n);
        System.arraycopy(byArray, 0, this.data_, n3, 2);
    }

    final byte[] getData() {
        return this.data_;
    }

    final int getLength() {
        return this.data_.length;
    }

    final long getOwnerUID() {
        return (long)BinaryConverter.byteArrayToInt(this.data_, 64) & 0xFFFFFFFFL;
    }

    static final int determineCCSIDOffset(int n) {
        int n2;
        switch (n) {
            case 0: {
                n2 = 126;
                break;
            }
            case 62708: {
                n2 = 142;
                break;
            }
            default: {
                n2 = 134;
            }
        }
        return n2;
    }

    final int length() {
        return this.data_.length;
    }
}

