/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.resource.RQueuedMessage;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.MessageUtilities;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.ResourceProperties;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VResourcePropertiesPane;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.Icon;

public class VJobLogMessage
implements VObject,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String description_ = ResourceLoader.getText("JOB_LOG_MESSAGE_DESCRIPTION");
    private static final Icon icon16_ = ResourceLoader.getIcon("VMessage16.gif", description_);
    private static final Icon icon32_ = ResourceLoader.getIcon("VMessage32.gif", description_);
    private RQueuedMessage message_ = null;
    private transient VPropertiesPane propertiesPane_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient VObjectEventSupport objectEventSupport_;
    private transient WorkingEventSupport workingEventSupport_;
    public static final Object DATE_PROPERTY = "Date";
    public static final Object FROM_PROGRAM_PROPERTY = "From program";
    public static final Object ID_PROPERTY = "ID";
    public static final Object SEVERITY_PROPERTY = "Severity";
    public static final Object TEXT_PROPERTY = "Text";
    public static final Object TYPE_PROPERTY = "Type";
    private static final Hashtable map_ = new Hashtable();
    private static ResourceProperties properties_;

    VJobLogMessage(RQueuedMessage rQueuedMessage) {
        if (rQueuedMessage == null) {
            throw new NullPointerException("message");
        }
        this.message_ = rQueuedMessage;
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public VAction[] getActions() {
        return null;
    }

    public VAction getDefaultAction() {
        return null;
    }

    public Icon getIcon(int n, boolean bl) {
        if (n == 32) {
            return icon32_;
        }
        return icon16_;
    }

    public VPropertiesPane getPropertiesPane() {
        return this.propertiesPane_;
    }

    public Object getPropertyValue(Object object) {
        Object object2;
        if (object == VObject.NAME_PROPERTY) {
            return this;
        }
        if (object == VObject.DESCRIPTION_PROPERTY) {
            return description_;
        }
        if (object == null) {
            return null;
        }
        Object v = map_.get(object);
        if (v == null) {
            return null;
        }
        try {
            object2 = this.message_.getAttributeValue(v);
        }
        catch (ResourceException resourceException) {
            this.errorEventSupport_.fireError(resourceException);
            return null;
        }
        if (object == TYPE_PROPERTY) {
            return MessageUtilities.getTypeText((Integer)object2);
        }
        return object2;
    }

    public String getText() {
        try {
            return (String)this.message_.getAttributeValue("MESSAGE_ID");
        }
        catch (ResourceException resourceException) {
            return "";
        }
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.propertiesPane_ = new VResourcePropertiesPane(this, this.message_, properties_);
        this.propertiesPane_.addErrorListener(this.errorEventSupport_);
        this.propertiesPane_.addVObjectListener(this.objectEventSupport_);
        this.propertiesPane_.addWorkingListener(this.workingEventSupport_);
    }

    public void load() {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    public String toString() {
        return this.getText();
    }

    static {
        map_.put(DATE_PROPERTY, "DATE_SENT");
        map_.put(FROM_PROGRAM_PROPERTY, "SENDING_PROGRAM_NAME");
        map_.put(ID_PROPERTY, "MESSAGE_ID");
        map_.put(SEVERITY_PROPERTY, "MESSAGE_SEVERITY");
        map_.put(TEXT_PROPERTY, "MESSAGE_TEXT");
        map_.put(TYPE_PROPERTY, "MESSAGE_TYPE");
        properties_ = null;
        properties_ = new ResourceProperties();
        properties_.addProperties(new Object[]{"MESSAGE_TEXT", "MESSAGE_HELP", "MESSAGE_SEVERITY", "MESSAGE_TYPE", "DATE_SENT", "SENDING_PROGRAM_NAME"});
    }
}

