/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.standardizephonenumber;

import com.google.i18n.phonenumbers.PhoneNumberUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.standardizephonenumber.StandardizePhoneField;
import org.apache.hop.pipeline.transforms.standardizephonenumber.StandardizePhoneNumber;
import org.apache.hop.pipeline.transforms.standardizephonenumber.StandardizePhoneNumberData;

@Transform(id="StandardizePhoneNumber", image="standardizephonenumber.svg", name="i18n::StandardizePhoneNumber.Name", description="i18n::StandardizePhoneNumber.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.DataQuality", documentationUrl="/pipeline/transforms/standardizephonenumber.html")
public class StandardizePhoneNumberMeta
extends BaseTransformMeta<StandardizePhoneNumber, StandardizePhoneNumberData>
implements Serializable {
    private static final Class<?> PKG = StandardizePhoneNumberMeta.class;
    private static final Set<PhoneNumberUtil.PhoneNumberFormat> SUPPORTED_FORMATS = EnumSet.of(PhoneNumberUtil.PhoneNumberFormat.E164, PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL, PhoneNumberUtil.PhoneNumberFormat.NATIONAL, PhoneNumberUtil.PhoneNumberFormat.RFC3966);
    @HopMetadataProperty(key="field", groupKey="fields", injectionGroupDescription="StandardizePhoneNumber.Injection.Fields", injectionKeyDescription="StandardizePhoneNumber.Injection.Field")
    private List<StandardizePhoneField> fields = new ArrayList<StandardizePhoneField>();

    public StandardizePhoneNumberMeta() {
    }

    public StandardizePhoneNumberMeta(StandardizePhoneNumberMeta meta) {
        for (StandardizePhoneField field : meta.getFields()) {
            this.fields.add(new StandardizePhoneField(field));
        }
    }

    public Object clone() {
        return new StandardizePhoneNumberMeta(this);
    }

    public void setDefault() {
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        try {
            for (StandardizePhoneField standardize : this.getFields()) {
                int index = inputRowMeta.indexOfValue(standardize.getInputField());
                IValueMeta valueMeta = inputRowMeta.getValueMeta(index);
                if (!Utils.isEmpty((CharSequence)standardize.getOutputField()) && !standardize.getOutputField().equals(standardize.getInputField())) {
                    valueMeta = ValueMetaFactory.createValueMeta((String)standardize.getOutputField(), (int)2);
                    inputRowMeta.addValueMeta(valueMeta);
                }
                valueMeta.setOrigin(name);
                if (!Utils.isEmpty((CharSequence)standardize.getNumberTypeField())) {
                    valueMeta = ValueMetaFactory.createValueMeta((String)standardize.getNumberTypeField(), (int)2);
                    valueMeta.setOrigin(name);
                    inputRowMeta.addValueMeta(valueMeta);
                }
                if (Utils.isEmpty((CharSequence)standardize.getIsValidNumberField())) continue;
                valueMeta = ValueMetaFactory.createValueMeta((String)standardize.getIsValidNumberField(), (int)4);
                valueMeta.setOrigin(name);
                inputRowMeta.addValueMeta(valueMeta);
            }
        }
        catch (Exception e) {
            throw new HopTransformException((Throwable)e);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (prev == null || prev.size() == 0) {
            remarks.add((ICheckResult)new CheckResult(3, BaseMessages.getString(PKG, (String)"StandardizePhoneNumberMeta.CheckResult.NotReceivingFieldsFromPreviousTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta));
        } else {
            remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"StandardizePhoneNumberMeta.CheckResult.ReceivingFieldsFromPreviousTransforms", (Object[])new Object[]{prev.size()}), (ICheckResultSource)transformMeta));
        }
        if (input.length > 0) {
            remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"StandardizePhoneNumberMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta));
            for (StandardizePhoneField standardize : this.fields) {
                String message;
                IValueMeta valueMeta = null;
                if (prev != null) {
                    valueMeta = prev.searchValueMeta(standardize.getInputField());
                }
                if (valueMeta == null) {
                    message = BaseMessages.getString(PKG, (String)"StandardizePhoneNumberMeta.CheckResult.MissingInputField", (String[])new String[]{Const.NVL((String)standardize.getInputField(), (String)standardize.getOutputField())});
                    remarks.add((ICheckResult)new CheckResult(4, message, (ICheckResultSource)transformMeta));
                }
                if (prev != null) {
                    valueMeta = prev.searchValueMeta(standardize.getCountryField());
                }
                if (valueMeta != null) continue;
                message = BaseMessages.getString(PKG, (String)"StandardizePhoneNumberMeta.CheckResult.MissingCountryField", (String[])new String[]{standardize.getCountryField()});
                remarks.add((ICheckResult)new CheckResult(4, message, (ICheckResultSource)transformMeta));
            }
        } else {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"StandardizePhoneNumberMeta.CheckResult.NotReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta));
        }
    }

    public String[] getSupportedFormats() {
        ArrayList<String> result = new ArrayList<String>();
        for (PhoneNumberUtil.PhoneNumberFormat format : SUPPORTED_FORMATS) {
            result.add(format.name());
        }
        return result.toArray(new String[result.size()]);
    }

    public String[] getSupportedCountries() {
        PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
        ArrayList<String> result = new ArrayList<String>();
        for (String region : phoneUtil.getSupportedRegions()) {
            result.add(region);
        }
        return Const.sortStrings((String[])result.toArray(new String[0]));
    }

    public List<StandardizePhoneField> getFields() {
        return this.fields;
    }

    public void setFields(List<StandardizePhoneField> standardizes) {
        this.fields = standardizes;
    }
}

