/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.janino;

import java.util.Objects;
import org.apache.hop.core.Const;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.xml.XmlHandler;
import org.w3c.dom.Node;

public class JaninoMetaFunction
implements Cloneable {
    public static final String XML_TAG = "formula";
    @Injection(name="FIELD_NAME", group="FORMULA")
    private String fieldName;
    @Injection(name="FIELD_FORMULA", group="FORMULA")
    private String formula;
    private int valueType;
    @Injection(name="VALUE_LENGTH", group="FORMULA")
    private int valueLength;
    @Injection(name="VALUE_PRECISION", group="FORMULA")
    private int valuePrecision;
    @Injection(name="REPLACE_FIELD", group="FORMULA")
    private String replaceField;

    public JaninoMetaFunction() {
    }

    public JaninoMetaFunction(String fieldName, String formula, int valueType, int valueLength, int valuePrecision, String replaceField) {
        this.fieldName = fieldName;
        this.formula = formula;
        this.valueType = valueType;
        this.valueLength = valueLength;
        this.valuePrecision = valuePrecision;
        this.replaceField = replaceField;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            JaninoMetaFunction mf = (JaninoMetaFunction)obj;
            return this.getXml().equals(mf.getXml());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.formula, this.valueType, this.valueLength, this.valuePrecision, this.replaceField);
    }

    public Object clone() {
        try {
            JaninoMetaFunction retval = (JaninoMetaFunction)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder();
        xml.append(XmlHandler.openTag((String)XML_TAG));
        xml.append(XmlHandler.addTagValue((String)"field_name", (String)this.fieldName));
        xml.append(XmlHandler.addTagValue((String)"formula_string", (String)this.formula));
        xml.append(XmlHandler.addTagValue((String)"value_type", (String)ValueMetaFactory.getValueMetaName((int)this.valueType)));
        xml.append(XmlHandler.addTagValue((String)"value_length", (int)this.valueLength));
        xml.append(XmlHandler.addTagValue((String)"value_precision", (int)this.valuePrecision));
        xml.append(XmlHandler.addTagValue((String)"replace_field", (String)this.replaceField));
        xml.append(XmlHandler.closeTag((String)XML_TAG));
        return xml.toString();
    }

    public JaninoMetaFunction(Node calcnode) {
        this.fieldName = XmlHandler.getTagValue((Node)calcnode, (String)"field_name");
        this.formula = XmlHandler.getTagValue((Node)calcnode, (String)"formula_string");
        this.valueType = ValueMetaFactory.getIdForValueMeta((String)XmlHandler.getTagValue((Node)calcnode, (String)"value_type"));
        this.valueLength = Const.toInt((String)XmlHandler.getTagValue((Node)calcnode, (String)"value_length"), (int)-1);
        this.valuePrecision = Const.toInt((String)XmlHandler.getTagValue((Node)calcnode, (String)"value_precision"), (int)-1);
        this.replaceField = XmlHandler.getTagValue((Node)calcnode, (String)"replace_field");
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public int getValueLength() {
        return this.valueLength;
    }

    public void setValueLength(int valueLength) {
        this.valueLength = valueLength;
    }

    public int getValuePrecision() {
        return this.valuePrecision;
    }

    public void setValuePrecision(int valuePrecision) {
        this.valuePrecision = valuePrecision;
    }

    public int getValueType() {
        return this.valueType;
    }

    public void setValueType(int valueType) {
        this.valueType = valueType;
    }

    @Injection(name="VALUE_TYPE", group="FORMULA")
    public void setValueType(String typeDesc) {
        this.valueType = ValueMetaFactory.getIdForValueMeta((String)typeDesc);
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getReplaceField() {
        return this.replaceField;
    }

    public void setReplaceField(String replaceField) {
        this.replaceField = replaceField;
    }
}

