/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteArrayAccessor;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.memory.ByteBufferCloner;

public interface ClusteringBoundOrBoundary<V>
extends ClusteringPrefix<V> {
    public static final Serializer serializer = new Serializer();

    default public boolean isBoundary() {
        return this.kind().isBoundary();
    }

    default public boolean isOpen(boolean reversed) {
        return this.kind().isOpen(reversed);
    }

    default public boolean isClose(boolean reversed) {
        return this.kind().isClose(reversed);
    }

    default public ClusteringBoundOrBoundary<ByteBuffer> clone(ByteBufferCloner cloner) {
        ByteBuffer[] newValues = new ByteBuffer[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            newValues[i] = cloner.clone(this.get(i), this.accessor());
        }
        return ByteBufferAccessor.instance.factory().boundOrBoundary(this.kind(), (ByteBuffer[])newValues);
    }

    @Override
    default public String toString(TableMetadata metadata) {
        return this.toString(metadata.comparator);
    }

    default public String toString(ClusteringComparator comparator) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.kind()).append('(');
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(comparator.subtype(i).getString(this.get(i), this.accessor()));
        }
        return sb.append(')').toString();
    }

    public ClusteringBoundOrBoundary<V> invert();

    public static class Serializer {
        public <T> void serialize(ClusteringBoundOrBoundary<T> bound, DataOutputPlus out, int version, List<AbstractType<?>> types) throws IOException {
            out.writeByte(bound.kind().ordinal());
            out.writeShort(bound.size());
            ClusteringPrefix.serializer.serializeValuesWithoutSize(bound, out, version, types);
        }

        public <T> long serializedSize(ClusteringBoundOrBoundary<T> bound, int version, List<AbstractType<?>> types) {
            return (long)(1 + TypeSizes.sizeof((short)bound.size())) + ClusteringPrefix.serializer.valuesWithoutSizeSerializedSize(bound, version, types);
        }

        public ClusteringBoundOrBoundary<byte[]> deserialize(DataInputPlus in, int version, List<AbstractType<?>> types) throws IOException {
            ClusteringPrefix.Kind kind = ClusteringPrefix.Kind.values()[in.readByte()];
            return this.deserializeValues(in, kind, version, types);
        }

        public void skipValues(DataInputPlus in, ClusteringPrefix.Kind kind, int version, List<AbstractType<?>> types) throws IOException {
            int size = in.readUnsignedShort();
            if (size == 0) {
                return;
            }
            ClusteringPrefix.serializer.skipValuesWithoutSize(in, size, version, types);
        }

        public ClusteringBoundOrBoundary<byte[]> deserializeValues(DataInputPlus in, ClusteringPrefix.Kind kind, int version, List<AbstractType<?>> types) throws IOException {
            int size = in.readUnsignedShort();
            if (size == 0) {
                return ByteArrayAccessor.factory.bound(kind);
            }
            byte[][] values = ClusteringPrefix.serializer.deserializeValuesWithoutSize(in, size, version, types);
            return ByteArrayAccessor.factory.boundOrBoundary(kind, (V[])values);
        }
    }
}

