/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool.stats;

import java.io.PrintStream;
import java.util.List;
import org.apache.cassandra.tools.nodetool.stats.StatsHolder;
import org.apache.cassandra.tools.nodetool.stats.StatsKeyspace;
import org.apache.cassandra.tools.nodetool.stats.StatsPrinter;
import org.apache.cassandra.tools.nodetool.stats.StatsTable;
import org.apache.cassandra.tools.nodetool.stats.TableStatsHolder;
import org.apache.cassandra.utils.FBUtilities;

public class TableStatsPrinter<T extends StatsHolder> {
    public static <T extends StatsHolder> StatsPrinter<T> from(String format, boolean sorted) {
        switch (format) {
            case "json": {
                return new StatsPrinter.JsonPrinter();
            }
            case "yaml": {
                return new StatsPrinter.YamlPrinter();
            }
        }
        if (sorted) {
            return new SortedDefaultPrinter();
        }
        return new DefaultPrinter();
    }

    private static class SortedDefaultPrinter
    extends DefaultPrinter {
        private SortedDefaultPrinter() {
        }

        @Override
        public void print(TableStatsHolder data, PrintStream out) {
            List<StatsTable> tables = data.getSortedFilteredTables();
            String totalTablesSummary = String.format("Total number of tables: %d", data.numberOfTables);
            if (data.top > 0) {
                int k = data.top <= data.numberOfTables ? data.top : data.numberOfTables;
                totalTablesSummary = totalTablesSummary + String.format(" (showing top %d by %s)", k, data.sortKey);
            }
            out.println(totalTablesSummary);
            out.println("----------------");
            for (StatsTable table : tables) {
                this.printStatsTable(table, table.keyspaceName + "." + table.tableName, "\t", out);
            }
            out.println("----------------");
        }
    }

    private static class DefaultPrinter
    implements StatsPrinter<TableStatsHolder> {
        private DefaultPrinter() {
        }

        @Override
        public void print(TableStatsHolder data, PrintStream out) {
            out.println("Total number of tables: " + data.numberOfTables);
            out.println("----------------");
            List<StatsKeyspace> keyspaces = data.keyspaces;
            for (StatsKeyspace keyspace : keyspaces) {
                out.println("Keyspace : " + keyspace.name);
                out.println("\tRead Count: " + keyspace.readCount);
                out.println("\tRead Latency: " + keyspace.readLatency() + " ms");
                out.println("\tWrite Count: " + keyspace.writeCount);
                out.println("\tWrite Latency: " + keyspace.writeLatency() + " ms");
                out.println("\tPending Flushes: " + keyspace.pendingFlushes);
                List<StatsTable> tables = keyspace.tables;
                for (StatsTable table : tables) {
                    this.printStatsTable(table, table.tableName, "\t\t", out);
                }
                out.println("----------------");
            }
        }

        protected void printStatsTable(StatsTable table, String tableDisplayName, String indent, PrintStream out) {
            out.println(indent + "Table" + (table.isIndex ? " (index): " : ": ") + tableDisplayName);
            out.println(indent + "SSTable count: " + table.sstableCount);
            out.println(indent + "Old SSTable count: " + table.oldSSTableCount);
            if (table.isLeveledSstable) {
                out.println(indent + "SSTables in each level: [" + String.join((CharSequence)", ", table.sstablesInEachLevel) + "]");
            }
            out.println(indent + "Space used (live): " + table.spaceUsedLive);
            out.println(indent + "Space used (total): " + table.spaceUsedTotal);
            out.println(indent + "Space used by snapshots (total): " + table.spaceUsedBySnapshotsTotal);
            if (table.offHeapUsed) {
                out.println(indent + "Off heap memory used (total): " + table.offHeapMemoryUsedTotal);
            }
            out.println(indent + "SSTable Compression Ratio: " + table.sstableCompressionRatio);
            out.println(indent + "Number of partitions (estimate): " + table.numberOfPartitionsEstimate);
            out.println(indent + "Memtable cell count: " + table.memtableCellCount);
            out.println(indent + "Memtable data size: " + table.memtableDataSize);
            if (table.memtableOffHeapUsed) {
                out.println(indent + "Memtable off heap memory used: " + table.memtableOffHeapMemoryUsed);
            }
            out.println(indent + "Memtable switch count: " + table.memtableSwitchCount);
            out.println(indent + "Local read count: " + table.localReadCount);
            out.printf(indent + "Local read latency: %01.3f ms%n", table.localReadLatencyMs);
            out.println(indent + "Local write count: " + table.localWriteCount);
            out.printf(indent + "Local write latency: %01.3f ms%n", table.localWriteLatencyMs);
            out.println(indent + "Pending flushes: " + table.pendingFlushes);
            out.println(indent + "Percent repaired: " + table.percentRepaired);
            out.println(indent + "Bytes repaired: " + FBUtilities.prettyPrintMemory(table.bytesRepaired));
            out.println(indent + "Bytes unrepaired: " + FBUtilities.prettyPrintMemory(table.bytesUnrepaired));
            out.println(indent + "Bytes pending repair: " + FBUtilities.prettyPrintMemory(table.bytesPendingRepair));
            out.println(indent + "Bloom filter false positives: " + table.bloomFilterFalsePositives);
            out.printf(indent + "Bloom filter false ratio: %01.5f%n", table.bloomFilterFalseRatio);
            out.println(indent + "Bloom filter space used: " + table.bloomFilterSpaceUsed);
            if (table.bloomFilterOffHeapUsed) {
                out.println(indent + "Bloom filter off heap memory used: " + table.bloomFilterOffHeapMemoryUsed);
            }
            if (table.indexSummaryOffHeapUsed) {
                out.println(indent + "Index summary off heap memory used: " + table.indexSummaryOffHeapMemoryUsed);
            }
            if (table.compressionMetadataOffHeapUsed) {
                out.println(indent + "Compression metadata off heap memory used: " + table.compressionMetadataOffHeapMemoryUsed);
            }
            out.println(indent + "Compacted partition minimum bytes: " + table.compactedPartitionMinimumBytes);
            out.println(indent + "Compacted partition maximum bytes: " + table.compactedPartitionMaximumBytes);
            out.println(indent + "Compacted partition mean bytes: " + table.compactedPartitionMeanBytes);
            out.println(indent + "Average live cells per slice (last five minutes): " + table.averageLiveCellsPerSliceLastFiveMinutes);
            out.println(indent + "Maximum live cells per slice (last five minutes): " + table.maximumLiveCellsPerSliceLastFiveMinutes);
            out.println(indent + "Average tombstones per slice (last five minutes): " + table.averageTombstonesPerSliceLastFiveMinutes);
            out.println(indent + "Maximum tombstones per slice (last five minutes): " + table.maximumTombstonesPerSliceLastFiveMinutes);
            out.println(indent + "Dropped Mutations: " + table.droppedMutations);
            out.printf(indent + "Droppable tombstone ratio: %01.5f%n", table.droppableTombstoneRatio);
            if (table.isInCorrectLocation != null) {
                out.println(indent + "SSTables in correct location: " + table.isInCorrectLocation);
            }
            out.println("");
        }
    }
}

