/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import com.google.common.collect.ImmutableMap;
import java.net.InetAddress;
import java.util.Map;
import org.apache.cassandra.transport.ProtocolVersion;

public final class ClientStat {
    public static final String INET_ADDRESS = "inetAddress";
    public static final String PROTOCOL_VERSION = "protocolVersion";
    public static final String LAST_SEEN_TIME = "lastSeenTime";
    final InetAddress remoteAddress;
    final ProtocolVersion protocolVersion;
    final long lastSeenTime;

    ClientStat(InetAddress remoteAddress, ProtocolVersion protocolVersion, long lastSeenTime) {
        this.remoteAddress = remoteAddress;
        this.lastSeenTime = lastSeenTime;
        this.protocolVersion = protocolVersion;
    }

    public String toString() {
        return String.format("ClientStat{%s, %s, %d}", this.remoteAddress, this.protocolVersion, this.lastSeenTime);
    }

    public Map<String, String> asMap() {
        return ImmutableMap.builder().put((Object)INET_ADDRESS, (Object)this.remoteAddress.toString()).put((Object)PROTOCOL_VERSION, (Object)this.protocolVersion.toString()).put((Object)LAST_SEEN_TIME, (Object)String.valueOf(this.lastSeenTime)).build();
    }
}

