/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.derby;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;

@DatabaseMetaPlugin(type="DERBY", typeDescription="Apache Derby", documentationUrl="/database/databases/derby.html")
@GuiPlugin(id="GUI-DerbyDatabaseMeta")
public class DerbyDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public int getNotFoundTK(boolean useAutoinc) {
        if (this.isSupportsAutoInc() && useAutoinc) {
            return 0;
        }
        return super.getNotFoundTK(useAutoinc);
    }

    public String getDriverClass() {
        if (Utils.isEmpty((CharSequence)this.getHostname())) {
            return "org.apache.derby.jdbc.EmbeddedDriver";
        }
        return "org.apache.derby.client.ClientAutoloadedDriver";
    }

    public String getURL(String hostname, String port, String databaseName) {
        if (!Utils.isEmpty((CharSequence)hostname)) {
            String url = "jdbc:derby://" + hostname;
            if (!Utils.isEmpty((CharSequence)port)) {
                url = url + ":" + port;
            }
            url = url + "/" + databaseName;
            return url;
        }
        return "jdbc:derby:" + databaseName;
    }

    public boolean isFetchSizeSupported() {
        return true;
    }

    public boolean isSupportsBitmapIndex() {
        return false;
    }

    public String getTruncateTableStatement(String tableName) {
        return "DELETE FROM " + tableName;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ADD " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ALTER " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        Object retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval = (String)retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval = (String)retval + "TIMESTAMP";
                break;
            }
            case 4: {
                retval = (String)retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    if (useAutoinc) {
                        retval = (String)retval + "BIGINT NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 0, INCREMENT BY 1)";
                        break;
                    }
                    retval = (String)retval + "BIGINT NOT NULL PRIMARY KEY";
                    break;
                }
                if (precision == 0) {
                    if (length > 9) {
                        retval = (String)retval + "BIGINT";
                        break;
                    }
                    if (length > 4) {
                        retval = (String)retval + "INTEGER";
                        break;
                    }
                    retval = (String)retval + "SMALLINT";
                    break;
                }
                if (length > 18) {
                    retval = (String)retval + "DECIMAL(" + length;
                    if (precision > 0) {
                        retval = (String)retval + ", " + precision;
                    }
                    retval = (String)retval + ")";
                    break;
                }
                retval = (String)retval + "FLOAT";
                break;
            }
            case 2: {
                if (length >= 9999999 || length > 32700) {
                    retval = (String)retval + "CLOB";
                    break;
                }
                retval = (String)retval + "VARCHAR";
                retval = length > 0 ? (String)retval + "(" + length : (String)retval + "(";
                retval = (String)retval + ")";
                break;
            }
            case 8: {
                retval = (String)retval + "BLOB";
                break;
            }
            default: {
                retval = (String)retval + "UNKNOWN";
            }
        }
        if (addCr) {
            retval = (String)retval + Const.CR;
        }
        return retval;
    }

    public int getDefaultDatabasePort() {
        return 1527;
    }

    public boolean isSupportsGetBlob() {
        return false;
    }

    public String getExtraOptionsHelpText() {
        return "http://db.apache.org/derby/papers/DerbyClientSpec.html";
    }

    public String[] getReservedWords() {
        return new String[]{"ADD", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "AS", "ASC", "ASSERTION", "AT", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BIT", "BOOLEAN", "BOTH", "BY", "CALL", "CASCADE", "CASCADED", "CASE", "CAST", "CHAR", "CHARACTER", "CHECK", "CLOSE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTINUE", "CONVERT", "CORRESPONDING", "COUNT", "CREATE", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DESCRIBE", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DOUBLE", "DROP", "ELSE", "END", "ENDEXEC", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FROM", "FULL", "FUNCTION", "GET", "GET_CURRENT_CONNECTION", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HAVING", "HOUR", "IDENTITY", "IMMEDIATE", "IN", "INDICATOR", "INITIALLY", "INNER", "INOUT", "INPUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTO", "IS", "ISOLATION", "JOIN", "KEY", "LAST", "LEFT", "LIKE", "LONGINT", "LOWER", "LTRIM", "MATCH", "MAX", "MIN", "MINUTE", "NATIONAL", "NATURAL", "NCHAR", "NVARCHAR", "NEXT", "NO", "NOT", "NULL", "NULLIF", "NUMERIC", "OF", "ON", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "OUT", "OUTER", "OUTPUT", "OVERLAPS", "PAD", "PARTIAL", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "REAL", "REFERENCES", "RELATIVE", "RESTRICT", "REVOKE", "RIGHT", "ROLLBACK", "ROWS", "RTRIM", "SCHEMA", "SCROLL", "SECOND", "SELECT", "SESSION_USER", "SET", "SMALLINT", "SOME", "SPACE", "SQL", "SQLCODE", "SQLERROR", "SQLSTATE", "SUBSTR", "SUBSTRING", "SUM", "SYSTEM_USER", "TABLE", "TEMPORARY", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TRUE", "UNION", "UNIQUE", "UNKNOWN", "UPDATE", "UPPER", "USER", "USING", "VALUES", "VARCHAR", "VARYING", "VIEW", "WHENEVER", "WHERE", "WITH", "WORK", "WRITE", "XML", "XMLEXISTS", "XMLPARSE", "XMLSERIALIZE", "YEAR"};
    }

    public String getSqlInsertAutoIncUnknownDimensionRow(String schemaTable, String keyField, String versionField) {
        return "insert into " + schemaTable + "(" + versionField + ") values (1)";
    }
}

