/*
 * Decompiled with CFR 0.152.
 */
package jflex.core.unicode;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import jflex.base.Pair;
import jflex.chars.Interval;
import jflex.core.unicode.CMapBlock;
import jflex.core.unicode.CharClassInterval;
import jflex.core.unicode.ILexScan;
import jflex.core.unicode.IntCharSet;
import jflex.core.unicode.IntCharSetComparator;
import jflex.core.unicode.UnicodeProperties;
import jflex.logging.Out;

public class CharClasses {
    private static final boolean DEBUG = false;
    private static final Comparator<IntCharSet> INT_CHAR_SET_COMPARATOR = new IntCharSetComparator();
    public static final int maxChar = 0x10FFFF;
    private List<IntCharSet> classes;
    private int maxCharUsed;
    private UnicodeProperties unicodeProps;

    public void init(int maxCharCode, ILexScan scanner) {
        if (maxCharCode < 0) {
            throw new IllegalArgumentException("maxCharCode " + maxCharCode + " is negative.");
        }
        if (maxCharCode > 0x10FFFF) {
            throw new IllegalArgumentException("maxCharCode " + Integer.toHexString(maxCharCode) + " is larger than maxChar " + Integer.toHexString(0x10FFFF));
        }
        this.maxCharUsed = maxCharCode;
        this.unicodeProps = scanner.getUnicodeProperties();
        this.classes = new ArrayList<IntCharSet>();
        this.classes.add(IntCharSet.ofCharacterRange(0, maxCharCode));
    }

    public int getMaxCharCode() {
        return this.maxCharUsed;
    }

    public void setMaxCharCode(int maxCharCode) {
        if (maxCharCode < 0) {
            throw new IllegalArgumentException("maxCharCode " + maxCharCode + " is negative.");
        }
        if (maxCharCode > 0x10FFFF) {
            throw new IllegalArgumentException("maxCharCode " + Integer.toHexString(maxCharCode) + " is larger than maxChar " + Integer.toHexString(0x10FFFF));
        }
        this.maxCharUsed = maxCharCode;
    }

    public int getNumClasses() {
        return this.classes.size();
    }

    public List<IntCharSet> allClasses() {
        ArrayList<IntCharSet> result = new ArrayList<IntCharSet>();
        for (IntCharSet ccl : this.classes) {
            result.add(IntCharSet.copyOf(ccl));
        }
        return result;
    }

    public void makeClass(IntCharSet set, boolean caseless) {
        set = IntCharSet.copyOf(set);
        if (caseless) {
            set = set.getCaseless(this.unicodeProps);
        }
        int oldSize = this.classes.size();
        for (int i = 0; i < oldSize; ++i) {
            IntCharSet x = this.classes.get(i);
            if (Objects.equals(x, set)) {
                return;
            }
            IntCharSet and = x.and(set);
            if (!and.containsElements()) continue;
            if (Objects.equals(x, and)) {
                set.sub(and);
                continue;
            }
            if (Objects.equals(set, and)) {
                x.sub(and);
                this.classes.add(and);
                return;
            }
            set.sub(and);
            x.sub(and);
            this.classes.add(and);
        }
    }

    public int getClassCode(int codePoint) {
        IntCharSet x;
        int i = -1;
        while (!(x = this.classes.get(++i)).contains(codePoint)) {
        }
        return i;
    }

    public IntCharSet getCharClass(int code) {
        return IntCharSet.copyOf(this.classes.get(code));
    }

    public void dump() {
        Out.dump(this.toString());
    }

    public String toString(int theClass) {
        return this.classes.get(theClass).toString();
    }

    public String toString() {
        StringBuilder result = new StringBuilder("CharClasses:");
        result.append(Out.NL);
        for (int i = 0; i < this.classes.size(); ++i) {
            result.append("class ").append(i).append(":").append(Out.NL).append(this.classes.get(i)).append(Out.NL);
        }
        return result.toString();
    }

    public void makeClass(int singleChar, boolean caseless) {
        this.makeClass(IntCharSet.ofCharacter(singleChar), caseless);
    }

    public void makeClass(String str, boolean caseless) {
        int ch;
        for (int i = 0; i < str.length(); i += Character.charCount(ch)) {
            ch = str.codePointAt(i);
            this.makeClass(ch, caseless);
        }
    }

    public int[] getClassCodes(IntCharSet set, boolean negate) {
        int size = this.classes.size();
        int[] temp = new int[size];
        int length = 0;
        for (int i = 0; i < size; ++i) {
            IntCharSet x = this.classes.get(i);
            if (negate) {
                if (set.and(x).containsElements()) continue;
                temp[length++] = i;
                continue;
            }
            if (!set.and(x).containsElements()) continue;
            temp[length++] = i;
        }
        int[] result = new int[length];
        System.arraycopy(temp, 0, result, 0, length);
        return result;
    }

    public boolean invariants() {
        for (int i = 0; i < this.classes.size(); ++i) {
            for (int j = i + 1; j < this.classes.size(); ++j) {
                if (!this.classes.get(i).and(this.classes.get(j)).containsElements()) continue;
                return false;
            }
        }
        IntCharSet union = new IntCharSet();
        for (IntCharSet i : this.classes) {
            union.add(i);
        }
        return IntCharSet.allChars().equals(union);
    }

    public void normalise() {
        this.classes.sort(INT_CHAR_SET_COMPARATOR);
    }

    public static CharClasses copyOf(CharClasses c) {
        CharClasses result = new CharClasses();
        result.maxCharUsed = c.maxCharUsed;
        result.unicodeProps = c.unicodeProps;
        result.classes = c.allClasses();
        return result;
    }

    public CharClassInterval[] getIntervals() {
        int i;
        int size = this.classes.size();
        int numIntervals = 0;
        for (i = 0; i < size; ++i) {
            numIntervals += this.classes.get(i).numIntervals();
        }
        ArrayList<Iterator<Interval>> iterators = new ArrayList<Iterator<Interval>>();
        for (IntCharSet set : this.classes) {
            iterators.add(set.intervalIterator());
        }
        CharClassInterval[] result = new CharClassInterval[numIntervals];
        i = 0;
        int c = 0;
        while (i < numIntervals) {
            int code = this.getClassCode(c);
            Interval iv = (Interval)((Iterator)iterators.get(code)).next();
            result[i++] = new CharClassInterval(iv.start, iv.end, code);
            c = iv.end + 1;
        }
        return result;
    }

    Pair<int[], List<CMapBlock>> computeTables() {
        CharClassInterval[] intervals = this.getIntervals();
        int intervalIndex = 0;
        int curClass = intervals[intervalIndex].charClass;
        int codePoint = 0;
        int topLevelSize = this.maxCharUsed + 1 >> 8;
        int[] topLevel = new int[topLevelSize];
        ArrayList<CMapBlock> blocks = new ArrayList<CMapBlock>();
        for (int topIndex = 0; topIndex < topLevelSize; ++topIndex) {
            int[] block = new int[256];
            for (int i = 0; i < 256 && this.maxCharUsed >= codePoint; ++i, ++codePoint) {
                if (!intervals[intervalIndex].contains(codePoint)) {
                    curClass = intervals[++intervalIndex].charClass;
                }
                block[i] = curClass;
            }
            CMapBlock b = new CMapBlock(block);
            int idx = blocks.indexOf(b);
            if (idx < 0) {
                idx = blocks.size();
                blocks.add(b);
            }
            topLevel[topIndex] = idx;
        }
        return new Pair<int[], List<CMapBlock>>(topLevel, blocks);
    }

    private static int[] flattenBlocks(List<CMapBlock> blocks) {
        int[] result = new int[blocks.size() * 256];
        for (int i = 0; i < blocks.size(); ++i) {
            int[] block = blocks.get((int)i).block;
            System.arraycopy(block, 0, result, i << 8, 256);
        }
        return result;
    }

    public Pair<int[], int[]> getTables() {
        Pair<int[], List<CMapBlock>> p = this.computeTables();
        int[] shifted = new int[((int[])p.fst).length];
        for (int i = 0; i < ((int[])p.fst).length; ++i) {
            shifted[i] = ((int[])p.fst)[i] << 8;
        }
        return new Pair<int[], int[]>(shifted, CharClasses.flattenBlocks((List)p.snd));
    }
}

