/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.perspective;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;

public class HistoryResult {
    private String id;
    private String name;
    private String type;
    private String copy;
    private Long input;
    private Long output;
    private Long read;
    private Long written;
    private Long rejected;
    private Long errors;
    private Long durationMs;
    private String loggingText;
    private String registrationDate;
    private List<List<HistoryResult>> shortestPaths = new ArrayList<List<HistoryResult>>();
    private Boolean root;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCopy() {
        return this.copy;
    }

    public void setCopy(String copy) {
        this.copy = copy;
    }

    public Long getInput() {
        return this.input;
    }

    public void setInput(Long input) {
        this.input = input;
    }

    public Long getOutput() {
        return this.output;
    }

    public void setOutput(Long output) {
        this.output = output;
    }

    public Long getRead() {
        return this.read;
    }

    public void setRead(Long read) {
        this.read = read;
    }

    public Long getWritten() {
        return this.written;
    }

    public void setWritten(Long written) {
        this.written = written;
    }

    public Long getRejected() {
        return this.rejected;
    }

    public void setRejected(Long rejected) {
        this.rejected = rejected;
    }

    public Long getErrors() {
        return this.errors;
    }

    public void setErrors(Long errors) {
        this.errors = errors;
    }

    public String getLoggingText() {
        return this.loggingText;
    }

    public void setLoggingText(String loggingText) {
        this.loggingText = loggingText;
    }

    public String getRegistrationDate() {
        return this.registrationDate;
    }

    public void setRegistrationDate(String registrationDate) {
        this.registrationDate = registrationDate;
    }

    public List<List<HistoryResult>> getShortestPaths() {
        return this.shortestPaths;
    }

    public void setShortestPaths(List<List<HistoryResult>> shortestPaths) {
        this.shortestPaths = shortestPaths;
    }

    public Long getDurationMs() {
        return this.durationMs;
    }

    public void setDurationMs(Long durationMs) {
        this.durationMs = durationMs;
    }

    public void setRoot(Boolean root) {
        this.root = root;
    }

    public Boolean isRoot() {
        return this.root;
    }

    public String getExecutionInfoCommand() {
        StringBuilder cmd = new StringBuilder();
        cmd.append("MATCH(ex:Execution { name : \"" + this.getName() + "\", type : \"" + this.getType() + "\", id : \"" + this.getId() + "\"}) ").append(Const.CR);
        cmd.append("RETURN ex ").append(Const.CR);
        return cmd.toString();
    }

    public String getErrorPathCommand() {
        StringBuilder cmd = new StringBuilder();
        cmd.append("MATCH(top:Execution { name : \"" + this.getName() + "\", type : \"" + this.getType() + "\", id : \"" + this.getId() + "\"})-[rel:EXECUTES*]-(err:Execution) ").append(Const.CR);
        cmd.append("   , p=shortestpath((top)-[:EXECUTES*]-(err)) ").append(Const.CR);
        cmd.append("WHERE top.registrationDate IS NOT NULL ").append(Const.CR);
        cmd.append("  AND err.errors > 0 ").append(Const.CR);
        cmd.append("  AND size((err)-[:EXECUTES]->())=0 ").append(Const.CR);
        cmd.append("RETURN p ").append(Const.CR);
        cmd.append("ORDER BY size(RELATIONSHIPS(p)) DESC ").append(Const.CR);
        cmd.append("LIMIT 5").append(Const.CR);
        return cmd.toString();
    }

    public String getErrorPathWithMetadataCommand(int pathIndex) {
        StringBuilder cmd = new StringBuilder();
        cmd.append("MATCH(top:Execution { name : \"" + this.getName() + "\", type : \"" + this.getType() + "\", id : \"" + this.getId() + "\"})-[rel:EXECUTES*]-(err:Execution) ").append(Const.CR);
        cmd.append("   , p=shortestpath((top)-[:EXECUTES*]-(err)) ").append(Const.CR);
        cmd.append("WHERE top.registrationDate IS NOT NULL ").append(Const.CR);
        cmd.append("  AND err.errors > 0 ").append(Const.CR);
        cmd.append("  AND size((err)-[:EXECUTES]->())=0 ").append(Const.CR);
        StringBuilder returns = new StringBuilder("RETURN p");
        int matchIndex = 1;
        List<HistoryResult> shortestPath = this.getShortestPaths().get(pathIndex);
        for (HistoryResult result : shortestPath) {
            String metaLabel = null;
            if (result.getType().equals("PIPELINE")) {
                metaLabel = "Pipeline";
            } else if (result.getType().equals("WORKFLOW")) {
                metaLabel = "Workflow";
            } else if (result.getType().equals("ACTION")) {
                metaLabel = "Action";
            } else if (result.getType().equals("TRANSFORM")) {
                metaLabel = "Transform";
            }
            if (metaLabel == null) continue;
            cmd.append("MATCH (:Execution { type : \"" + result.getType() + "\", id : \"" + result.getId() + "\"})-[metaRel" + matchIndex + "]->(meta" + matchIndex + ":" + metaLabel + ") ").append(Const.CR);
            returns.append(", metaRel" + matchIndex + ", meta" + matchIndex);
            ++matchIndex;
        }
        cmd.append(returns.toString()).append(" ").append(Const.CR);
        cmd.append("LIMIT 1 ").append(Const.CR);
        return cmd.toString();
    }
}

