/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.filterrows;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Condition;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IStringObjectConverter;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.TransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transform.stream.StreamIcon;
import org.apache.hop.pipeline.transforms.filterrows.FilterRows;
import org.apache.hop.pipeline.transforms.filterrows.FilterRowsData;

@Transform(id="FilterRows", image="filterrows.svg", name="i18n::FilterRows.Name", description="i18n::FilterRows.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Flow", keywords={"i18n::FilterRowsMeta.keyword"}, documentationUrl="/pipeline/transforms/filterrows.html")
public class FilterRowsMeta
extends BaseTransformMeta<FilterRows, FilterRowsData> {
    private static final Class<?> PKG = FilterRowsMeta.class;
    @HopMetadataProperty(key="compare", injectionKey="CONDITION", injectionKeyDescription="FilterRowsMeta.Injection.CONDITION", injectionStringObjectConverter=ConditionXmlConverter.class)
    private FRCompare compare;
    @HopMetadataProperty(key="send_true_to", injectionKey="SEND_TRUE_TRANSFORM", injectionKeyDescription="FilterRowsMeta.Injection.SEND_TRUE_TRANSFORM")
    private String trueTransformName;
    @HopMetadataProperty(key="send_false_to", injectionKey="SEND_FALSE_TRANSFORM", injectionKeyDescription="FilterRowsMeta.Injection.SEND_FALSE_TRANSFORM")
    private String falseTransformName;

    public FilterRowsMeta() {
        this.compare = new FRCompare();
    }

    public FilterRowsMeta(FilterRowsMeta m) {
        this.compare = m.compare == null ? new FRCompare() : new FRCompare(m.compare);
        this.setTrueTransformName(m.getTrueTransformName());
        this.setFalseTransformName(m.getFalseTransformName());
    }

    public FilterRowsMeta clone() {
        return new FilterRowsMeta(this);
    }

    public void setDefault() {
        this.compare = new FRCompare();
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        List targetStreams = this.getTransformIOMeta().getTargetStreams();
        for (IStream stream : targetStreams) {
            stream.setTransformMeta(TransformMeta.findTransform(transforms, (String)stream.getSubject()));
        }
    }

    public void resetTransformIoMeta() {
    }

    public void getFields(IRowMeta rowMeta, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        String[] conditionField;
        for (String s : conditionField = this.getCondition().getUsedFields()) {
            int idx = rowMeta.indexOfValue(s);
            if (idx < 0) continue;
            IValueMeta valueMeta = rowMeta.getValueMeta(idx);
            valueMeta.setSortedDescending(false);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        this.checkTarget(transformMeta, "true", this.getTrueTransformName(), output).ifPresent(remarks::add);
        this.checkTarget(transformMeta, "false", this.getFalseTransformName(), output).ifPresent(remarks::add);
        CheckResult cr = this.getCondition().isEmpty() ? new CheckResult(4, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.NoConditionSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.ConditionSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.TransformReceivingFields", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            List<String> orphanFields = this.getOrphanFields(this.getCondition(), prev);
            if (!orphanFields.isEmpty()) {
                StringBuilder errorMessage = new StringBuilder(BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.FieldsNotFoundFromPreviousTransform", (String[])new String[0]) + Const.CR);
                for (String field : orphanFields) {
                    errorMessage.append("\t\t").append(field).append(Const.CR);
                }
                cr = new CheckResult(4, errorMessage.toString(), (ICheckResultSource)transformMeta);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.AllFieldsFoundInInputStream", (String[])new String[0]), (ICheckResultSource)transformMeta);
            }
            remarks.add((ICheckResult)cr);
        } else {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.CouldNotReadFieldsFromPreviousTransform", (String[])new String[0]), (ICheckResultSource)transformMeta));
        }
        if (input.length > 0) {
            remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.TransformReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta));
        } else {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.NoInputReceivedFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta));
        }
    }

    private Optional<CheckResult> checkTarget(TransformMeta transformMeta, String target, String targetTransformName, String[] output) {
        int trueTargetIdx;
        if (targetTransformName != null && (trueTargetIdx = Const.indexOfString((String)targetTransformName, (String[])output)) < 0) {
            return Optional.of(new CheckResult(4, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.TargetTransformInvalid", (String[])new String[]{target, targetTransformName}), (ICheckResultSource)transformMeta));
        }
        return Optional.empty();
    }

    public ITransformIOMeta getTransformIOMeta() {
        ITransformIOMeta ioMeta = super.getTransformIOMeta(false);
        if (ioMeta == null) {
            ioMeta = new TransformIOMeta(true, true, false, false, false, false);
            ioMeta.addStream((IStream)new org.apache.hop.pipeline.transform.stream.Stream(IStream.StreamType.TARGET, null, BaseMessages.getString(PKG, (String)"FilterRowsMeta.InfoStream.True.Description", (String[])new String[0]), StreamIcon.TRUE, null));
            ioMeta.addStream((IStream)new org.apache.hop.pipeline.transform.stream.Stream(IStream.StreamType.TARGET, null, BaseMessages.getString(PKG, (String)"FilterRowsMeta.InfoStream.False.Description", (String[])new String[0]), StreamIcon.FALSE, null));
            this.setTransformIOMeta(ioMeta);
        }
        return ioMeta;
    }

    public void handleStreamSelection(IStream stream) {
        TransformMeta trueTransform;
        TransformMeta falseTransform;
        List targets = this.getTransformIOMeta().getTargetStreams();
        int index = targets.indexOf(stream);
        if (index == 0 && (falseTransform = ((IStream)targets.get(1)).getTransformMeta()) != null && falseTransform.equals((Object)stream.getTransformMeta())) {
            ((IStream)targets.get(1)).setTransformMeta(null);
        }
        if (index == 1 && (trueTransform = ((IStream)targets.get(0)).getTransformMeta()) != null && trueTransform.equals((Object)stream.getTransformMeta())) {
            ((IStream)targets.get(0)).setTransformMeta(null);
        }
    }

    public boolean excludeFromCopyDistributeVerification() {
        return true;
    }

    public List<String> getOrphanFields(Condition condition, IRowMeta prev) {
        String[] key;
        ArrayList<String> orphans = new ArrayList<String>();
        if (condition == null || prev == null) {
            return orphans;
        }
        for (String s : key = condition.getUsedFields()) {
            IValueMeta v;
            if (Utils.isEmpty((CharSequence)s) || (v = prev.searchValueMeta(s)) != null) continue;
            orphans.add(s);
        }
        return orphans;
    }

    public String getTrueTransformName() {
        return this.getTargetTransformName(0);
    }

    public void setTrueTransformName(String trueTransformName) {
        ((IStream)this.getTransformIOMeta().getTargetStreams().get(0)).setSubject(trueTransformName);
    }

    public String getFalseTransformName() {
        return this.getTargetTransformName(1);
    }

    public void setFalseTransformName(String falseTransformName) {
        ((IStream)this.getTransformIOMeta().getTargetStreams().get(1)).setSubject(falseTransformName);
    }

    private String getTargetTransformName(int streamIndex) {
        IStream stream = (IStream)this.getTransformIOMeta().getTargetStreams().get(streamIndex);
        return Stream.of(stream.getTransformName(), stream.getSubject()).filter(Objects::nonNull).findFirst().map(Object::toString).orElse(null);
    }

    public String getConditionXml() {
        String conditionXML = null;
        try {
            conditionXML = this.getCondition().getXml();
        }
        catch (HopValueException e) {
            this.log.logError(e.getMessage());
        }
        return conditionXML;
    }

    public Condition getCondition() {
        return this.compare.condition;
    }

    public void setCondition(Condition condition) {
        this.compare.condition = condition;
    }

    public FRCompare getCompare() {
        return this.compare;
    }

    public void setCompare(FRCompare compare) {
        this.compare = compare;
    }

    public static final class ConditionXmlConverter
    implements IStringObjectConverter {
        public String getString(Object object) throws HopException {
            if (!(object instanceof FRCompare)) {
                throw new HopException("We only support XML serialization of Condition objects here");
            }
            try {
                return ((FRCompare)object).getCondition().getXml();
            }
            catch (Exception e) {
                throw new HopException("Error serializing Condition to XML", (Throwable)e);
            }
        }

        public Object getObject(String xml) throws HopException {
            try {
                return new FRCompare(new Condition(xml));
            }
            catch (Exception e) {
                throw new HopException("Error serializing Condition from XML", (Throwable)e);
            }
        }
    }

    public static final class FRCompare {
        @HopMetadataProperty(key="condition")
        private Condition condition;

        public FRCompare() {
            this.condition = new Condition();
        }

        public FRCompare(FRCompare c) {
            this.condition = new Condition(c.condition);
        }

        public FRCompare(Condition condition) {
            this.condition = condition;
        }

        public Condition getCondition() {
            return this.condition;
        }

        public void setCondition(Condition condition) {
            this.condition = condition;
        }
    }
}

