/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.pipeline.transform.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.common.FieldSelectionDialog;
import org.apache.hop.ui.pipeline.transform.common.GetFieldsSampleDataDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public interface IGetFieldsCapableTransformDialog<TransformMetaType extends BaseTransformMeta> {
    public static final Class<?> PKG = IGetFieldsCapableTransformDialog.class;
    public static final LogChannel logger = new LogChannel(IGetFieldsCapableTransformDialog.class);

    public Shell getParent();

    public Shell getShell();

    public String[] getFieldNames(TransformMetaType var1);

    public TableView getFieldsTable();

    default public TableItem findTableItem(String fieldName) {
        for (int i = 0; i < this.getFieldsTable().table.getItemCount(); ++i) {
            int fieldNameIndex;
            TableItem item = this.getFieldsTable().table.getItem(i);
            String itemFieldName = item.getText(fieldNameIndex = this.getFieldsTable().hasIndexColumn() ? 1 : 0);
            if (itemFieldName == null || !itemFieldName.equals(fieldName)) continue;
            return item;
        }
        return null;
    }

    default public List<String> getNewFieldNames(String[] incomingFieldNames) {
        HashSet<String> fieldNamesInTable = new HashSet<String>();
        for (int i = 0; i < this.getFieldsTable().nrNonEmpty(); ++i) {
            TableItem item = this.getFieldsTable().getNonEmpty(i);
            int fieldNameIndex = this.getFieldsTable().hasIndexColumn() ? 1 : 0;
            fieldNamesInTable.add(item.getText(fieldNameIndex));
        }
        List<String> newFieldNames = Arrays.asList(fieldNamesInTable.toArray(new String[fieldNamesInTable.size()])).stream().filter(fieldName -> !Arrays.asList(incomingFieldNames).contains(fieldName)).collect(Collectors.toList());
        return newFieldNames;
    }

    default public void getFields() {
        this.getFields(this.getPopulatedMeta());
    }

    default public void getFields(TransformMetaType meta) {
        String[] incomingFieldNames = this.getFieldNames(meta);
        List<String> newFieldNames = this.getNewFieldNames(incomingFieldNames);
        if (newFieldNames != null && newFieldNames.size() > 0) {
            int nrNonEmptyFields = this.getFieldsTable().nrNonEmpty();
            if (nrNonEmptyFields > 0) {
                FieldSelectionDialog fieldSelectDialog = new FieldSelectionDialog(this.getShell(), newFieldNames.size()){

                    @Override
                    protected void ok() {
                        super.ok();
                        IGetFieldsCapableTransformDialog.this.openGetFieldsSampleDataDialog(this.reloadAllFields);
                    }
                };
                fieldSelectDialog.open();
            } else {
                this.openGetFieldsSampleDataDialog(true);
            }
        } else {
            this.openGetFieldsSampleDataDialog(true);
        }
    }

    default public void openGetFieldsSampleDataDialog(boolean reloadAllFields) {
        GetFieldsSampleDataDialog dlg = new GetFieldsSampleDataDialog(this.getShell(), this, reloadAllFields);
        dlg.open();
    }

    public String loadFieldsImpl(TransformMetaType var1, int var2);

    default public Map<String, List<String>> getFieldValues() {
        this.getFieldsTable().nrNonEmpty();
        HashMap<String, List<String>> rowValues = new HashMap<String, List<String>>();
        for (int i = 0; i < this.getFieldsTable().table.getItemCount(); ++i) {
            int startIndex;
            TableItem item = this.getFieldsTable().table.getItem(i);
            String fieldName = item.getText(startIndex = this.getFieldsTable().hasIndexColumn() ? 1 : 0);
            if (StringUtils.isBlank((String)fieldName)) continue;
            ArrayList<String> values = new ArrayList<String>();
            for (int j = startIndex; j < this.getFieldsTable().getColumns().length; ++j) {
                values.add(item.getText(j));
            }
            rowValues.put(fieldName, values);
        }
        return rowValues;
    }

    default public List<String> repopulateFields(TransformMetaType meta, Map<String, List<String>> previousFieldValues, boolean reloadAllFields) {
        String[] incomingFieldNames = this.getFieldNames(meta);
        ArrayList<String> newFieldNames = new ArrayList<String>();
        for (String incomingFieldName : incomingFieldNames) {
            TableItem item = new TableItem(this.getFieldsTable().table, 0);
            int columnIndexOffset = this.getFieldsTable().hasIndexColumn() ? 1 : 0;
            item.setText(columnIndexOffset, incomingFieldName);
            if (previousFieldValues.containsKey(incomingFieldName)) {
                List<String> values = previousFieldValues.remove(incomingFieldName);
                int columnIndex = 0;
                if (reloadAllFields || values == null) continue;
                for (String value : values) {
                    item.setText(columnIndex++ + columnIndexOffset, value);
                }
                continue;
            }
            newFieldNames.add(incomingFieldName);
        }
        if (!reloadAllFields) {
            this.loadRemainingFields(previousFieldValues);
        }
        return newFieldNames;
    }

    default public void loadRemainingFields(Map<String, List<String>> previousFieldValues) {
        for (List<String> values : previousFieldValues.values()) {
            if (values == null) continue;
            TableItem item = new TableItem(this.getFieldsTable().table, 0);
            int columnIndexOffset = this.getFieldsTable().hasIndexColumn() ? 1 : 0;
            int columnIndex = 0;
            for (String value : values) {
                item.setText(columnIndex++ + columnIndexOffset, value);
            }
        }
    }

    default public String loadFields(TransformMetaType meta, int samples, boolean reloadAllFields) {
        Map<String, List<String>> fieldValues = this.getFieldValues();
        this.getFieldsTable().removeAll();
        this.getFieldsTable().removeEmptyRows();
        this.getFieldsTable().setRowNums();
        this.getFieldsTable().optWidth(true);
        List<String> newFieldNames = this.repopulateFields(meta, fieldValues, reloadAllFields);
        this.populateMeta(meta);
        String message = this.loadFieldsImpl(meta, samples);
        if (message != null) {
            if (reloadAllFields) {
                this.getFieldsTable().removeAll();
            }
            this.getData(meta, false, reloadAllFields, newFieldNames);
        }
        return message;
    }

    default public TableItem getTableItem(String fieldName) {
        return this.getTableItem(fieldName, false);
    }

    default public TableItem getTableItem(String fieldName, boolean alwaysCreateNewFields) {
        TableItem item = null;
        if (alwaysCreateNewFields) {
            item = new TableItem(this.getFieldsTable().table, 0);
        } else {
            item = this.findTableItem(fieldName);
            if (item == null) {
                item = new TableItem(this.getFieldsTable().table, 0);
            }
        }
        return item;
    }

    public void getData(TransformMetaType var1, boolean var2, boolean var3, List<String> var4);

    default public TransformMetaType getPopulatedMeta() {
        TransformMetaType newMeta = this.getNewMetaInstance();
        this.populateMeta(newMeta);
        return newMeta;
    }

    public void populateMeta(TransformMetaType var1);

    public TransformMetaType getNewMetaInstance();

    public PipelineMeta getPipelineMeta();
}

