/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.loadfileinput;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transforms.loadfileinput.LoadFileInputMeta;
import org.w3c.dom.Node;

public class LoadFileInputField
implements Cloneable {
    private static final Class<?> PKG = LoadFileInputMeta.class;
    public static final int TYPE_TRIM_NONE = 0;
    public static final int TYPE_TRIM_LEFT = 1;
    public static final int TYPE_TRIM_RIGHT = 2;
    public static final int TYPE_TRIM_BOTH = 3;
    public static final String[] trimTypeCode = new String[]{"none", "left", "right", "both"};
    public static final String[] trimTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"LoadFileInputField.TrimType.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LoadFileInputField.TrimType.Left", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LoadFileInputField.TrimType.Right", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LoadFileInputField.TrimType.Both", (String[])new String[0])};
    public static final int ELEMENT_TYPE_FILECONTENT = 0;
    public static final int ELEMENT_TYPE_FILESIZE = 1;
    public static final String[] ElementTypeCode = new String[]{"content", "size"};
    public static final String[] ElementTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"LoadFileInputField.ElementType.FileContent", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LoadFileInputField.ElementType.FileSize", (String[])new String[0])};
    private String name;
    private int type;
    private int length;
    private String format;
    private int trimtype;
    private int elementtype;
    private int precision;
    private String currencySymbol;
    private String decimalSymbol;
    private String groupSymbol;
    private boolean repeat;

    public LoadFileInputField(String fieldname) {
        this.name = fieldname;
        this.elementtype = 0;
        this.length = -1;
        this.type = 2;
        this.format = "";
        this.trimtype = 0;
        this.groupSymbol = "";
        this.decimalSymbol = "";
        this.currencySymbol = "";
        this.precision = -1;
        this.repeat = false;
    }

    public LoadFileInputField() {
        this("");
    }

    public String getXml() {
        Object retval = "";
        retval = (String)retval + "      <field>" + Const.CR;
        retval = (String)retval + "        " + XmlHandler.addTagValue((String)"name", (String)this.getName());
        retval = (String)retval + "        " + XmlHandler.addTagValue((String)"element_type", (String)this.getElementTypeCode());
        retval = (String)retval + "        " + XmlHandler.addTagValue((String)"type", (String)this.getTypeDesc());
        retval = (String)retval + "        " + XmlHandler.addTagValue((String)"format", (String)this.getFormat());
        retval = (String)retval + "        " + XmlHandler.addTagValue((String)"currency", (String)this.getCurrencySymbol());
        retval = (String)retval + "        " + XmlHandler.addTagValue((String)"decimal", (String)this.getDecimalSymbol());
        retval = (String)retval + "        " + XmlHandler.addTagValue((String)"group", (String)this.getGroupSymbol());
        retval = (String)retval + "        " + XmlHandler.addTagValue((String)"length", (int)this.getLength());
        retval = (String)retval + "        " + XmlHandler.addTagValue((String)"precision", (int)this.getPrecision());
        retval = (String)retval + "        " + XmlHandler.addTagValue((String)"trim_type", (String)this.getTrimTypeCode());
        retval = (String)retval + "        " + XmlHandler.addTagValue((String)"repeat", (boolean)this.isRepeated());
        retval = (String)retval + "        </field>" + Const.CR;
        return retval;
    }

    public LoadFileInputField(Node fnode) throws HopValueException {
        this.setName(XmlHandler.getTagValue((Node)fnode, (String)"name"));
        this.setElementType(LoadFileInputField.getElementTypeByCode(XmlHandler.getTagValue((Node)fnode, (String)"element_type")));
        this.setType(ValueMetaFactory.getIdForValueMeta((String)XmlHandler.getTagValue((Node)fnode, (String)"type")));
        this.setFormat(XmlHandler.getTagValue((Node)fnode, (String)"format"));
        this.setCurrencySymbol(XmlHandler.getTagValue((Node)fnode, (String)"currency"));
        this.setDecimalSymbol(XmlHandler.getTagValue((Node)fnode, (String)"decimal"));
        this.setGroupSymbol(XmlHandler.getTagValue((Node)fnode, (String)"group"));
        this.setLength(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
        this.setPrecision(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
        this.setTrimType(LoadFileInputField.getTrimTypeByCode(XmlHandler.getTagValue((Node)fnode, (String)"trim_type")));
        this.setRepeated(!"N".equalsIgnoreCase(XmlHandler.getTagValue((Node)fnode, (String)"repeat")));
    }

    public static final int getTrimTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeCode.length; ++i) {
            if (!trimTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final int getElementTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < ElementTypeCode.length; ++i) {
            if (!ElementTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final int getTrimTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeDesc.length; ++i) {
            if (!trimTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final int getElementTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < ElementTypeDesc.length; ++i) {
            if (!ElementTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final String getTrimTypeCode(int i) {
        if (i < 0 || i >= trimTypeCode.length) {
            return trimTypeCode[0];
        }
        return trimTypeCode[i];
    }

    public static final String getElementTypeCode(int i) {
        if (i < 0 || i >= ElementTypeCode.length) {
            return ElementTypeCode[0];
        }
        return ElementTypeCode[i];
    }

    public static final String getTrimTypeDesc(int i) {
        if (i < 0 || i >= trimTypeDesc.length) {
            return trimTypeDesc[0];
        }
        return trimTypeDesc[i];
    }

    public static final String getElementTypeDesc(int i) {
        if (i < 0 || i >= ElementTypeDesc.length) {
            return ElementTypeDesc[0];
        }
        return ElementTypeDesc[i];
    }

    public Object clone() {
        try {
            LoadFileInputField retval = (LoadFileInputField)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String fieldname) {
        this.name = fieldname;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeDesc() {
        return ValueMetaFactory.getValueMetaName((int)this.type);
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public int getTrimType() {
        return this.trimtype;
    }

    public int getElementType() {
        return this.elementtype;
    }

    public String getTrimTypeCode() {
        return LoadFileInputField.getTrimTypeCode(this.trimtype);
    }

    public String getElementTypeCode() {
        return LoadFileInputField.getElementTypeCode(this.elementtype);
    }

    public String getTrimTypeDesc() {
        return LoadFileInputField.getTrimTypeDesc(this.trimtype);
    }

    public String getElementTypeDesc() {
        return LoadFileInputField.getElementTypeDesc(this.elementtype);
    }

    public void setTrimType(int trimtype) {
        this.trimtype = trimtype;
    }

    public void setElementType(int elementType) {
        this.elementtype = elementType;
    }

    public String getGroupSymbol() {
        return this.groupSymbol;
    }

    public void setGroupSymbol(String groupSymbol) {
        this.groupSymbol = groupSymbol;
    }

    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public void setDecimalSymbol(String decimalSymbol) {
        this.decimalSymbol = decimalSymbol;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public boolean isRepeated() {
        return this.repeat;
    }

    public void setRepeated(boolean repeat) {
        this.repeat = repeat;
    }

    public void flipRepeated() {
        this.repeat = !this.repeat;
    }

    public String getFieldPositionsCode() {
        String enc = "";
        return enc;
    }

    public void guess() {
    }
}

