/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.numberrange;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.numberrange.NumberRangeData;
import org.apache.hop.pipeline.transforms.numberrange.NumberRangeMeta;
import org.apache.hop.pipeline.transforms.numberrange.NumberRangeRule;
import org.apache.hop.pipeline.transforms.numberrange.NumberRangeSet;

public class NumberRange
extends BaseTransform<NumberRangeMeta, NumberRangeData> {
    private static final Class<?> PKG = NumberRangeMeta.class;
    private NumberRangeSet numberRange;

    public NumberRange(TransformMeta transformMeta, NumberRangeMeta meta, NumberRangeData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        block8: {
            Object[] row = this.getRow();
            if (row == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                for (NumberRangeRule rule : ((NumberRangeMeta)this.meta).getRules()) {
                    rule.init();
                }
                this.numberRange = new NumberRangeSet(((NumberRangeMeta)this.meta).getRules(), ((NumberRangeMeta)this.meta).getFallBackValue());
                ((NumberRangeData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                ((NumberRangeMeta)this.meta).getFields(((NumberRangeData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                ((NumberRangeData)this.data).inputColumnNr = ((NumberRangeData)this.data).outputRowMeta.indexOfValue(((NumberRangeMeta)this.meta).getInputField());
                if (((NumberRangeData)this.data).inputColumnNr < 0) {
                    this.logError("Field for input could not be found: " + ((NumberRangeMeta)this.meta).getInputField());
                    return false;
                }
            }
            try {
                Double value = this.getInputRowMeta().getNumber(row, ((NumberRangeData)this.data).inputColumnNr);
                String ranges = this.numberRange.evaluate(value);
                row = RowDataUtil.addRowData((Object[])row, (int)this.getInputRowMeta().size(), (Object[])new Object[]{ranges});
                this.putRow(((NumberRangeData)this.data).outputRowMeta, row);
                if (this.checkFeedback(this.getLinesRead()) && this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"NumberRange.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (HopException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"NumberRange.Log.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block8;
                this.putError(this.getInputRowMeta(), row, 1L, errorMessage, null, "NumberRange001");
            }
        }
        return true;
    }

    public boolean init() {
        return super.init();
    }

    public void dispose() {
        super.dispose();
    }
}

