/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.processfiles;

import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.processfiles.ProcessFilesData;
import org.apache.hop.pipeline.transforms.processfiles.ProcessFilesMeta;

public class ProcessFiles
extends BaseTransform<ProcessFilesMeta, ProcessFilesData> {
    private static final Class<?> PKG = ProcessFilesMeta.class;

    public ProcessFiles(TransformMeta transformMeta, ProcessFilesMeta meta, ProcessFilesData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        block35: {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                if (Utils.isEmpty((CharSequence)((ProcessFilesMeta)this.meta).getSourceFilenameField())) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ProcessFiles.Error.SourceFilenameFieldMissing", (String[])new String[0]));
                }
                if (((ProcessFilesMeta)this.meta).getOperationType() != 2 && Utils.isEmpty((CharSequence)((ProcessFilesMeta)this.meta).getTargetFilenameField())) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ProcessFiles.Error.TargetFilenameFieldMissing", (String[])new String[0]));
                }
                if (((ProcessFilesData)this.data).indexOfSourceFilename < 0) {
                    ((ProcessFilesData)this.data).indexOfSourceFilename = this.getInputRowMeta().indexOfValue(((ProcessFilesMeta)this.meta).getSourceFilenameField());
                    if (((ProcessFilesData)this.data).indexOfSourceFilename < 0) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"ProcessFiles.Exception.CouldnotFindField", (String[])new String[]{((ProcessFilesMeta)this.meta).getSourceFilenameField()}));
                    }
                }
                if (((ProcessFilesMeta)this.meta).getOperationType() != 2 && ((ProcessFilesData)this.data).indexOfTargetFilename < 0) {
                    ((ProcessFilesData)this.data).indexOfTargetFilename = this.getInputRowMeta().indexOfValue(((ProcessFilesMeta)this.meta).getTargetFilenameField());
                    if (((ProcessFilesData)this.data).indexOfTargetFilename < 0) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"ProcessFiles.Exception.CouldnotFindField", (String[])new String[]{((ProcessFilesMeta)this.meta).getTargetFilenameField()}));
                    }
                }
                if (((ProcessFilesMeta)this.meta).simulate && this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"ProcessFiles.Log.SimulationModeON", (String[])new String[0]));
                }
            }
            try {
                String sourceFilename = this.getInputRowMeta().getString(r, ((ProcessFilesData)this.data).indexOfSourceFilename);
                if (Utils.isEmpty((CharSequence)sourceFilename)) {
                    this.logError(BaseMessages.getString(PKG, (String)"ProcessFiles.Error.SourceFileEmpty", (String[])new String[0]));
                    throw new HopException(BaseMessages.getString(PKG, (String)"ProcessFiles.Error.SourceFileEmpty", (String[])new String[0]));
                }
                ((ProcessFilesData)this.data).sourceFile = HopVfs.getFileObject((String)sourceFilename);
                if (!((ProcessFilesData)this.data).sourceFile.exists()) {
                    this.logError(BaseMessages.getString(PKG, (String)"ProcessFiles.Error.SourceFileNotExist", (String[])new String[]{sourceFilename}));
                    throw new HopException(BaseMessages.getString(PKG, (String)"ProcessFiles.Error.SourceFileNotExist", (String[])new String[]{sourceFilename}));
                }
                if (((ProcessFilesData)this.data).sourceFile.getType() != FileType.FILE) {
                    this.logError(BaseMessages.getString(PKG, (String)"ProcessFiles.Error.SourceFileNotFile", (String[])new String[]{sourceFilename}));
                    throw new HopException(BaseMessages.getString(PKG, (String)"ProcessFiles.Error.SourceFileNotFile", (String[])new String[]{sourceFilename}));
                }
                String targetFilename = null;
                if (((ProcessFilesMeta)this.meta).getOperationType() != 2) {
                    targetFilename = this.getInputRowMeta().getString(r, ((ProcessFilesData)this.data).indexOfTargetFilename);
                    if (Utils.isEmpty((CharSequence)targetFilename)) {
                        this.logError(BaseMessages.getString(PKG, (String)"ProcessFiles.Error.TargetFileEmpty", (String[])new String[0]));
                        throw new HopException(BaseMessages.getString(PKG, (String)"ProcessFiles.Error.TargetFileEmpty", (String[])new String[0]));
                    }
                    ((ProcessFilesData)this.data).targetFile = HopVfs.getFileObject((String)targetFilename);
                    if (((ProcessFilesData)this.data).targetFile.exists()) {
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ProcessFiles.Log.TargetFileExists", (String[])new String[]{targetFilename}));
                        }
                        if (((ProcessFilesData)this.data).targetFile.getType() != FileType.FILE) {
                            this.logError(BaseMessages.getString(PKG, (String)"ProcessFiles.Error.TargetFileNotFile", (String[])new String[]{targetFilename}));
                            throw new HopException(BaseMessages.getString(PKG, (String)"ProcessFiles.Error.TargetFileNotFile", (String[])new String[]{targetFilename}));
                        }
                    } else {
                        FileObject parentFolder = ((ProcessFilesData)this.data).targetFile.getParent();
                        if (!parentFolder.exists()) {
                            if (!((ProcessFilesMeta)this.meta).isCreateParentFolder()) {
                                throw new HopException(BaseMessages.getString(PKG, (String)"ProcessFiles.Error.TargetParentFolderNotExists", (String[])new String[]{parentFolder.toString()}));
                            }
                            parentFolder.createFolder();
                        }
                        if (parentFolder != null) {
                            parentFolder.close();
                        }
                    }
                }
                switch (((ProcessFilesMeta)this.meta).getOperationType()) {
                    case 0: {
                        if ((((ProcessFilesMeta)this.meta).isOverwriteTargetFile() && ((ProcessFilesData)this.data).targetFile.exists() || !((ProcessFilesData)this.data).targetFile.exists()) && !((ProcessFilesMeta)this.meta).simulate) {
                            ((ProcessFilesData)this.data).targetFile.copyFrom(((ProcessFilesData)this.data).sourceFile, (FileSelector)new TextOneToOneFileSelector());
                            if (!this.log.isDetailed()) break;
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ProcessFiles.Log.SourceFileCopied", (String[])new String[]{sourceFilename, targetFilename}));
                            break;
                        }
                        if (!this.log.isDetailed()) break;
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ProcessFiles.Log.TargetNotOverwritten", (String[])new String[]{sourceFilename, targetFilename}));
                        break;
                    }
                    case 1: {
                        if ((((ProcessFilesMeta)this.meta).isOverwriteTargetFile() && ((ProcessFilesData)this.data).targetFile.exists() || !((ProcessFilesData)this.data).targetFile.exists()) && !((ProcessFilesMeta)this.meta).simulate) {
                            ((ProcessFilesData)this.data).sourceFile.moveTo(HopVfs.getFileObject((String)targetFilename));
                            if (!this.log.isDetailed()) break;
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ProcessFiles.Log.SourceFileMoved", (String[])new String[]{sourceFilename, targetFilename}));
                            break;
                        }
                        if (!this.log.isDetailed()) break;
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ProcessFiles.Log.TargetNotOverwritten", (String[])new String[]{sourceFilename, targetFilename}));
                        break;
                    }
                    case 2: {
                        if (!((ProcessFilesMeta)this.meta).simulate && !((ProcessFilesData)this.data).sourceFile.delete()) {
                            throw new HopException(BaseMessages.getString(PKG, (String)"ProcessFiles.Error.CanNotDeleteFile", (String[])new String[]{((ProcessFilesData)this.data).sourceFile.toString()}));
                        }
                        if (!this.log.isDetailed()) break;
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ProcessFiles.Log.SourceFileDeleted", (String[])new String[]{sourceFilename}));
                        break;
                    }
                }
                if (((ProcessFilesMeta)this.meta).isAddResultFilenames() && ((ProcessFilesMeta)this.meta).getOperationType() != 2 && ((ProcessFilesData)this.data).targetFile.getType() == FileType.FILE) {
                    ResultFile resultFile = new ResultFile(0, ((ProcessFilesData)this.data).targetFile, this.getPipelineMeta().getName(), this.getTransformName());
                    resultFile.setComment(BaseMessages.getString(PKG, (String)"ProcessFiles.Log.FileAddedResult", (String[])new String[0]));
                    this.addResultFile(resultFile);
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ProcessFiles.Log.FilenameAddResult", (String[])new String[]{((ProcessFilesData)this.data).targetFile.toString()}));
                    }
                }
                this.putRow(this.getInputRowMeta(), r);
                if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"ProcessFiles.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (Exception e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"ProcessFiles.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block35;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "ProcessFiles001");
            }
        }
        return true;
    }

    private class TextOneToOneFileSelector
    implements FileSelector {
        private TextOneToOneFileSelector() {
        }

        public boolean includeFile(FileSelectInfo info) throws Exception {
            return true;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return false;
        }
    }
}

