/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.ClientSCMProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.ReleaseSharedCacheResourceRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UseSharedCacheResourceRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UseSharedCacheResourceResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.client.api.SharedCacheClient;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.sharedcache.SharedCacheChecksum;
import org.apache.hadoop.yarn.sharedcache.SharedCacheChecksumFactory;
import org.apache.hadoop.yarn.util.Records;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SharedCacheClientImpl
extends SharedCacheClient {
    private static final Logger LOG = LoggerFactory.getLogger(SharedCacheClientImpl.class);
    private ClientSCMProtocol scmClient;
    private InetSocketAddress scmAddress;
    private Configuration conf;
    private SharedCacheChecksum checksum;

    public SharedCacheClientImpl() {
        super(SharedCacheClientImpl.class.getName());
    }

    private static InetSocketAddress getScmAddress(Configuration conf) {
        return conf.getSocketAddr("yarn.sharedcache.client-server.address", "0.0.0.0:8045", 8045);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        if (this.scmAddress == null) {
            this.scmAddress = SharedCacheClientImpl.getScmAddress(conf);
        }
        this.conf = conf;
        this.checksum = SharedCacheChecksumFactory.getChecksum((Configuration)conf);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        this.scmClient = this.createClientProxy();
        LOG.debug("Connecting to Shared Cache Manager at {}", (Object)this.scmAddress);
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        this.stopClientProxy();
        super.serviceStop();
    }

    @VisibleForTesting
    protected ClientSCMProtocol createClientProxy() {
        YarnRPC rpc = YarnRPC.create((Configuration)this.getConfig());
        return (ClientSCMProtocol)rpc.getProxy(ClientSCMProtocol.class, this.scmAddress, this.getConfig());
    }

    @VisibleForTesting
    protected void stopClientProxy() {
        if (this.scmClient != null) {
            RPC.stopProxy((Object)this.scmClient);
            this.scmClient = null;
        }
    }

    @Override
    public URL use(ApplicationId applicationId, String resourceKey) throws YarnException {
        Path resourcePath = null;
        UseSharedCacheResourceRequest request = (UseSharedCacheResourceRequest)Records.newRecord(UseSharedCacheResourceRequest.class);
        request.setAppId(applicationId);
        request.setResourceKey(resourceKey);
        try {
            UseSharedCacheResourceResponse response = this.scmClient.use(request);
            if (response != null && response.getPath() != null) {
                resourcePath = new Path(response.getPath());
            }
        }
        catch (Exception e) {
            throw new YarnException((Throwable)e);
        }
        if (resourcePath != null) {
            URL pathURL = URL.fromPath(resourcePath);
            return pathURL;
        }
        return null;
    }

    @Override
    public void release(ApplicationId applicationId, String resourceKey) throws YarnException {
        ReleaseSharedCacheResourceRequest request = (ReleaseSharedCacheResourceRequest)Records.newRecord(ReleaseSharedCacheResourceRequest.class);
        request.setAppId(applicationId);
        request.setResourceKey(resourceKey);
        try {
            this.scmClient.release(request);
        }
        catch (Exception e) {
            throw new YarnException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFileChecksum(Path sourceFile) throws IOException {
        FileSystem fs = sourceFile.getFileSystem(this.conf);
        try (FSDataInputStream in = null;){
            in = fs.open(sourceFile);
            String string = this.checksum.computeChecksum((InputStream)in);
            return string;
        }
    }
}

