/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import org.apache.beam.sdk.io.kinesis.AutoValue_WatermarkParameters;
import org.apache.beam.sdk.io.kinesis.KinesisRecord;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;

@AutoValue
public abstract class WatermarkParameters
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized KinesisRecord, @UnknownKeyFor @NonNull @Initialized Instant> ARRIVAL_TIME_FN = KinesisRecord::getApproximateArrivalTimestamp;
    private static final @UnknownKeyFor @NonNull @Initialized Duration STANDARD_WATERMARK_IDLE_DURATION_THRESHOLD = Duration.standardMinutes((long)2L);

    abstract @UnknownKeyFor @NonNull @Initialized Instant getCurrentWatermark();

    abstract @UnknownKeyFor @NonNull @Initialized Instant getEventTime();

    abstract @UnknownKeyFor @NonNull @Initialized Instant getLastUpdateTime();

    abstract @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized KinesisRecord, @UnknownKeyFor @NonNull @Initialized Instant> getTimestampFn();

    abstract @UnknownKeyFor @NonNull @Initialized Duration getWatermarkIdleDurationThreshold();

    public abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_WatermarkParameters.Builder().setCurrentWatermark(BoundedWindow.TIMESTAMP_MIN_VALUE).setEventTime(BoundedWindow.TIMESTAMP_MIN_VALUE).setTimestampFn(ARRIVAL_TIME_FN).setLastUpdateTime(Instant.now()).setWatermarkIdleDurationThreshold(STANDARD_WATERMARK_IDLE_DURATION_THRESHOLD);
    }

    public static @UnknownKeyFor @NonNull @Initialized WatermarkParameters create() {
        return WatermarkParameters.builder().build();
    }

    public @UnknownKeyFor @NonNull @Initialized WatermarkParameters withTimestampFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized KinesisRecord, @UnknownKeyFor @NonNull @Initialized Instant> timestampFn) {
        Preconditions.checkArgument((timestampFn != null ? 1 : 0) != 0, (Object)"timestampFn function is null");
        return this.toBuilder().setTimestampFn(timestampFn).build();
    }

    public @UnknownKeyFor @NonNull @Initialized WatermarkParameters withWatermarkIdleDurationThreshold(@UnknownKeyFor @NonNull @Initialized Duration idleDurationThreshold) {
        Preconditions.checkArgument((idleDurationThreshold != null ? 1 : 0) != 0, (Object)"watermark idle duration threshold is null");
        return this.toBuilder().setWatermarkIdleDurationThreshold(idleDurationThreshold).build();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder setCurrentWatermark(@UnknownKeyFor @NonNull @Initialized Instant var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setEventTime(@UnknownKeyFor @NonNull @Initialized Instant var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setLastUpdateTime(@UnknownKeyFor @NonNull @Initialized Instant var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setWatermarkIdleDurationThreshold(@UnknownKeyFor @NonNull @Initialized Duration var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setTimestampFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized KinesisRecord, @UnknownKeyFor @NonNull @Initialized Instant> var1);

        abstract @UnknownKeyFor @NonNull @Initialized WatermarkParameters build();
    }
}

